/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.dataservice.integration;

import java.util.List;
import java.util.Map;
import org.apache.shindig.social.core.model.ActivityImpl;
import org.apache.shindig.social.dataservice.integration.AbstractLargeRestfulTests;
import org.apache.shindig.social.opensocial.model.Activity;
import org.apache.shindig.social.opensocial.util.XSDValidator;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Test;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestfulXmlActivityTest
extends AbstractLargeRestfulTests {
    private Activity johnsActivity;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.johnsActivity = new ActivityImpl("1", "john.doe");
        this.johnsActivity.setTitle("yellow");
        this.johnsActivity.setBody("what a color!");
    }

    @Test
    public void testGetActivityJson() throws Exception {
        String resp = this.getResponse("/activities/john.doe/@self/@app/1", "GET", "xml", "application/xml");
        XSDValidator.validateOpenSocial(resp);
        NodeList result = this.xp.getMatchingNodes("/:response/:activity", XMLUnit.buildTestDocument((String)resp));
        RestfulXmlActivityTest.assertEquals((int)1, (int)result.getLength());
        Node n = result.item(0);
        Map<String, List<String>> v = this.childNodesToMap(n);
        RestfulXmlActivityTest.assertEquals((int)4, (int)v.size());
        this.assertActivitiesEqual(this.johnsActivity, v);
    }

    @Test
    public void testGetActivitiesJson() throws Exception {
        String resp = this.getResponse("/activities/john.doe/@self", "GET", "xml", "application/xml");
        XSDValidator.validateOpenSocial(resp);
        RestfulXmlActivityTest.assertEquals((String)"0", (String)this.xp.evaluate("/:response/:startIndex", XMLUnit.buildTestDocument((String)resp)));
        RestfulXmlActivityTest.assertEquals((String)"1", (String)this.xp.evaluate("/:response/:totalResults", XMLUnit.buildTestDocument((String)resp)));
        NodeList nl = this.xp.getMatchingNodes("/:response/:entry/:activity", XMLUnit.buildTestDocument((String)resp));
        RestfulXmlActivityTest.assertEquals((int)1, (int)nl.getLength());
        this.assertActivitiesEqual(this.johnsActivity, this.childNodesToMap(nl.item(0)));
    }

    @Test
    public void testGetFriendsActivitiesJson() throws Exception {
        String resp = this.getResponse("/activities/john.doe/@friends", "GET", "xml", "application/xml");
        XSDValidator.validateOpenSocial(resp);
        RestfulXmlActivityTest.assertEquals((String)"0", (String)this.xp.evaluate("/:response/:startIndex", XMLUnit.buildTestDocument((String)resp)));
        RestfulXmlActivityTest.assertEquals((String)"2", (String)this.xp.evaluate("/:response/:totalResults", XMLUnit.buildTestDocument((String)resp)));
        NodeList nl = this.xp.getMatchingNodes("/:response/:entry", XMLUnit.buildTestDocument((String)resp));
        RestfulXmlActivityTest.assertEquals((int)2, (int)nl.getLength());
    }

    private void assertActivitiesEqual(Activity activity, Map<String, List<String>> result) {
        RestfulXmlActivityTest.assertEquals((String)activity.getId(), (String)result.get("id").get(0));
        RestfulXmlActivityTest.assertEquals((String)activity.getUserId(), (String)result.get("userId").get(0));
        RestfulXmlActivityTest.assertEquals((String)activity.getTitle(), (String)result.get("title").get(0));
        RestfulXmlActivityTest.assertEquals((String)activity.getBody(), (String)result.get("body").get(0));
    }

    @Test
    public void testCreateActivity() throws Exception {
        String postData = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<activity><body>and dad.</body><title>hi mom!</title></activity>";
        String createResponse = this.getResponse("/activities/john.doe/@self", "POST", postData, "xml", "application/xml");
        XSDValidator.validateOpenSocial(createResponse);
        String resp = this.getResponse("/activities/john.doe/@self", "GET", "xml", "application/xml");
        XSDValidator.validateOpenSocial(resp);
        RestfulXmlActivityTest.assertEquals((String)"0", (String)this.xp.evaluate("/:response/:startIndex", XMLUnit.buildTestDocument((String)resp)));
        RestfulXmlActivityTest.assertEquals((String)"2", (String)this.xp.evaluate("/:response/:totalResults", XMLUnit.buildTestDocument((String)resp)));
        NodeList nl = this.xp.getMatchingNodes("/:response/:entry/:activity", XMLUnit.buildTestDocument((String)resp));
        RestfulXmlActivityTest.assertEquals((int)2, (int)nl.getLength());
        Map<String, List<String>> v = this.childNodesToMap(nl.item(0));
        if (v.containsKey("id")) {
            v = this.childNodesToMap(nl.item(1));
        }
        RestfulXmlActivityTest.assertEquals((String)"hi mom!", (String)v.get("title").get(0));
        RestfulXmlActivityTest.assertEquals((String)"and dad.", (String)v.get("body").get(0));
    }
}

