/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.auth.AuthInfo;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.servlet.InjectedServlet;
import org.apache.shindig.common.util.ImmediateFuture;
import org.apache.shindig.social.ResponseError;
import org.apache.shindig.social.core.util.BeanJsonConverter;
import org.apache.shindig.social.opensocial.service.BeanConverter;
import org.apache.shindig.social.opensocial.service.DataRequestHandler;
import org.apache.shindig.social.opensocial.service.HandlerProvider;
import org.apache.shindig.social.opensocial.service.RequestItem;
import org.apache.shindig.social.opensocial.service.ResponseItem;
import org.apache.shindig.social.opensocial.spi.SocialSpiException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ApiServlet
extends InjectedServlet {
    protected static final String DEFAULT_ENCODING = "UTF-8";
    private Map<String, Provider<? extends DataRequestHandler>> handlers;
    protected BeanJsonConverter jsonConverter;
    protected BeanConverter xmlConverter;
    protected BeanConverter atomConverter;

    @Inject
    public void setHandlers(HandlerProvider handlers) {
        this.handlers = handlers.get();
    }

    @Inject
    public void setBeanConverters(@Named(value="shindig.bean.converter.json") BeanConverter jsonConverter, @Named(value="shindig.bean.converter.xml") BeanConverter xmlConverter, @Named(value="shindig.bean.converter.atom") BeanConverter atomConverter) {
        this.jsonConverter = (BeanJsonConverter)jsonConverter;
        this.xmlConverter = xmlConverter;
        this.atomConverter = atomConverter;
    }

    protected SecurityToken getSecurityToken(HttpServletRequest servletRequest) {
        return new AuthInfo(servletRequest).getSecurityToken();
    }

    protected abstract void sendError(HttpServletResponse var1, ResponseItem var2) throws IOException;

    protected void sendSecurityError(HttpServletResponse servletResponse) throws IOException {
        this.sendError(servletResponse, new ResponseItem(ResponseError.UNAUTHORIZED, "The request did not have a proper security token nor oauth message and unauthenticated requests are not allowed"));
    }

    protected Future<?> handleRequestItem(RequestItem requestItem, HttpServletRequest servletRequest) {
        Provider<? extends DataRequestHandler> handlerProvider = this.handlers.get(requestItem.getService());
        if (handlerProvider == null) {
            return ImmediateFuture.errorInstance((Throwable)new SocialSpiException(ResponseError.NOT_IMPLEMENTED, "The service " + requestItem.getService() + " is not implemented"));
        }
        DataRequestHandler handler = (DataRequestHandler)handlerProvider.get();
        return handler.handleItem(requestItem);
    }

    protected ResponseItem getResponseItem(Future<?> future) {
        ResponseItem response;
        try {
            Map result = future != null ? (Map)future.get() : null;
            response = new ResponseItem(result != null ? result : Collections.emptyMap());
        }
        catch (InterruptedException ie) {
            response = this.responseItemFromException(ie);
        }
        catch (ExecutionException ee) {
            response = this.responseItemFromException(ee.getCause());
        }
        return response;
    }

    protected ResponseItem responseItemFromException(Throwable t) {
        if (t instanceof SocialSpiException) {
            SocialSpiException spe = (SocialSpiException)t;
            return new ResponseItem(spe.getError(), spe.getMessage());
        }
        return new ResponseItem(ResponseError.INTERNAL_ERROR, t.getMessage());
    }

    protected void setCharacterEncodings(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        if (servletRequest.getCharacterEncoding() == null) {
            servletRequest.setCharacterEncoding(DEFAULT_ENCODING);
        }
        servletResponse.setCharacterEncoding(DEFAULT_ENCODING);
    }
}

