/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collections;
import java.util.Map;
import org.apache.shindig.social.opensocial.service.ActivityHandler;
import org.apache.shindig.social.opensocial.service.AppDataHandler;
import org.apache.shindig.social.opensocial.service.DataRequestHandler;
import org.apache.shindig.social.opensocial.service.PersonHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerProvider
implements Provider<Map<String, Provider<? extends DataRequestHandler>>> {
    private final Map<String, Provider<? extends DataRequestHandler>> handlers;

    @Inject
    public HandlerProvider(Provider<PersonHandler> personHandlerProvider, Provider<ActivityHandler> activityHandlerProvider, Provider<AppDataHandler> appDataHandlerProvider) {
        this(Maps.immutableMap((Object)"people", personHandlerProvider, (Object)"activities", activityHandlerProvider, (Object)"appdata", appDataHandlerProvider));
    }

    public HandlerProvider(Map<String, Provider<? extends DataRequestHandler>> handlers) {
        this.handlers = Maps.newHashMap(handlers);
    }

    public void addHandler(String path, Provider<? extends DataRequestHandler> handler) {
        this.handlers.put(path, handler);
    }

    public Map<String, Provider<? extends DataRequestHandler>> get() {
        return Collections.unmodifiableMap(this.handlers);
    }
}

