/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package org.apache.shindig.social.core.config;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import junit.framework.TestCase;

import org.apache.shindig.auth.AuthenticationHandler;
import org.apache.shindig.common.PropertiesModule;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.social.core.oauth.AuthenticationHandlerProvider;
import org.apache.shindig.social.opensocial.oauth.OAuthDataStore;
import org.easymock.EasyMock;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import com.google.common.collect.Maps;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;

public class SocialApiGuiceModuleTest extends TestCase {
  private Injector injector;

  @Override public void setUp() throws Exception {
    super.setUp();
    injector = Guice.createInjector(new SocialApiGuiceModule(), new PropertiesModule(), new ConfigModule());
  }
  
  protected static class FakeContainerConfig implements ContainerConfig {
    private final Map<String, String> properties = Maps.newHashMap();
     
    public boolean getBool(String container, String name) {
      // TODO Auto-generated method stub
      return false;
    }
  
    public Collection<String> getContainers() {
      // TODO Auto-generated method stub
      return null;
    }
  
    public int getInt(String container, String name) {
      // TODO Auto-generated method stub
      return 0;
    }
  
    public List<Object> getList(String container, String name) {
      // TODO Auto-generated method stub
      return null;
    }
  
    public Map<String, Object> getMap(String container, String name) {
      // TODO Auto-generated method stub
      return null;
    }
  
    public Map<String, Object> getProperties(String container) {
      // TODO Auto-generated method stub
      return null;
    }
  
    public Object getProperty(String container, String name) {
      // TODO Auto-generated method stub
      if (name.equals("gadgets.content-rewrite")) {
        try {
          JSONObject jsonObject = new JSONObject();
          JSONArray tags = new JSONArray();
          tags.put("embed");
          tags.put("img");
          tags.put("script");
          tags.put("link");
          tags.put("style");
          jsonObject.put("include-tags", tags);
          jsonObject.put("include-urls", ".*");
          jsonObject.put("exclude-urls", "");
          jsonObject.put("expires", "HTTP");
          jsonObject.put("proxy-url", "http://www.test.com/dir/proxy?url=");
          jsonObject.put("concat-url", "http://www.test.com/dir/concat?");
          return jsonObject;
        } catch (JSONException e) {}
     }
    return null;
    }
  
    public String getString(String container, String name) {
      // TODO Auto-generated method stub
      if(name.equals("gadgets.securityTokenType")) return "insecure";
      return properties.get(name);
    }
    
  }
  
  public class ConfigModule extends AbstractModule {
    /**
     * {@InheritDoc}
     */
    @Override
    protected void configure() {
      bind(ContainerConfig.class).to(FakeContainerConfig.class);
      bind(OAuthDataStore.class).toInstance(EasyMock.createMock(OAuthDataStore.class));
    }
  }
  
  /**
   * Test default auth handler injection
   */
  public void testAuthHandler() {
    injector.getInstance(AuthenticationHandlerProvider.class).get();

    AuthenticationHandlerProvider provider =
        injector.getInstance(AuthenticationHandlerProvider.class);
    assertEquals(3, provider.get().size());

    List<AuthenticationHandler> handlers = injector.getInstance(
        Key.get(new TypeLiteral<List<AuthenticationHandler>>(){}));
    assertEquals(3, handlers.size());
  }
}
