/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.util.xstream;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.AbstractCollectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.HashMap;
import java.util.Map;
import org.apache.shindig.social.opensocial.spi.DataCollection;

public class DataCollectionConverter
extends AbstractCollectionConverter {
    public DataCollectionConverter(Mapper mapper) {
        super(mapper);
    }

    public boolean canConvert(Class clazz) {
        boolean convert = DataCollection.class.isAssignableFrom(clazz);
        return convert;
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        DataCollection collection = (DataCollection)source;
        Map<String, Map<String, String>> internalMap = collection.getEntry();
        for (Map.Entry<String, Map<String, String>> eo : internalMap.entrySet()) {
            writer.startNode("entry");
            writer.startNode("key");
            writer.setValue(eo.getKey());
            writer.endNode();
            writer.startNode("value");
            for (Map.Entry<String, String> ei : eo.getValue().entrySet()) {
                writer.startNode("entry");
                writer.startNode("key");
                writer.setValue(ei.getKey());
                writer.endNode();
                writer.startNode("value");
                writer.setValue(ei.getValue());
                writer.endNode();
                writer.endNode();
            }
            writer.endNode();
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        reader.moveDown();
        HashMap<String, String> m = new HashMap<String, String>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String ok = null;
            Object ov = null;
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                String elname = reader.getNodeName();
                if ("key".equals(elname)) {
                    ok = reader.getValue();
                } else if ("value".equals(elname)) {
                    ov = reader.getValue();
                    if (reader.hasMoreChildren()) {
                        HashMap<String, String> innerMap = new HashMap<String, String>();
                        while (reader.hasMoreChildren()) {
                            reader.moveDown();
                            String k = null;
                            String v = null;
                            while (reader.hasMoreChildren()) {
                                reader.moveDown();
                                if ("key".equals(elname)) {
                                    k = reader.getValue();
                                } else if ("value".equals(elname)) {
                                    v = reader.getValue();
                                }
                                reader.moveUp();
                            }
                            innerMap.put(k, v);
                            reader.moveUp();
                        }
                        ov = innerMap;
                    }
                }
                reader.moveUp();
            }
            reader.moveUp();
            m.put(ok, (String)ov);
        }
        reader.moveUp();
        boolean nonmap = false;
        for (Map.Entry e : m.entrySet()) {
            if (!(e.getValue() instanceof String)) continue;
            nonmap = true;
        }
        HashMap<String, Map<String, String>> fm = new HashMap<String, Map<String, String>>();
        if (nonmap) {
            for (Map.Entry e : m.entrySet()) {
                if (e.getValue() instanceof Map) {
                    fm.put((String)e.getKey(), (Map)e.getValue());
                    continue;
                }
                HashMap mv = new HashMap();
                mv.put(e.getKey(), (String)e.getValue());
                fm.put((String)e.getKey(), mv);
            }
        } else {
            for (Map.Entry e : m.entrySet()) {
                fm.put((String)e.getKey(), (Map)e.getValue());
            }
        }
        return new DataCollection(fm);
    }
}

