/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.util.xstream;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.extended.ISO8601DateConverter;
import com.thoughtworks.xstream.converters.extended.ISO8601GregorianCalendarConverter;
import com.thoughtworks.xstream.converters.extended.ISO8601SqlTimestampConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.mapper.AttributeMapper;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shindig.social.core.model.EnumImpl;
import org.apache.shindig.social.core.util.atom.AtomAttribute;
import org.apache.shindig.social.core.util.atom.AtomAttributeConverter;
import org.apache.shindig.social.core.util.atom.AtomContent;
import org.apache.shindig.social.core.util.atom.AtomEntry;
import org.apache.shindig.social.core.util.atom.AtomFeed;
import org.apache.shindig.social.core.util.atom.AtomKeyValue;
import org.apache.shindig.social.core.util.atom.AtomLinkConverter;
import org.apache.shindig.social.core.util.xstream.ClassFieldMapping;
import org.apache.shindig.social.core.util.xstream.DataCollectionConverter;
import org.apache.shindig.social.core.util.xstream.GuiceBeanConverter;
import org.apache.shindig.social.core.util.xstream.ImplicitCollectionFieldMapping;
import org.apache.shindig.social.core.util.xstream.InterfaceClassMapper;
import org.apache.shindig.social.core.util.xstream.InterfaceFieldAliasMapping;
import org.apache.shindig.social.core.util.xstream.InterfaceFieldAliasingMapper;
import org.apache.shindig.social.core.util.xstream.MapConverter;
import org.apache.shindig.social.core.util.xstream.NamespaceSet;
import org.apache.shindig.social.core.util.xstream.RestfullCollectionConverter;
import org.apache.shindig.social.core.util.xstream.WriterStack;
import org.apache.shindig.social.core.util.xstream.XStreamConfiguration;
import org.apache.shindig.social.opensocial.model.Account;
import org.apache.shindig.social.opensocial.model.Activity;
import org.apache.shindig.social.opensocial.model.Address;
import org.apache.shindig.social.opensocial.model.BodyType;
import org.apache.shindig.social.opensocial.model.ListField;
import org.apache.shindig.social.opensocial.model.MediaItem;
import org.apache.shindig.social.opensocial.model.Message;
import org.apache.shindig.social.opensocial.model.Name;
import org.apache.shindig.social.opensocial.model.Organization;
import org.apache.shindig.social.opensocial.model.Person;
import org.apache.shindig.social.opensocial.model.Url;
import org.apache.shindig.social.opensocial.spi.DataCollection;
import org.apache.shindig.social.opensocial.spi.RestfulCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XStream081Configuration
implements XStreamConfiguration {
    private static final Map<XStreamConfiguration.ConverterSet, List<ClassFieldMapping>> listElementMappingList = new HashMap<XStreamConfiguration.ConverterSet, List<ClassFieldMapping>>();
    private static final Map<XStreamConfiguration.ConverterSet, List<ClassFieldMapping>> elementMappingList = new HashMap<XStreamConfiguration.ConverterSet, List<ClassFieldMapping>>();
    private static final Map<XStreamConfiguration.ConverterSet, Map<String, Class<?>[]>> omitMap = new HashMap<XStreamConfiguration.ConverterSet, Map<String, Class<?>[]>>();
    private static final Map<XStreamConfiguration.ConverterSet, Map<String, Class<?>>> elementClassMap = new HashMap();
    private static final Map<XStreamConfiguration.ConverterSet, List<ImplicitCollectionFieldMapping>> itemFieldMappings = new HashMap<XStreamConfiguration.ConverterSet, List<ImplicitCollectionFieldMapping>>();
    private static final Map<XStreamConfiguration.ConverterSet, List<InterfaceFieldAliasMapping>> fieldAliasMappingList = new HashMap<XStreamConfiguration.ConverterSet, List<InterfaceFieldAliasMapping>>();
    private static final Map<String, NamespaceSet> namepaces = new HashMap<String, NamespaceSet>();
    private static final String ATOM_NS = "http://www.w3.org/2005/Atom";
    private static final String OS_NS = "http://ns.opensocial.org/2008/opensocial";
    private static final String OSEARCH_NS = "http://a9.com/-/spec/opensearch/1.1";
    private Injector injector;

    @Inject
    public XStream081Configuration(Injector injector) {
        this.injector = injector;
    }

    private Map<String, Class<?>> getElementClassMap(XStreamConfiguration.ConverterSet c) {
        Map<String, Class<?>> ecm = elementClassMap.get((Object)c);
        if (ecm == null) {
            ecm = elementClassMap.get((Object)XStreamConfiguration.ConverterSet.DEFAULT);
        }
        return ecm;
    }

    private List<ClassFieldMapping> getElementMappingList(XStreamConfiguration.ConverterSet c) {
        List<ClassFieldMapping> eml = elementMappingList.get((Object)c);
        if (eml == null) {
            eml = elementMappingList.get((Object)XStreamConfiguration.ConverterSet.DEFAULT);
        }
        return eml;
    }

    private List<ClassFieldMapping> getListElementMappingList(XStreamConfiguration.ConverterSet c) {
        List<ClassFieldMapping> leml = listElementMappingList.get((Object)c);
        if (leml == null) {
            leml = listElementMappingList.get((Object)XStreamConfiguration.ConverterSet.DEFAULT);
        }
        return leml;
    }

    private Map<String, Class<?>[]> getOmitMap(XStreamConfiguration.ConverterSet c) {
        Map<String, Class<?>[]> om = omitMap.get((Object)c);
        if (om == null) {
            om = omitMap.get((Object)XStreamConfiguration.ConverterSet.DEFAULT);
        }
        return om;
    }

    private Converter[] getConverters(Mapper mapper, XStreamConfiguration.ConverterSet c) {
        return new Converter[]{new MapConverter(mapper), new RestfullCollectionConverter(mapper), new DataCollectionConverter(mapper), new AtomLinkConverter()};
    }

    private List<ImplicitCollectionFieldMapping> getItemFieldMappings(XStreamConfiguration.ConverterSet c) {
        List<ImplicitCollectionFieldMapping> om = itemFieldMappings.get((Object)c);
        if (om == null) {
            om = itemFieldMappings.get((Object)XStreamConfiguration.ConverterSet.DEFAULT);
        }
        return om;
    }

    private List<InterfaceFieldAliasMapping> getFieldAliasMappingList(XStreamConfiguration.ConverterSet c) {
        List<InterfaceFieldAliasMapping> om = fieldAliasMappingList.get((Object)c);
        if (om == null) {
            om = fieldAliasMappingList.get((Object)XStreamConfiguration.ConverterSet.DEFAULT);
        }
        return om;
    }

    @Override
    public XStreamConfiguration.ConverterConfig getConverterConfig(XStreamConfiguration.ConverterSet c, ReflectionProvider rp, Mapper dmapper, HierarchicalStreamDriver driver, WriterStack writerStack) {
        InterfaceFieldAliasingMapper emapper = new InterfaceFieldAliasingMapper(dmapper, writerStack, this.getFieldAliasMappingList(c));
        InterfaceClassMapper fmapper = new InterfaceClassMapper(writerStack, (Mapper)emapper, this.getElementMappingList(c), this.getListElementMappingList(c), this.getItemFieldMappings(c), this.getOmitMap(c), this.getElementClassMap(c));
        AttributeMapper amapper = new AttributeMapper((Mapper)fmapper);
        XStream xstream = new XStream(rp, (Mapper)amapper, driver);
        amapper.addAttributeFor(AtomAttribute.class);
        for (Converter converter : this.getConverters((Mapper)fmapper, c)) {
            xstream.registerConverter(converter);
        }
        xstream.registerConverter((SingleValueConverter)new ISO8601DateConverter());
        xstream.registerConverter((SingleValueConverter)new ISO8601GregorianCalendarConverter());
        xstream.registerConverter((SingleValueConverter)new ISO8601SqlTimestampConverter());
        xstream.registerConverter((Converter)new GuiceBeanConverter((Mapper)fmapper, this.injector));
        xstream.registerConverter((SingleValueConverter)new AtomAttributeConverter());
        xstream.setMode(1001);
        return new XStreamConfiguration.ConverterConfig(fmapper, xstream);
    }

    @Override
    public Map<String, NamespaceSet> getNameSpaces() {
        return namepaces;
    }

    static {
        NamespaceSet atom = new NamespaceSet();
        atom.addNamespace("xmlns", ATOM_NS);
        atom.addNamespace("xmlos:osearch", OSEARCH_NS);
        atom.addPrefixedElement("totalResults", "osearch:totalResults");
        atom.addPrefixedElement("startIndex", "osearch:startIndex");
        atom.addPrefixedElement("itemsPerPage", "osearch:itemsPerPage");
        namepaces.put("feed", atom);
        NamespaceSet os = new NamespaceSet();
        atom.addNamespace("xmlns", OS_NS);
        namepaces.put("person", os);
        namepaces.put("activity", os);
        namepaces.put("account", os);
        namepaces.put("address", os);
        namepaces.put("bodyType", os);
        namepaces.put("message", os);
        namepaces.put("mediaItem", os);
        namepaces.put("name", os);
        namepaces.put("url", os);
        namepaces.put("reponse", os);
        namepaces.put("appdata", os);
        ArrayList<ClassFieldMapping> defaultElementMappingList = new ArrayList<ClassFieldMapping>();
        defaultElementMappingList.add(new ClassFieldMapping("feed", AtomFeed.class));
        defaultElementMappingList.add(new ClassFieldMapping("content", AtomContent.class));
        defaultElementMappingList.add(new ClassFieldMapping("activity", Activity.class));
        defaultElementMappingList.add(new ClassFieldMapping("account", Account.class));
        defaultElementMappingList.add(new ClassFieldMapping("address", Address.class));
        defaultElementMappingList.add(new ClassFieldMapping("bodyType", BodyType.class));
        defaultElementMappingList.add(new ClassFieldMapping("message", Message.class));
        defaultElementMappingList.add(new ClassFieldMapping("mediaItem", MediaItem.class));
        defaultElementMappingList.add(new ClassFieldMapping("name", Name.class));
        defaultElementMappingList.add(new ClassFieldMapping("organization", Organization.class));
        defaultElementMappingList.add(new ClassFieldMapping("person", Person.class));
        defaultElementMappingList.add(new ClassFieldMapping("url", Url.class));
        defaultElementMappingList.add(new ClassFieldMapping("ListField", ListField.class));
        defaultElementMappingList.add(new ClassFieldMapping("response", RestfulCollection.class));
        defaultElementMappingList.add(new ClassFieldMapping("appdata", DataCollection.class));
        defaultElementMappingList.add(new ClassFieldMapping("list", List.class));
        defaultElementMappingList.add(new ClassFieldMapping("map", Map.class));
        elementMappingList.put(XStreamConfiguration.ConverterSet.DEFAULT, defaultElementMappingList);
        ArrayList<ClassFieldMapping> collectionElementMappingList = new ArrayList<ClassFieldMapping>();
        collectionElementMappingList.add(new ClassFieldMapping("feed", AtomFeed.class));
        collectionElementMappingList.add(new ClassFieldMapping("content", AtomContent.class));
        collectionElementMappingList.add(new ClassFieldMapping("activity", Activity.class));
        collectionElementMappingList.add(new ClassFieldMapping("account", Account.class));
        collectionElementMappingList.add(new ClassFieldMapping("address", Address.class));
        collectionElementMappingList.add(new ClassFieldMapping("bodyType", BodyType.class));
        collectionElementMappingList.add(new ClassFieldMapping("message", Message.class));
        collectionElementMappingList.add(new ClassFieldMapping("mediaItem", MediaItem.class));
        collectionElementMappingList.add(new ClassFieldMapping("name", Name.class));
        collectionElementMappingList.add(new ClassFieldMapping("organization", Organization.class));
        collectionElementMappingList.add(new ClassFieldMapping("person", Person.class));
        collectionElementMappingList.add(new ClassFieldMapping("url", Url.class));
        collectionElementMappingList.add(new ClassFieldMapping("ListField", ListField.class));
        collectionElementMappingList.add(new ClassFieldMapping("response", RestfulCollection.class));
        collectionElementMappingList.add(new ClassFieldMapping("list", List.class));
        collectionElementMappingList.add(new ClassFieldMapping("map", Map.class));
        elementMappingList.put(XStreamConfiguration.ConverterSet.COLLECTION, collectionElementMappingList);
        HashMap<String, Class[]> defaultOmitMap = new HashMap<String, Class[]>();
        defaultOmitMap.put("isOwner", new Class[]{Person.class});
        defaultOmitMap.put("isViewer", new Class[]{Person.class});
        omitMap.put(XStreamConfiguration.ConverterSet.DEFAULT, defaultOmitMap);
        HashMap<String, Class<ListField>> defaultElementClassMap = new HashMap<String, Class<ListField>>();
        defaultElementClassMap.put("feed", AtomFeed.class);
        defaultElementClassMap.put("content", AtomContent.class);
        defaultElementClassMap.put("person", Person.class);
        defaultElementClassMap.put("email", ListField.class);
        defaultElementClassMap.put("phone", ListField.class);
        defaultElementClassMap.put("list", ArrayList.class);
        defaultElementClassMap.put("map", ConcurrentHashMap.class);
        defaultElementClassMap.put("appdata", DataCollection.class);
        defaultElementClassMap.put("activity", Activity.class);
        defaultElementClassMap.put("account", Account.class);
        defaultElementClassMap.put("address", Address.class);
        defaultElementClassMap.put("bodyType", BodyType.class);
        defaultElementClassMap.put("message", Message.class);
        defaultElementClassMap.put("mediaItem", MediaItem.class);
        defaultElementClassMap.put("name", Name.class);
        defaultElementClassMap.put("organization", Organization.class);
        defaultElementClassMap.put("person", Person.class);
        defaultElementClassMap.put("url", Url.class);
        defaultElementClassMap.put("listField", ListField.class);
        elementClassMap.put(XStreamConfiguration.ConverterSet.DEFAULT, defaultElementClassMap);
        ArrayList<ImplicitCollectionFieldMapping> defaultItemFieldMappings = new ArrayList<ImplicitCollectionFieldMapping>();
        defaultItemFieldMappings.add(new ImplicitCollectionFieldMapping(AtomFeed.class, "entry", AtomEntry.class, "entry"));
        defaultItemFieldMappings.add(new ImplicitCollectionFieldMapping(AtomContent.class, "entry", AtomKeyValue.class, "entry"));
        defaultItemFieldMappings.add(new ImplicitCollectionFieldMapping(Person.class, "books", String.class, "books"));
        defaultItemFieldMappings.add(new ImplicitCollectionFieldMapping(Person.class, "cars", String.class, "cars"));
        defaultItemFieldMappings.add(new ImplicitCollectionFieldMapping(Person.class, "heroes", String.class, "heroes"));
        defaultItemFieldMappings.add(new ImplicitCollectionFieldMapping(Person.class, "food", String.class, "food"));
        defaultItemFieldMappings.add(new ImplicitCollectionFieldMapping(Person.class, "interests", String.class, "interests"));
        defaultItemFieldMappings.add(new ImplicitCollectionFieldMapping(Person.class, "languagesSpoken", String.class, "languagesSpoken"));
        defaultItemFieldMappings.add(new ImplicitCollectionFieldMapping(Person.class, "movies", String.class, "movies"));
        defaultItemFieldMappings.add(new ImplicitCollectionFieldMapping(Person.class, "music", String.class, "music"));
        defaultItemFieldMappings.add(new ImplicitCollectionFieldMapping(Person.class, "quotes", String.class, "quotes"));
        defaultItemFieldMappings.add(new ImplicitCollectionFieldMapping(Person.class, "sports", String.class, "sports"));
        defaultItemFieldMappings.add(new ImplicitCollectionFieldMapping(Person.class, "tags", String.class, "tags"));
        defaultItemFieldMappings.add(new ImplicitCollectionFieldMapping(Person.class, "turnOns", String.class, "turnOns"));
        defaultItemFieldMappings.add(new ImplicitCollectionFieldMapping(Person.class, "turnOffs", String.class, "turnOffs"));
        defaultItemFieldMappings.add(new ImplicitCollectionFieldMapping(Person.class, "tvShows", String.class, "tvShows"));
        defaultItemFieldMappings.add(new ImplicitCollectionFieldMapping(Person.class, "emails", ListField.class, "emails"));
        defaultItemFieldMappings.add(new ImplicitCollectionFieldMapping(Person.class, "phoneNumbers", ListField.class, "phoneNumbers"));
        defaultItemFieldMappings.add(new ImplicitCollectionFieldMapping(Person.class, "ims", ListField.class, "ims"));
        defaultItemFieldMappings.add(new ImplicitCollectionFieldMapping(Person.class, "photos", ListField.class, "photos"));
        defaultItemFieldMappings.add(new ImplicitCollectionFieldMapping(Person.class, "activities", Activity.class, "activities"));
        defaultItemFieldMappings.add(new ImplicitCollectionFieldMapping(Person.class, "addresses", Address.class, "addresses"));
        defaultItemFieldMappings.add(new ImplicitCollectionFieldMapping(Person.class, "organizations", Organization.class, "organizations"));
        defaultItemFieldMappings.add(new ImplicitCollectionFieldMapping(Person.class, "urls", Url.class, "urls"));
        defaultItemFieldMappings.add(new ImplicitCollectionFieldMapping(Person.class, "lookingFor", EnumImpl.class, "lookingFor"));
        defaultItemFieldMappings.add(new ImplicitCollectionFieldMapping(Activity.class, "mediaItems", MediaItem.class, "mediaItems"));
        itemFieldMappings.put(XStreamConfiguration.ConverterSet.DEFAULT, defaultItemFieldMappings);
        ArrayList defaultListElementMappingList = new ArrayList();
        listElementMappingList.put(XStreamConfiguration.ConverterSet.DEFAULT, defaultListElementMappingList);
        ArrayList defaultFieldAliasMappingList = new ArrayList();
        fieldAliasMappingList.put(XStreamConfiguration.ConverterSet.DEFAULT, defaultFieldAliasMappingList);
    }
}

