/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.sample.service;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.concurrent.Future;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.shindig.common.util.ImmediateFuture;
import org.apache.shindig.social.ResponseError;
import org.apache.shindig.social.opensocial.service.DataRequestHandler;
import org.apache.shindig.social.opensocial.service.RequestItem;
import org.apache.shindig.social.opensocial.spi.SocialSpiException;
import org.apache.shindig.social.sample.spi.JsonDbOpensocialService;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleContainerHandler
extends DataRequestHandler {
    private final JsonDbOpensocialService service;
    private static final String POST_PATH = "/samplecontainer/{type}/{doevil}";

    @Inject
    public SampleContainerHandler(JsonDbOpensocialService dbService) {
        this.service = dbService;
    }

    @Override
    protected Future<?> handleDelete(RequestItem request) throws SocialSpiException {
        throw new SocialSpiException(ResponseError.NOT_IMPLEMENTED, null);
    }

    @Override
    protected Future<?> handlePut(RequestItem request) throws SocialSpiException {
        return this.handlePost(request);
    }

    @Override
    protected Future<?> handlePost(RequestItem request) throws SocialSpiException {
        request.applyUrlTemplate(POST_PATH);
        String type = request.getParameter("type");
        if (type.equals("setstate")) {
            try {
                String stateFile = request.getParameter("fileurl");
                this.service.setDb(new JSONObject(this.fetchStateDocument(stateFile)));
            }
            catch (JSONException e) {
                throw new SocialSpiException(ResponseError.BAD_REQUEST, "The json state file was not valid json", e);
            }
        } else if (type.equals("setevilness")) {
            throw new SocialSpiException(ResponseError.NOT_IMPLEMENTED, "evil data has not been implemented yet");
        }
        return ImmediateFuture.newInstance(null);
    }

    @Override
    protected Future<?> handleGet(RequestItem request) {
        return ImmediateFuture.newInstance((Object)this.service.getDb());
    }

    private String fetchStateDocument(String stateFileLocation) {
        String errorMessage = "The json state file " + stateFileLocation + " could not be fetched and parsed.";
        GetMethod jsonState = new GetMethod(stateFileLocation);
        HttpClient client = new HttpClient();
        try {
            client.executeMethod((HttpMethod)jsonState);
            if (jsonState.getStatusCode() != 200) {
                throw new RuntimeException(errorMessage);
            }
            String string = jsonState.getResponseBodyAsString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(errorMessage, e);
        }
        finally {
            jsonState.releaseConnection();
        }
    }
}

