/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.alert;

import java.util.HashMap;
import java.util.Map;
import org.apache.sirona.status.NodeStatus;
import org.apache.sirona.status.ValidationResult;

public interface AlertListener {
    public void onAlert(Alert var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Alert {
        private final String marker;
        private final NodeStatus status;

        protected Alert(String node, NodeStatus status) {
            this.marker = node;
            this.status = status;
        }

        public String getMarker() {
            return this.marker;
        }

        public NodeStatus getStatus() {
            return this.status;
        }

        public Map<String, Object> asMap() {
            String ln = System.getProperty("line.separator");
            StringBuilder csv = new StringBuilder();
            for (ValidationResult result : this.status.getResults()) {
                csv.append(result.getName()).append(";").append(result.getMessage()).append(";").append(result.getStatus().name()).append(ln);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("marker", this.marker == null ? "-" : this.marker);
            map.put("status", this.status.getStatus().name());
            map.put("date", this.status.getDate());
            map.put("resultsLength", this.status.getResults().length);
            map.put("resultsCsv", csv.toString());
            return map;
        }
    }
}

