/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.configuration.ioc;

import java.beans.Introspector;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sirona.SironaException;
import org.apache.sirona.configuration.Configuration;
import org.apache.sirona.configuration.ioc.AutoSet;
import org.apache.sirona.configuration.ioc.Created;
import org.apache.sirona.configuration.ioc.Destroying;
import org.apache.sirona.util.ClassLoaders;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IoCs {
    private static final Map<Class<?>, Object> SINGLETONS = new ConcurrentHashMap();
    private static final Collection<ToDestroy> INSTANCES = new ArrayList<ToDestroy>();
    public static final String SETTER_PREFIX = "set";
    private static Thread shutdownHook = null;

    public static <T> T[] newInstances(Class<T> api) {
        String names = Configuration.getProperty(api.getName(), null);
        if (names == null) {
            return (Object[])Array.newInstance(api, 0);
        }
        String[] split = names.split(",");
        Object[] array = (Object[])Array.newInstance(api, split.length);
        for (int i = 0; i < array.length; ++i) {
            try {
                array[i] = IoCs.newInstance(api, split[i]);
                continue;
            }
            catch (Exception e) {
                throw new SironaException(e);
            }
        }
        return array;
    }

    public static synchronized <T> T findOrCreateInstance(Class<T> clazz) {
        T t = clazz.cast(SINGLETONS.get(clazz));
        if (t != null) {
            return t;
        }
        return IoCs.newInstance(clazz);
    }

    public static synchronized <T> T newInstance(Class<T> clazz) {
        String config = Configuration.getProperty(clazz.getName(), null);
        try {
            if (config == null) {
                config = clazz.isInterface() ? clazz.getPackage().getName() + ".Default" + clazz.getSimpleName() : clazz.getName();
            }
            T t = IoCs.newInstance(clazz, config);
            SINGLETONS.put(clazz, t);
            return t;
        }
        catch (Exception e) {
            throw new SironaException("Cannot find instance for class " + clazz.getName() + " with config : " + config + " : " + e.getMessage(), e);
        }
    }

    private static <T> T newInstance(Class<T> clazz, String config) throws Exception {
        Class<Object> loadedClass;
        try {
            loadedClass = ClassLoaders.current().loadClass(config);
        }
        catch (Throwable throwable) {
            loadedClass = clazz;
        }
        return clazz.cast(IoCs.internalProcessInstance(loadedClass.newInstance()));
    }

    public static <T> T processInstance(T instance) {
        try {
            return IoCs.internalProcessInstance(instance);
        }
        catch (Exception e) {
            throw new SironaException(e);
        }
    }

    private static <T> T internalProcessInstance(T instance) throws Exception {
        Class<?> loadedClass = instance.getClass();
        if (loadedClass.getAnnotation(AutoSet.class) != null) {
            IoCs.autoSet(null, instance, loadedClass);
        }
        for (Class<?> clazz = loadedClass; clazz != null && !Object.class.equals(clazz); clazz = clazz.getSuperclass()) {
            for (Method m : clazz.getDeclaredMethods()) {
                if (m.getAnnotation(Created.class) != null) {
                    m.setAccessible(true);
                    m.invoke(instance, new Object[0]);
                    continue;
                }
                if (m.getAnnotation(Destroying.class) == null) continue;
                m.setAccessible(true);
                if (shutdownHook == null == Configuration.is("org.apache.sirona.shutdown.hook", true)) {
                    shutdownHook = new Thread(){

                        public void run() {
                            IoCs.shutdown();
                        }
                    };
                    Runtime.getRuntime().addShutdownHook(shutdownHook);
                }
                INSTANCES.add(new ToDestroy(m, instance));
            }
        }
        return instance;
    }

    public static <T> T autoSet(T instance) throws Exception {
        return IoCs.autoSet(null, instance);
    }

    public static <T> T autoSet(String key, T instance) throws Exception {
        return IoCs.autoSet(key, instance, instance.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T autoSet(String key, T instance, Class<?> loadedClass) throws Exception {
        for (Class<?> current = loadedClass; current != null && !current.isInterface() && !Object.class.equals(current); current = current.getSuperclass()) {
            LinkedList<String> done = new LinkedList<String>();
            for (Method method : current.getDeclaredMethods()) {
                if (!Void.TYPE.equals(method.getReturnType()) || !method.getName().startsWith(SETTER_PREFIX) || method.getParameterTypes().length != 1 || Modifier.isStatic(method.getModifiers())) continue;
                String name = Introspector.decapitalize(method.getName().substring(3));
                String configKey = key == null ? loadedClass.getName() + "." + name : key + "." + name;
                String value = Configuration.getProperty(configKey, null);
                if (value == null) continue;
                done.add(name);
                boolean acc = method.isAccessible();
                if (!acc) {
                    method.setAccessible(true);
                }
                try {
                    method.invoke(instance, IoCs.convertTo(method.getParameterTypes()[0], value));
                }
                finally {
                    if (!acc) {
                        method.setAccessible(false);
                    }
                }
            }
            for (AccessibleObject accessibleObject : current.getDeclaredFields()) {
                String configKey;
                String value;
                if (Modifier.isFinal(((Field)accessibleObject).getModifiers()) || done.contains(((Field)accessibleObject).getName()) || (value = Configuration.getProperty(configKey = key == null ? loadedClass.getName() + "." + ((Field)accessibleObject).getName() : key + "." + ((Field)accessibleObject).getName(), null)) == null) continue;
                done.add(((Field)accessibleObject).getName());
                boolean acc = accessibleObject.isAccessible();
                if (!acc) {
                    ((Field)accessibleObject).setAccessible(true);
                }
                try {
                    ((Field)accessibleObject).set(instance, IoCs.convertTo(((Field)accessibleObject).getType(), value));
                }
                finally {
                    if (!acc) {
                        ((Field)accessibleObject).setAccessible(false);
                    }
                }
            }
        }
        return instance;
    }

    public static void setSingletonInstance(Class<?> clazz, Object instance) {
        if (instance == null) {
            SINGLETONS.remove(clazz);
            return;
        }
        SINGLETONS.put(clazz, instance);
    }

    public static <T> T getInstance(Class<T> clazz) {
        return clazz.cast(SINGLETONS.get(clazz));
    }

    public static <T> T getInstance(Class<T> clazz, String className) {
        try {
            Class<?> tClass = ClassLoaders.current().loadClass(className);
            return (T)tClass.newInstance();
        }
        catch (Exception e) {
            throw new SironaException("cannot instantiante instance of '" + className + "'", e);
        }
    }

    public static void shutdown() {
        for (ToDestroy c : INSTANCES) {
            c.destroy();
        }
        INSTANCES.clear();
        SINGLETONS.clear();
    }

    private static Object convertTo(Class<?> type, String value) {
        if (String.class.equals(type)) {
            return value;
        }
        if (String[].class.equals(type)) {
            return value.split(",");
        }
        if (Integer.TYPE.equals(type)) {
            return Integer.parseInt(value);
        }
        if (Long.TYPE.equals(type)) {
            return Long.parseLong(value);
        }
        if (Boolean.TYPE.equals(type)) {
            return Boolean.parseBoolean(value);
        }
        throw new IllegalArgumentException("Type " + type.getName() + " not supported");
    }

    private IoCs() {
    }

    private static class ToDestroy {
        private final Method method;
        private final Object target;

        public ToDestroy(Method m, Object instance) {
            this.method = m;
            this.target = instance;
        }

        public void destroy() {
            try {
                this.method.invoke(this.target, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

