/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.reporting.web;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/environment")
public class Environment {
    @GET
    @Path(value="/os")
    @Produces(value={"application/json", "application/xml"})
    public Os getOs() {
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        return new Os(os.getArch(), os.getName(), os.getVersion(), os.getAvailableProcessors());
    }

    @GET
    @Path(value="/memory")
    @Produces(value={"application/json", "application/xml"})
    public Memory getMemory() {
        MemoryMXBean memory = ManagementFactory.getMemoryMXBean();
        return new Memory(memory.getHeapMemoryUsage().getMax(), memory.getHeapMemoryUsage().getInit(), memory.getNonHeapMemoryUsage().getMax(), memory.getNonHeapMemoryUsage().getInit());
    }

    public static class Memory
    implements Serializable {
        private long maxMemory;
        private long initMemory;
        private long maxNonHeapMemory;
        private long initNonHeapMemory;

        public Memory() {
        }

        public Memory(long maxMemory, long initMemory, long maxNonHeapMemory, long initNonHeapMemory) {
            this.maxMemory = maxMemory;
            this.initMemory = initMemory;
            this.maxNonHeapMemory = maxNonHeapMemory;
            this.initNonHeapMemory = initNonHeapMemory;
        }

        public long getMaxMemory() {
            return this.maxMemory;
        }

        public void setMaxMemory(long maxMemory) {
            this.maxMemory = maxMemory;
        }

        public long getInitMemory() {
            return this.initMemory;
        }

        public void setInitMemory(long initMemory) {
            this.initMemory = initMemory;
        }

        public long getMaxNonHeapMemory() {
            return this.maxNonHeapMemory;
        }

        public void setMaxNonHeapMemory(long maxNonHeapMemory) {
            this.maxNonHeapMemory = maxNonHeapMemory;
        }

        public long getInitNonHeapMemory() {
            return this.initNonHeapMemory;
        }

        public void setInitNonHeapMemory(long initNonHeapMemory) {
            this.initNonHeapMemory = initNonHeapMemory;
        }
    }

    public static class Os
    implements Serializable {
        private String arch;
        private String name;
        private String version;
        private int numberProcessor;

        public Os() {
        }

        public Os(String arch, String name, String version, int numberProcessor) {
            this.arch = arch;
            this.name = name;
            this.version = version;
            this.numberProcessor = numberProcessor;
        }

        public String getArch() {
            return this.arch;
        }

        public void setArch(String arch) {
            this.arch = arch;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public int getNumberProcessor() {
            return this.numberProcessor;
        }

        public void setNumberProcessor(int numberProcessor) {
            this.numberProcessor = numberProcessor;
        }
    }
}

