/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.store.memory.counter;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.sirona.counters.Counter;
import org.apache.sirona.math.M2AwareStatisticalSummary;
import org.apache.sirona.store.counter.AggregatedCollectorCounter;
import org.apache.sirona.store.counter.CollectorCounterStore;
import org.apache.sirona.store.counter.LeafCollectorCounter;
import org.apache.sirona.store.memory.counter.InMemoryCounterDataStore;

public class InMemoryCollectorCounterStore
extends InMemoryCounterDataStore
implements CollectorCounterStore {
    private final ConcurrentMap<String, ConcurrentMap<Counter.Key, LeafCollectorCounter>> countersByMarker = new ConcurrentHashMap<String, ConcurrentMap<Counter.Key, LeafCollectorCounter>>();

    public void update(Counter.Key key, String marker, M2AwareStatisticalSummary stats, int concurrency) {
        this.getOrCreateCounter(key, marker).update(stats, concurrency);
        this.getOrCreateCounter(key).update();
    }

    public Collection<String> markers() {
        return this.countersByMarker.keySet();
    }

    public Collection<? extends LeafCollectorCounter> getCounters(String marker) {
        return ((ConcurrentMap)this.countersByMarker.get(marker)).values();
    }

    public LeafCollectorCounter getOrCreateCounter(Counter.Key key, String marker) {
        LeafCollectorCounter counter;
        ConcurrentMap<Object, Object> subCounters = (ConcurrentHashMap<Counter.Key, LeafCollectorCounter>)this.countersByMarker.get(marker);
        if (subCounters == null) {
            ConcurrentHashMap<Counter.Key, LeafCollectorCounter> map = new ConcurrentHashMap<Counter.Key, LeafCollectorCounter>(50);
            ConcurrentMap existing = this.countersByMarker.putIfAbsent(marker, map);
            subCounters = existing != null ? existing : map;
        }
        if ((counter = (LeafCollectorCounter)subCounters.get(key)) == null) {
            counter = new LeafCollectorCounter(key);
            LeafCollectorCounter previous = subCounters.putIfAbsent(key, counter);
            if (previous != null) {
                counter = previous;
            }
            AggregatedCollectorCounter aggregate = (AggregatedCollectorCounter)AggregatedCollectorCounter.class.cast(super.getOrCreateCounter(key));
            aggregate.addIfMissing(marker, counter);
        }
        return counter;
    }

    @Override
    protected Counter newCounter(Counter.Key key) {
        return new AggregatedCollectorCounter(key);
    }

    public AggregatedCollectorCounter getOrCreateCounter(Counter.Key key) {
        return (AggregatedCollectorCounter)AggregatedCollectorCounter.class.cast(super.getOrCreateCounter(key));
    }

    @Override
    public void clearCounters() {
        for (Map.Entry maps : this.countersByMarker.entrySet()) {
            ((ConcurrentMap)maps.getValue()).clear();
        }
        this.countersByMarker.clear();
        super.clearCounters();
    }

    @Override
    public void addToCounter(Counter defaultCounter, double delta) {
        throw new UnsupportedOperationException("shouldn't be used");
    }
}

