/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature;

import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.OperatorImportFromWkt;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import java.util.Iterator;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.math.Vector;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.util.Classes;

final class ESRI
extends Geometries<Geometry> {
    ESRI() {
        super(GeometryLibrary.ESRI, Geometry.class, Point.class, Polyline.class, Polygon.class);
    }

    @Override
    final String tryGetLabel(Object object) {
        return object instanceof Geometry ? Classes.getShortClassName((Object)object) : null;
    }

    @Override
    final GeneralEnvelope tryGetEnvelope(Object object) {
        if (object instanceof Geometry) {
            Envelope2D envelope2D = new Envelope2D();
            ((Geometry)object).queryEnvelope2D(envelope2D);
            if (!envelope2D.isEmpty()) {
                GeneralEnvelope generalEnvelope = new GeneralEnvelope(2);
                generalEnvelope.setRange(0, envelope2D.xmin, envelope2D.xmax);
                generalEnvelope.setRange(1, envelope2D.ymin, envelope2D.ymax);
                return generalEnvelope;
            }
        }
        return null;
    }

    @Override
    final double[] tryGetCoordinate(Object object) {
        if (object instanceof Point) {
            double[] dArray;
            Point point = (Point)object;
            double d = point.getZ();
            if (Double.isNaN(d)) {
                dArray = new double[2];
            } else {
                dArray = new double[3];
                dArray[2] = d;
            }
            dArray[1] = point.getY();
            dArray[0] = point.getX();
            return dArray;
        }
        return null;
    }

    @Override
    public Object createPoint(double d, double d2) {
        return new Point(d, d2, Double.NaN);
    }

    @Override
    public Geometry createPolyline(int n, Vector ... vectorArray) {
        if (n != 2) {
            throw ESRI.unsupported(n);
        }
        boolean bl = false;
        Polyline polyline = new Polyline();
        for (Vector vector : vectorArray) {
            if (vector == null) continue;
            int n2 = vector.size();
            int n3 = 0;
            while (n3 < n2) {
                double d = vector.doubleValue(n3++);
                double d2 = vector.doubleValue(n3++);
                if (Double.isNaN(d) || Double.isNaN(d2)) {
                    bl = false;
                    continue;
                }
                if (bl) {
                    polyline.lineTo(d, d2);
                    continue;
                }
                polyline.startPath(d, d2);
                bl = true;
            }
        }
        return polyline;
    }

    @Override
    final Geometry tryMergePolylines(Object object, Iterator<?> iterator) {
        if (!(object instanceof MultiPath) && !(object instanceof Point)) {
            return null;
        }
        Polyline polyline = new Polyline();
        boolean bl = false;
        while (true) {
            if (object != null) {
                if (object instanceof Point) {
                    double d = ((Point)object).getX();
                    double d2 = ((Point)object).getY();
                    if (Double.isNaN(d) || Double.isNaN(d2)) {
                        bl = false;
                    } else if (bl) {
                        polyline.lineTo(d, d2);
                    } else {
                        polyline.startPath(d, d2);
                        bl = true;
                    }
                } else {
                    polyline.add((MultiPath)object, false);
                    bl = false;
                }
            }
            if (!iterator.hasNext()) break;
            object = iterator.next();
        }
        return polyline;
    }

    @Override
    public Object parseWKT(String string) {
        return OperatorImportFromWkt.local().execute(0, Geometry.Type.Unknown, string, null);
    }
}

