/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata;

import javax.measure.quantity.Angle;
import javax.measure.unit.Unit;
import org.apache.sis.internal.util.PatchedUnitFormat;
import org.apache.sis.measure.Units;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.Static;
import org.apache.sis.util.iso.Types;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.util.CodeList;

public final class AxisDirections
extends Static {
    public static final int COMPASS_COUNT = 16;
    public static final int GEOCENTRIC_COUNT = 3;
    public static final int DISPLAY_COUNT = 4;
    private static final AxisDirection[] OPPOSITES = new AxisDirection[AxisDirection.DISPLAY_DOWN.ordinal() + 1];
    private static final int LAST_ORDINAL;
    private static final byte[] DISPLAY_ORDER;

    private static void put(AxisDirection axisDirection, AxisDirection axisDirection2) {
        AxisDirections.OPPOSITES[axisDirection.ordinal()] = axisDirection2;
        AxisDirections.OPPOSITES[axisDirection2.ordinal()] = axisDirection;
    }

    private AxisDirections() {
    }

    public static AxisDirection absolute(AxisDirection axisDirection) {
        AxisDirection axisDirection2 = AxisDirections.opposite(axisDirection);
        if (axisDirection2 != null && axisDirection2.ordinal() < axisDirection.ordinal()) {
            return axisDirection2;
        }
        return axisDirection;
    }

    public static AxisDirection opposite(AxisDirection axisDirection) {
        int n;
        if (axisDirection != null && (n = axisDirection.ordinal()) >= 0 && n < OPPOSITES.length) {
            axisDirection = OPPOSITES[n];
        }
        return axisDirection;
    }

    public static boolean isOpposite(AxisDirection axisDirection) {
        AxisDirection axisDirection2 = AxisDirections.opposite(axisDirection);
        return axisDirection2 != null && axisDirection2.ordinal() < axisDirection.ordinal();
    }

    public static boolean isCompass(AxisDirection axisDirection) {
        if (axisDirection == null) {
            return false;
        }
        int n = axisDirection.ordinal() - AxisDirection.NORTH.ordinal();
        return n >= 0 && n < 16;
    }

    public static boolean isIntercardinal(AxisDirection axisDirection) {
        if (axisDirection == null) {
            return false;
        }
        int n = axisDirection.ordinal() - AxisDirection.NORTH.ordinal();
        return n >= 0 && n < 16 && (n & 3) != 0;
    }

    public static boolean isVertical(AxisDirection axisDirection) {
        if (axisDirection == null) {
            return false;
        }
        return (axisDirection.ordinal() - AxisDirection.UP.ordinal() & 0xFFFFFFFE) == 0;
    }

    public static boolean isGeocentric(AxisDirection axisDirection) {
        if (axisDirection == null) {
            return false;
        }
        int n = axisDirection.ordinal();
        return n >= AxisDirection.GEOCENTRIC_X.ordinal() && n <= AxisDirection.GEOCENTRIC_Z.ordinal();
    }

    public static boolean isSpatialOrUserDefined(AxisDirection axisDirection, boolean bl) {
        if (axisDirection == null) {
            return false;
        }
        int n = axisDirection.ordinal();
        return n < AxisDirection.FUTURE.ordinal() || n > (bl ? AxisDirection.PAST : AxisDirection.DISPLAY_DOWN).ordinal();
    }

    public static boolean isUserDefined(AxisDirection axisDirection) {
        return axisDirection != null && axisDirection.ordinal() > LAST_ORDINAL;
    }

    public static boolean isGrid(AxisDirection axisDirection) {
        if (axisDirection == null) {
            return false;
        }
        int n = axisDirection.ordinal();
        return n >= AxisDirection.COLUMN_POSITIVE.ordinal() && n <= AxisDirection.ROW_NEGATIVE.ordinal();
    }

    public static int angleForGeocentric(AxisDirection axisDirection, AxisDirection axisDirection2) {
        int n;
        int n2 = AxisDirection.GEOCENTRIC_X.ordinal();
        int n3 = axisDirection.ordinal() - n2;
        if (n3 >= 0 && n3 < 3 && (n = axisDirection2.ordinal() - n2) >= 0 && n < 3) {
            int n4 = n - n3;
            n4 -= 3 * (n4 / 2);
            return n4;
        }
        return Integer.MIN_VALUE;
    }

    public static int angleForCompass(AxisDirection axisDirection, AxisDirection axisDirection2) {
        int n;
        int n2 = AxisDirection.NORTH.ordinal();
        int n3 = axisDirection.ordinal() - n2;
        if (n3 >= 0 && n3 < 16 && (n = axisDirection2.ordinal() - n2) >= 0 && n < 16) {
            int n4 = n3 - n;
            if (n4 < -8) {
                n4 += 16;
            } else if (n4 > 8) {
                n4 -= 16;
            }
            return n4;
        }
        return Integer.MIN_VALUE;
    }

    public static int angleForDisplay(AxisDirection axisDirection, AxisDirection axisDirection2) {
        int n;
        int n2 = AxisDirection.DISPLAY_RIGHT.ordinal();
        int n3 = axisDirection.ordinal() - n2;
        if (n3 >= 0 && n3 < 4 && (n = axisDirection2.ordinal() - n2) >= 0 && n < 4) {
            int n4 = (n3 = DISPLAY_ORDER[n3]) - (n = DISPLAY_ORDER[n]);
            if (n4 < -2) {
                n4 += 4;
            } else if (n4 > 2) {
                n4 -= 4;
            }
            return n4;
        }
        return Integer.MIN_VALUE;
    }

    public static Unit<Angle> getAngularUnit(CoordinateSystem coordinateSystem, Unit<Angle> unit) {
        if (coordinateSystem != null) {
            int n = coordinateSystem.getDimension();
            while (--n >= 0) {
                Unit unit2;
                CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(n);
                if (coordinateSystemAxis == null || !Units.isAngular((Unit)(unit2 = coordinateSystemAxis.getUnit()))) continue;
                unit = unit2.asType(Angle.class);
                if (!AxisDirection.EAST.equals((Object)AxisDirections.absolute(coordinateSystemAxis.getDirection()))) continue;
                break;
            }
        }
        return unit;
    }

    public static int indexOfColinear(CoordinateSystem coordinateSystem, AxisDirection axisDirection) {
        int n = -1;
        if (coordinateSystem != null) {
            int n2 = coordinateSystem.getDimension();
            for (int i = 0; i < n2; ++i) {
                AxisDirection axisDirection2 = coordinateSystem.getAxis(i).getDirection();
                if (axisDirection.equals((Object)axisDirection2)) {
                    return i;
                }
                if (n >= 0 || !axisDirection2.equals((Object)AxisDirections.opposite(axisDirection))) continue;
                n = i;
            }
        }
        return n;
    }

    public static int indexOfColinear(CoordinateSystem coordinateSystem, CoordinateSystem coordinateSystem2) {
        int n = AxisDirections.indexOfColinear(coordinateSystem, coordinateSystem2.getAxis(0).getDirection());
        if (n >= 0) {
            int n2 = coordinateSystem2.getDimension();
            if (n + n2 > coordinateSystem.getDimension()) {
                return -1;
            }
            while (--n2 > 0) {
                if (AxisDirections.absolute(coordinateSystem2.getAxis(n2).getDirection()).equals((Object)AxisDirections.absolute(coordinateSystem.getAxis(n2 + n).getDirection()))) continue;
                return -1;
            }
        }
        return n;
    }

    public static AxisDirection find(String string, AxisDirection[] axisDirectionArray) {
        for (AxisDirection axisDirection : axisDirectionArray) {
            String string2 = axisDirection.name();
            if (!CharSequences.equalsFiltered((CharSequence)string, (CharSequence)string2, (Characters.Filter)Characters.Filter.LETTERS_AND_DIGITS, (boolean)true) && !CharSequences.isAcronymForWords((CharSequence)string, (CharSequence)string2)) continue;
            return axisDirection;
        }
        return null;
    }

    public static AxisDirection valueOf(String string) {
        int n;
        AxisDirection[] axisDirectionArray;
        AxisDirection axisDirection = AxisDirections.find(string = CharSequences.trimWhitespaces((String)string.replace('_', ' ')), axisDirectionArray = AxisDirection.values());
        if (axisDirection == null && (n = string.indexOf(62)) >= 0 && AxisDirections.equalsIgnoreCase(string, 0, CharSequences.skipTrailingWhitespaces((CharSequence)string, (int)0, (int)n), "Geocentre")) {
            int n2 = string.length();
            int n3 = string.indexOf(47, n = CharSequences.skipLeadingWhitespaces((CharSequence)string, (int)(n + 1), (int)n2));
            if (n3 < 0) {
                if (AxisDirections.equalsIgnoreCase(string, n, n2, "north pole")) {
                    return AxisDirection.GEOCENTRIC_Z;
                }
            } else if (AxisDirections.equalsIgnoreCase(string, n, CharSequences.skipTrailingWhitespaces((CharSequence)string, (int)n, (int)n3), "equator")) {
                if (AxisDirections.equalsIgnoreCase(string, n3 = CharSequences.skipLeadingWhitespaces((CharSequence)string, (int)(n3 + 1), (int)n2), n2, "PM")) {
                    return AxisDirection.GEOCENTRIC_X;
                }
                int n4 = Math.min(n3 + 6, n2);
                for (int i = n3; i < n4; ++i) {
                    char c = string.charAt(i);
                    if (c >= '0' && c <= '9') continue;
                    if (i == n3) break;
                    int n5 = Integer.parseInt(string.substring(n3, i));
                    if (!AxisDirections.equalsIgnoreCase(string, i = CharSequences.skipLeadingWhitespaces((CharSequence)string, (int)i, (int)n2), n2, "\u00b0E") && !AxisDirections.equalsIgnoreCase(string, i, n2, "dE")) break;
                    switch (n5) {
                        case 0: {
                            return AxisDirection.GEOCENTRIC_X;
                        }
                        case 90: {
                            return AxisDirection.GEOCENTRIC_Y;
                        }
                    }
                    break;
                }
            }
        }
        return axisDirection;
    }

    private static boolean equalsIgnoreCase(String string, int n, int n2, String string2) {
        int n3 = n2 - n;
        return n3 == string2.length() && string.regionMatches(true, n, string2, 0, n3);
    }

    private static boolean startsWith(String string, String string2) {
        return string.regionMatches(true, 0, string2, 0, string2.length());
    }

    public static String suggestAbbreviation(String string, AxisDirection axisDirection, Unit<?> unit) {
        String string2;
        if (string.length() == 1) {
            return string;
        }
        if (AxisDirections.isCompass(axisDirection)) {
            if (!AxisDirections.isIntercardinal(axisDirection) && Units.isAngular(unit)) {
                if (AxisDirections.startsWith(string, "Spherical")) {
                    return AxisDirection.NORTH.equals((Object)AxisDirections.absolute(axisDirection)) ? "\u03c6\u2032" : "\u03b8";
                }
                return AxisDirection.NORTH.equals((Object)AxisDirections.absolute(axisDirection)) ? "\u03c6" : "\u03bb";
            }
        } else {
            if (AxisDirection.UP.equals((Object)axisDirection)) {
                return AxisDirections.startsWith(string, "Gravity") ? "H" : (AxisDirections.startsWith(string, "Geocentric") ? "r" : "h");
            }
            if (AxisDirection.DOWN.equals((Object)axisDirection)) {
                return "D";
            }
            if (AxisDirections.isGeocentric(axisDirection)) {
                String string3 = axisDirection.name();
                return string3.substring(string3.length() - 1).trim();
            }
            string2 = AxisDirections.absolute(axisDirection);
            if (AxisDirection.FUTURE.equals((Object)string2)) {
                return "t";
            }
            if (AxisDirection.COLUMN_POSITIVE.equals((Object)string2)) {
                return "i";
            }
            if (AxisDirection.ROW_POSITIVE.equals((Object)string2)) {
                return "j";
            }
            if (AxisDirection.DISPLAY_RIGHT.equals((Object)string2)) {
                return "x";
            }
            if (AxisDirection.DISPLAY_UP.equals((Object)string2)) {
                return "y";
            }
            if (AxisDirection.OTHER.equals((Object)string2)) {
                return "z";
            }
        }
        return CharSequences.camelCaseToAcronym((CharSequence)((string2 = axisDirection.identifier()) != null ? string2 : axisDirection.name())).toString().intern();
    }

    public static String appendTo(StringBuilder stringBuilder, CoordinateSystemAxis[] coordinateSystemAxisArray) {
        String string = ": ";
        for (CoordinateSystemAxis coordinateSystemAxis : coordinateSystemAxisArray) {
            stringBuilder.append(string).append(Types.getCodeLabel((CodeList)coordinateSystemAxis.getDirection()));
            string = ", ";
            String string2 = PatchedUnitFormat.toString((Unit)coordinateSystemAxis.getUnit());
            if (string2 == null || string2.isEmpty()) continue;
            stringBuilder.append(" (").append(string2).append(')');
        }
        return stringBuilder.append('.').toString();
    }

    static {
        AxisDirections.put(AxisDirection.OTHER, AxisDirection.OTHER);
        AxisDirections.put(AxisDirection.NORTH, AxisDirection.SOUTH);
        AxisDirections.put(AxisDirection.NORTH_NORTH_EAST, AxisDirection.SOUTH_SOUTH_WEST);
        AxisDirections.put(AxisDirection.NORTH_EAST, AxisDirection.SOUTH_WEST);
        AxisDirections.put(AxisDirection.EAST_NORTH_EAST, AxisDirection.WEST_SOUTH_WEST);
        AxisDirections.put(AxisDirection.EAST, AxisDirection.WEST);
        AxisDirections.put(AxisDirection.EAST_SOUTH_EAST, AxisDirection.WEST_NORTH_WEST);
        AxisDirections.put(AxisDirection.SOUTH_EAST, AxisDirection.NORTH_WEST);
        AxisDirections.put(AxisDirection.SOUTH_SOUTH_EAST, AxisDirection.NORTH_NORTH_WEST);
        AxisDirections.put(AxisDirection.UP, AxisDirection.DOWN);
        AxisDirections.put(AxisDirection.FUTURE, AxisDirection.PAST);
        AxisDirections.put(AxisDirection.COLUMN_POSITIVE, AxisDirection.COLUMN_NEGATIVE);
        AxisDirections.put(AxisDirection.ROW_POSITIVE, AxisDirection.ROW_NEGATIVE);
        AxisDirections.put(AxisDirection.DISPLAY_RIGHT, AxisDirection.DISPLAY_LEFT);
        AxisDirections.put(AxisDirection.DISPLAY_UP, AxisDirection.DISPLAY_DOWN);
        LAST_ORDINAL = AxisDirection.DISPLAY_DOWN.ordinal();
        DISPLAY_ORDER = new byte[]{1, 3, 0, 2};
    }
}

