/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata;

import java.util.Collection;
import java.util.Collections;
import org.apache.sis.internal.simple.SimpleCitation;
import org.apache.sis.internal.util.MetadataServices;
import org.apache.sis.metadata.iso.ImmutableIdentifier;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.metadata.iso.citation.DefaultOrganisation;
import org.apache.sis.metadata.iso.citation.DefaultResponsibleParty;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;

public final class ServicesForUtility
extends MetadataServices {
    public Citation getCitationConstant(String string) {
        Citation citation = Citations.fromName(string);
        return citation.getClass() != SimpleCitation.class ? citation : null;
    }

    public Citation createCitation(String string) {
        String string2;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        PresentationForm presentationForm = null;
        Citation citation = null;
        if (string.equals("ISO 19115-1")) {
            string2 = "Geographic Information \u2014 Metadata Part 1: Fundamentals";
            string4 = "ISO 19115-1:2014(E)";
            string5 = "19115-1";
            string6 = "ISO";
            string7 = "2014(E)";
            string8 = "International Organization for Standardization";
            presentationForm = PresentationForm.DOCUMENT_DIGITAL;
        } else if (string.equals("ISO 19115-2")) {
            string2 = "Geographic Information \u2014 Metadata Part 2: Extensions for imagery and gridded data";
            string4 = "ISO 19115-2:2009(E)";
            string5 = "19115-2";
            string6 = "ISO";
            string7 = "2009(E)";
            citation = Citations.ISO_19115.get(0);
            presentationForm = PresentationForm.DOCUMENT_DIGITAL;
        } else if (string.equals("OGC")) {
            string2 = "Identifier in OGC namespace";
            string5 = "OGC";
            string8 = "Open Geospatial Consortium";
            presentationForm = PresentationForm.DOCUMENT_DIGITAL;
        } else if (string.equals("EPSG")) {
            string2 = "EPSG Geodetic Parameter Dataset";
            string5 = "EPSG";
            string6 = "IOGP";
            string8 = "International Association of Oil & Gas producers";
            presentationForm = PresentationForm.TABLE_DIGITAL;
        } else if (string.equals("SIS")) {
            string2 = "Apache Spatial Information System";
            string5 = string;
        } else if (string.equals("ISBN")) {
            string2 = "International Standard Book Number";
            string3 = string;
        } else if (string.equals("ISSN")) {
            string2 = "International Standard Serial Number";
            string3 = string;
        } else if (string.equals("Proj4")) {
            string2 = "Proj.4";
        } else if (string.equals("S57")) {
            string2 = "S-57";
        } else {
            return super.createCitation(string);
        }
        DefaultCitation defaultCitation = new DefaultCitation(string2);
        if (string3 != null) {
            defaultCitation.setAlternateTitles(Collections.singleton(Types.toInternationalString((CharSequence)string3)));
        }
        if (string4 != null) {
            defaultCitation.setEdition(Types.toInternationalString((CharSequence)string4));
        }
        if (string5 != null) {
            defaultCitation.setIdentifiers(Collections.singleton(new ImmutableIdentifier(null, string6, string5, string7, null)));
        }
        if (citation != null) {
            defaultCitation.setCitedResponsibleParties(citation.getCitedResponsibleParties());
        }
        if (presentationForm != null) {
            defaultCitation.setPresentationForms(Collections.singleton(presentationForm));
        }
        if (string8 != null) {
            DefaultOrganisation defaultOrganisation = new DefaultOrganisation();
            defaultOrganisation.setName(Types.toInternationalString((CharSequence)string8));
            DefaultResponsibleParty defaultResponsibleParty = new DefaultResponsibleParty(Role.PRINCIPAL_INVESTIGATOR);
            defaultResponsibleParty.setParties(Collections.singleton(defaultOrganisation));
            Collection<ResponsibleParty> collection = defaultCitation.getCitedResponsibleParties();
            if (collection != null) {
                collection.add(defaultResponsibleParty);
            } else {
                defaultCitation.setCitedResponsibleParties(Collections.singleton(defaultResponsibleParty));
            }
        }
        defaultCitation.freeze();
        return defaultCitation;
    }
}

