/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.lang.reflect.Array;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.measure.quantity.Quantity;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.simple.SimpleExtent;
import org.apache.sis.internal.util.Citations;
import org.apache.sis.internal.util.PatchedUnitFormat;
import org.apache.sis.internal.util.StandardDateFormat;
import org.apache.sis.io.wkt.Colors;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Symbols;
import org.apache.sis.io.wkt.Transliterator;
import org.apache.sis.io.wkt.UnformattableObjectException;
import org.apache.sis.io.wkt.Warnings;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.Range;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.ImmutableIdentifier;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Localized;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.TemporalExtent;
import org.opengis.metadata.extent.VerticalExtent;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.CodeList;
import org.opengis.util.InternationalString;

public class Formatter
implements Localized {
    static final int BBOX_ACCURACY = 2;
    private static final int VERTICAL_ACCURACY = 9;
    private static final long TEMPORAL_THRESHOLD = 86400000L;
    static final String FOREGROUND_DEFAULT = "\u001b[39m";
    static final String BACKGROUND_DEFAULT = "\u001b[49m";
    private final Locale locale;
    private final Symbols symbols;
    private final String lineSeparator;
    private Colors colors;
    private Convention convention;
    private Citation authority;
    Transliterator transliterator;
    private final List<FormattableObject> enclosingElements = new ArrayList<FormattableObject>();
    private final Map<Unit<?>, Unit<?>> units = new HashMap(4);
    private long hasContextualUnit;
    private final NumberFormat numberFormat;
    private final DateFormat dateFormat;
    private final PatchedUnitFormat unitFormat;
    private final FieldPosition dummy = new FieldPosition(0);
    private StringBuffer buffer;
    private int elementStart;
    private byte toUpperCase;
    private byte longKeywords;
    private int colorApplied;
    private byte indentation;
    private int margin;
    private boolean requestNewLine;
    private boolean isComplement;
    private boolean highlightError;
    private Warnings warnings;

    public Formatter() {
        this(Convention.DEFAULT, Symbols.getDefault(), 2);
    }

    public Formatter(Convention convention, Symbols symbols, int n) {
        ArgumentChecks.ensureNonNull((String)"convention", (Object)((Object)convention));
        ArgumentChecks.ensureNonNull((String)"symbols", (Object)symbols);
        ArgumentChecks.ensureBetween((String)"indentation", (int)-1, (int)127, (int)n);
        this.locale = Locale.getDefault();
        this.convention = convention;
        this.authority = convention.getNameAuthority();
        this.symbols = symbols.immutable();
        this.lineSeparator = this.symbols.lineSeparator();
        this.indentation = (byte)n;
        this.numberFormat = symbols.createNumberFormat();
        this.dateFormat = new StandardDateFormat(symbols.getLocale());
        this.unitFormat = new PatchedUnitFormat(UnitFormat.getInstance((Locale)symbols.getLocale()));
        this.buffer = new StringBuffer();
    }

    Formatter(Locale locale, Symbols symbols, NumberFormat numberFormat, DateFormat dateFormat, UnitFormat unitFormat) {
        this.locale = locale;
        this.convention = Convention.DEFAULT;
        this.authority = Convention.DEFAULT.getNameAuthority();
        this.symbols = symbols;
        this.lineSeparator = this.symbols.lineSeparator();
        this.indentation = (byte)2;
        this.numberFormat = numberFormat;
        this.dateFormat = dateFormat;
        this.unitFormat = new PatchedUnitFormat(unitFormat);
    }

    final void setBuffer(StringBuffer stringBuffer) {
        this.buffer = stringBuffer;
        this.elementStart = stringBuffer != null ? stringBuffer.length() : 0;
    }

    final void configure(Convention convention, Citation citation, Colors colors, byte by, byte by2, byte by3) {
        this.convention = convention;
        this.authority = citation != null ? citation : convention.getNameAuthority();
        this.colors = colors;
        this.toUpperCase = by;
        this.longKeywords = by2;
        this.indentation = by3;
        this.transliterator = convention == Convention.INTERNAL ? Transliterator.IDENTITY : Transliterator.DEFAULT;
        this.unitFormat.isLocaleUS = convention.usesCommonUnits;
    }

    public final Convention getConvention() {
        return this.convention;
    }

    public final Transliterator getTransliterator() {
        return this.transliterator;
    }

    public final Citation getNameAuthority() {
        return this.authority;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    private void setColor(ElementKind elementKind) {
        if (this.colors != null) {
            if (this.colorApplied == 0) {
                String string = this.colors.getAnsiSequence(elementKind);
                if (string == null) {
                    return;
                }
                this.buffer.append(string);
            }
            ++this.colorApplied;
        }
    }

    private void resetColor() {
        if (this.colors != null && --this.colorApplied <= 0) {
            this.colorApplied = 0;
            this.buffer.append(FOREGROUND_DEFAULT);
        }
    }

    public void newLine() {
        if (this.indentation > -1) {
            this.requestNewLine = true;
        }
    }

    public void indent(int n) {
        this.margin = Math.max(0, this.margin + this.indentation * n);
    }

    public String shortOrLong(String string, String string2) {
        return (this.longKeywords != 0 ? this.longKeywords < 0 : this.convention.toUpperCase) ? string : string2;
    }

    private void appendSeparator() {
        if (this.buffer.length() != this.elementStart) {
            if (this.requestNewLine) {
                this.buffer.append(this.lineSeparator).append(CharSequences.spaces((int)this.margin));
            } else {
                this.buffer.append(this.symbols.getSeparator());
            }
        }
        this.requestNewLine = false;
    }

    private void openElement(boolean bl, String string) {
        if (bl) {
            this.newLine();
        }
        this.appendSeparator();
        if (this.toUpperCase != 0) {
            Locale locale = this.symbols.getLocale();
            string = this.toUpperCase >= 0 ? string.toUpperCase(locale) : string.toLowerCase(locale);
        }
        this.elementStart = this.buffer.append(string).appendCodePoint(this.symbols.getOpeningBracket(0)).length();
    }

    private void closeElement(boolean bl) {
        this.buffer.appendCodePoint(this.symbols.getClosingBracket(0));
        if (bl) {
            this.newLine();
        }
    }

    public void append(FormattableObject formattableObject) {
        Object object;
        int n;
        if (formattableObject == null) {
            return;
        }
        int n2 = n = this.enclosingElements.size();
        while (--n2 >= 0) {
            if (this.enclosingElements.get(n2) != formattableObject) continue;
            throw new IllegalStateException(Errors.getResources((Locale)this.locale).getString((short)52));
        }
        this.enclosingElements.add(formattableObject);
        if (this.hasContextualUnit < 0L) {
            throw new IllegalStateException(Errors.getResources((Locale)this.locale).getString((short)145));
        }
        this.hasContextualUnit <<= 1;
        this.appendSeparator();
        n2 = this.buffer.length();
        this.elementStart = this.buffer.appendCodePoint(this.symbols.getOpeningBracket(0)).length();
        this.indent(1);
        IdentifiedObject identifiedObject = formattableObject instanceof IdentifiedObject ? (IdentifiedObject)formattableObject : null;
        String string = formattableObject.formatTo(this);
        if (string == null) {
            if (identifiedObject != null) {
                this.setInvalidWKT(identifiedObject, null);
            } else {
                this.setInvalidWKT(formattableObject.getClass(), null);
            }
            string = Formatter.getName(formattableObject.getClass());
        } else if (this.toUpperCase != 0) {
            object = this.symbols.getLocale();
            String string2 = string = this.toUpperCase >= 0 ? string.toUpperCase((Locale)object) : string.toLowerCase((Locale)object);
        }
        if (this.highlightError && this.colors != null && (object = this.colors.getAnsiSequence(ElementKind.ERROR)) != null) {
            this.buffer.insert(n2, (String)object + BACKGROUND_DEFAULT);
            n2 += ((String)object).length();
        }
        this.highlightError = false;
        this.buffer.insert(n2, string);
        if (identifiedObject == null && this.convention.majorVersion() != 1 && formattableObject instanceof GeneralParameterValue) {
            identifiedObject = ((GeneralParameterValue)formattableObject).getDescriptor();
        }
        if (identifiedObject != null) {
            this.appendComplement(identifiedObject, n != 0 ? this.enclosingElements.get(n - 1) : null);
        }
        this.buffer.appendCodePoint(this.symbols.getClosingBracket(0));
        this.indent(-1);
        this.enclosingElements.remove(n);
        this.hasContextualUnit >>>= 1;
    }

    private void appendComplement(IdentifiedObject identifiedObject, FormattableObject formattableObject) {
        Set<ReferenceIdentifier> set;
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        this.isComplement = true;
        if (this.convention == Convention.INTERNAL) {
            bl4 = true;
            bl3 = false;
            bl2 = true;
            bl = true;
        } else {
            if (formattableObject == null || formattableObject instanceof CompoundCRS) {
                bl4 = true;
            } else if (this.convention == Convention.WKT2_SIMPLIFIED) {
                bl4 = false;
            } else {
                boolean bl5 = bl4 = identifiedObject instanceof OperationMethod || identifiedObject instanceof GeneralParameterDescriptor;
            }
            if (this.convention.majorVersion() == 1) {
                bl3 = true;
                bl2 = false;
                bl = false;
            } else {
                boolean bl6 = bl3 = formattableObject != null;
                if (identifiedObject instanceof CoordinateOperation) {
                    bl2 = true;
                    bl = true;
                } else if (identifiedObject instanceof ReferenceSystem) {
                    bl2 = formattableObject == null;
                    bl = formattableObject == null || this.getEnclosingElement(2) instanceof CoordinateOperation;
                } else {
                    bl2 = false;
                    bl = false;
                }
            }
        }
        if (bl2) {
            this.appendForSubtypes(identifiedObject);
        }
        if (bl4 && (set = identifiedObject.getIdentifiers()) != null) {
            if (bl3) {
                for (ReferenceIdentifier referenceIdentifier : set) {
                    if (!Citations.identifierMatches((Citation)this.authority, (Citation)referenceIdentifier.getAuthority())) continue;
                    set = Collections.singleton(referenceIdentifier);
                    break;
                }
            }
            for (ReferenceIdentifier referenceIdentifier : set) {
                if (!(referenceIdentifier instanceof FormattableObject)) {
                    referenceIdentifier = ImmutableIdentifier.castOrCopy(referenceIdentifier);
                }
                this.append((FormattableObject)referenceIdentifier);
                if (!bl3) continue;
                break;
            }
        }
        if (bl) {
            this.appendOnNewLine("Remark", identifiedObject.getRemarks(), ElementKind.REMARKS);
        }
        this.isComplement = false;
    }

    private void appendForSubtypes(IdentifiedObject identifiedObject) {
        Extent extent;
        InternationalString internationalString;
        InternationalString internationalString2;
        if (identifiedObject instanceof ReferenceSystem) {
            internationalString2 = null;
            internationalString = ((ReferenceSystem)identifiedObject).getScope();
            extent = ((ReferenceSystem)identifiedObject).getDomainOfValidity();
        } else if (identifiedObject instanceof Datum) {
            internationalString2 = ((Datum)identifiedObject).getAnchorPoint();
            internationalString = ((Datum)identifiedObject).getScope();
            extent = ((Datum)identifiedObject).getDomainOfValidity();
        } else if (identifiedObject instanceof CoordinateOperation) {
            internationalString2 = null;
            internationalString = ((CoordinateOperation)identifiedObject).getScope();
            extent = ((CoordinateOperation)identifiedObject).getDomainOfValidity();
        } else {
            return;
        }
        this.appendOnNewLine("Anchor", internationalString2, null);
        this.appendOnNewLine("Scope", internationalString, ElementKind.SCOPE);
        if (extent != null) {
            this.appendOnNewLine("Area", extent.getDescription(), ElementKind.EXTENT);
            this.append(Extents.getGeographicBoundingBox(extent), 2);
            this.appendVerticalExtent(Extents.getVerticalRange(extent));
            this.appendTemporalExtent(Extents.getTimeRange(extent));
        }
    }

    public void append(GeographicBoundingBox geographicBoundingBox, int n) {
        if (geographicBoundingBox != null) {
            this.openElement(this.isComplement, "BBox");
            this.setColor(ElementKind.EXTENT);
            this.numberFormat.setMinimumFractionDigits(n);
            this.numberFormat.setMaximumFractionDigits(n);
            this.numberFormat.setRoundingMode(RoundingMode.FLOOR);
            this.appendPreset(geographicBoundingBox.getSouthBoundLatitude());
            this.appendPreset(geographicBoundingBox.getWestBoundLongitude());
            this.numberFormat.setRoundingMode(RoundingMode.CEILING);
            this.appendPreset(geographicBoundingBox.getNorthBoundLatitude());
            this.appendPreset(geographicBoundingBox.getEastBoundLongitude());
            this.resetColor();
            this.closeElement(this.isComplement);
        }
    }

    private void appendVerticalExtent(MeasurementRange<Double> measurementRange) {
        if (measurementRange != null) {
            double d = measurementRange.getMinDouble();
            double d2 = measurementRange.getMaxDouble();
            int n = Math.max(0, DecimalFunctions.fractionDigitsForDelta((double)(d2 - d), (boolean)false));
            int n2 = n + 2;
            if (n2 > 9) {
                n2 = 9;
                n = 0;
            }
            this.openElement(true, "VerticalExtent");
            this.setColor(ElementKind.EXTENT);
            this.numberFormat.setMinimumFractionDigits(n);
            this.numberFormat.setMaximumFractionDigits(n2);
            this.numberFormat.setRoundingMode(RoundingMode.FLOOR);
            this.appendPreset(d);
            this.numberFormat.setRoundingMode(RoundingMode.CEILING);
            this.appendPreset(d2);
            Unit unit = measurementRange.unit();
            if (!this.convention.isSimplified() || !SI.METRE.equals((Object)unit)) {
                this.append(unit);
            }
            this.resetColor();
            this.closeElement(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendTemporalExtent(Range<Date> range) {
        if (range != null) {
            Date date = (Date)range.getMinValue();
            Date date2 = (Date)range.getMaxValue();
            if (date != null && date2 != null) {
                String string;
                String string2 = null;
                if (this.dateFormat instanceof SimpleDateFormat && date2.getTime() - date.getTime() >= 86400000L && (string = ((SimpleDateFormat)this.dateFormat).toPattern()).length() > "yyyy-MM-dd".length() && string.startsWith("yyyy-MM-dd")) {
                    string2 = string;
                    ((SimpleDateFormat)this.dateFormat).applyPattern("yyyy-MM-dd");
                }
                this.openElement(true, "TimeExtent");
                this.setColor(ElementKind.EXTENT);
                try {
                    this.append(date);
                    this.append(date2);
                }
                finally {
                    if (string2 != null) {
                        ((SimpleDateFormat)this.dateFormat).applyPattern(string2);
                    }
                }
                this.resetColor();
                this.closeElement(true);
            }
        }
    }

    public void append(MathTransform mathTransform) {
        if (mathTransform != null) {
            if (mathTransform instanceof FormattableObject) {
                this.append((FormattableObject)mathTransform);
            } else {
                FormattableObject formattableObject = ReferencingServices.getInstance().toFormattableObject(mathTransform, this.convention == Convention.INTERNAL);
                if (formattableObject != null) {
                    this.append(formattableObject);
                } else {
                    throw new UnformattableObjectException(Errors.format((short)34, FormattableObject.class, mathTransform.getClass()));
                }
            }
        }
    }

    private void appendOnNewLine(String string, InternationalString internationalString, ElementKind elementKind) {
        String string2;
        ArgumentChecks.ensureNonNull((String)"keyword", (Object)string);
        if (internationalString != null && (string2 = CharSequences.trimWhitespaces((String)internationalString.toString(this.locale))) != null && !string2.isEmpty()) {
            this.openElement(true, string);
            this.quote(string2, elementKind);
            this.closeElement(true);
        }
    }

    public void append(String string, ElementKind elementKind) {
        if (string != null) {
            this.appendSeparator();
            if (elementKind != ElementKind.CODE_LIST) {
                this.quote(string, elementKind);
            } else {
                this.setColor(elementKind);
                this.buffer.append(string);
                this.resetColor();
            }
        }
    }

    private void quote(String string, ElementKind elementKind) {
        this.setColor(elementKind);
        int n = this.buffer.appendCodePoint(this.symbols.getOpeningQuote(0)).length();
        if (elementKind != ElementKind.REMARKS) {
            int n2;
            string = this.transliterator.filter(string);
            int n3 = 0;
            int n4 = string.length();
            for (int i = 0; i < n4; i += n2) {
                int n5 = string.codePointAt(i);
                n2 = Character.charCount(n5);
                if (Characters.isValidWKT((int)n5)) continue;
                String string2 = string.substring(i, i + n2);
                while ((i += n2) < n4) {
                    n5 = string.codePointAt(i);
                    n2 = Character.charCount(n5);
                    if (n5 != 32 && n5 != 95) continue;
                }
                this.warnings().add(Errors.formatInternational((short)195, (Object[])new Object[]{"Well-Known Text", string.substring(n3, i), string2}), null, null);
                break;
            }
        }
        this.buffer.append(string);
        this.closeQuote(n);
        this.resetColor();
    }

    private void closeQuote(int n) {
        String string = this.symbols.getQuote();
        while ((n = this.buffer.indexOf(string, n)) >= 0) {
            int n2 = string.length();
            if (this.convention.majorVersion() == 1) {
                this.buffer.delete(n, n + n2);
                continue;
            }
            this.buffer.insert(n += n2, string);
            n += n2;
        }
        this.buffer.append(string);
    }

    public void append(CodeList<?> codeList) {
        if (codeList != null) {
            this.appendSeparator();
            this.setColor(ElementKind.CODE_LIST);
            this.buffer.append(this.convention.majorVersion() == 1 ? codeList.name() : Types.getCodeName(codeList));
            this.resetColor();
        }
    }

    public void append(Date date) {
        if (date != null) {
            this.appendSeparator();
            this.dateFormat.format(date, this.buffer, this.dummy);
        }
    }

    public void append(boolean bl) {
        this.appendSeparator();
        this.buffer.append(bl ? "TRUE" : "FALSE");
    }

    public void append(long l) {
        this.appendSeparator();
        this.setColor(this.isComplement ? ElementKind.IDENTIFIER : ElementKind.INTEGER);
        this.numberFormat.setMaximumFractionDigits(0);
        this.numberFormat.format(l, this.buffer, this.dummy);
        this.resetColor();
    }

    public void append(double d) {
        this.appendSeparator();
        this.setColor(ElementKind.NUMBER);
        double d2 = Math.abs(d);
        if ((d2 < 0.001 || d2 >= 1.0E9) && this.symbols.getLocale() == Locale.ROOT) {
            this.buffer.append(d);
        } else {
            this.numberFormat.setMaximumFractionDigits(DecimalFunctions.fractionDigitsForValue((double)d, (int)2));
            this.numberFormat.setMinimumFractionDigits(1);
            this.numberFormat.setRoundingMode(RoundingMode.HALF_EVEN);
            this.numberFormat.format(d, this.buffer, this.dummy);
        }
        this.resetColor();
    }

    private void appendPreset(double d) {
        this.appendSeparator();
        this.setColor(ElementKind.NUMBER);
        this.numberFormat.format(d, this.buffer, this.dummy);
        this.resetColor();
    }

    private void appendExact(double d) {
        if (Locale.ROOT.equals(this.symbols.getLocale())) {
            this.appendSeparator();
            this.setColor(this.highlightError ? ElementKind.ERROR : ElementKind.NUMBER);
            int n = (int)d;
            if ((double)n == d) {
                this.buffer.append(n);
            } else {
                this.buffer.append(d);
            }
            this.resetColor();
        } else {
            this.append(d);
        }
        this.highlightError = false;
    }

    public void append(Unit<?> unit) {
        if (unit != null) {
            Integer n;
            boolean bl = this.longKeywords == 0 ? this.convention.isSimplified() : this.longKeywords < 0;
            boolean bl2 = this.convention.majorVersion() == 1;
            Unit unit2 = unit.toSI();
            String string = unit2.equals((Object)SI.METRE) ? (bl ? "Unit" : "LengthUnit") : (unit2.equals((Object)SI.RADIAN) ? (bl ? "Unit" : "AngleUnit") : (unit2.equals((Object)Unit.ONE) ? (bl ? "Unit" : "ScaleUnit") : (unit2.equals((Object)SI.SECOND) ? "TimeUnit" : "ParametricUnit")));
            this.openElement(false, string);
            this.setColor(ElementKind.UNIT);
            int n2 = this.buffer.appendCodePoint(this.symbols.getOpeningQuote(0)).length();
            this.unitFormat.format(unit, this.buffer, this.dummy);
            this.closeQuote(n2);
            this.resetColor();
            double d = Units.toStandardUnit(unit);
            this.appendExact(d);
            if ((this.convention == Convention.INTERNAL || PatchedUnitFormat.toFormattable(unit) != unit) && (n = Units.getEpsgCode(unit, (boolean)(this.getEnclosingElement(1) instanceof CoordinateSystemAxis))) != null) {
                this.openElement(false, bl2 ? "Authority" : "Id");
                this.append("EPSG", null);
                if (bl2) {
                    this.append(n.toString(), null);
                } else {
                    this.append(n.intValue());
                }
                this.closeElement(false);
            }
            this.closeElement(false);
            if (!(d > 0.0) || string != "Unit" && bl2) {
                this.setInvalidWKT(Unit.class, null);
            }
        }
    }

    public void appendAny(Object object) {
        if (object == null) {
            this.appendSeparator();
            this.buffer.append("null");
        } else if (!this.appendValue(object) && !this.appendElement(object)) {
            this.append(object.toString(), null);
        }
    }

    final boolean appendValue(Object object) {
        if (object.getClass().isArray()) {
            this.appendSeparator();
            this.elementStart = this.buffer.appendCodePoint(this.symbols.getOpenSequence()).length();
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                this.appendAny(Array.get(object, i));
            }
            this.buffer.appendCodePoint(this.symbols.getCloseSequence());
        } else if (object instanceof Number) {
            Number number = (Number)object;
            if (Numbers.isInteger(number.getClass())) {
                this.append(number.longValue());
            } else {
                this.append(number.doubleValue());
            }
        } else if (object instanceof CodeList) {
            this.append((CodeList)object);
        } else if (object instanceof Date) {
            this.append((Date)object);
        } else if (object instanceof Boolean) {
            this.append((Boolean)object);
        } else if (object instanceof CharSequence) {
            this.append(object instanceof InternationalString ? ((InternationalString)object).toString(this.locale) : object.toString(), null);
        } else {
            return false;
        }
        return true;
    }

    final boolean appendElement(Object object) {
        if (object instanceof FormattableObject) {
            this.append((FormattableObject)object);
        } else if (object instanceof IdentifiedObject) {
            this.append(ReferencingServices.getInstance().toFormattableObject((IdentifiedObject)object));
        } else if (object instanceof MathTransform) {
            this.append((MathTransform)object);
        } else if (object instanceof Unit) {
            this.append((Unit)object);
        } else if (object instanceof GeographicBoundingBox) {
            this.append((GeographicBoundingBox)object, 2);
        } else if (object instanceof VerticalExtent) {
            this.appendVerticalExtent(Extents.getVerticalRange((Extent)new SimpleExtent(null, (VerticalExtent)object, null)));
        } else if (object instanceof TemporalExtent) {
            this.appendTemporalExtent(Extents.getTimeRange((Extent)new SimpleExtent(null, null, (TemporalExtent)object)));
        } else {
            return false;
        }
        return true;
    }

    public String delegateTo(Object object) throws UnformattableObjectException {
        ArgumentChecks.ensureNonNull((String)"other", (Object)object);
        if (object instanceof FormattableObject) {
            return ((FormattableObject)object).formatTo(this);
        }
        throw new UnformattableObjectException(Errors.format((short)34, FormattableObject.class, object.getClass()));
    }

    public FormattableObject getEnclosingElement(int n) {
        ArgumentChecks.ensurePositive((String)"depth", (int)n);
        n = this.enclosingElements.size() - 1 - n;
        return n >= 0 ? this.enclosingElements.get(n) : null;
    }

    public boolean hasContextualUnit(int n) {
        ArgumentChecks.ensurePositive((String)"depth", (int)n);
        return n < 64 && (this.hasContextualUnit & 1L << n) != 0L;
    }

    public <Q extends Quantity> Unit<Q> addContextualUnit(Unit<Q> unit) {
        if (unit == null || this.convention.usesCommonUnits) {
            return null;
        }
        this.hasContextualUnit |= 1L;
        return this.units.put(unit.toSI(), unit);
    }

    public void restoreContextualUnit(Unit<?> unit, Unit<?> unit2) {
        if (unit2 == null ? unit != null && this.units.remove(unit.toSI()) != unit && !this.convention.usesCommonUnits : this.units.put(unit2.toSI(), unit2) != unit) {
            throw new IllegalStateException();
        }
    }

    @Deprecated
    public void removeContextualUnit(Unit<?> unit) {
        if (unit != null) {
            this.units.remove(unit.toSI());
        }
    }

    public <Q extends Quantity> Unit<Q> toContextualUnit(Unit<Q> unit) {
        Unit<?> unit2;
        if (unit != null && (unit2 = this.units.get(unit.toSI())) != null) {
            return unit2;
        }
        return unit;
    }

    public boolean isInvalidWKT() {
        return this.warnings != null || this.buffer != null && this.buffer.length() == 0;
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = new Warnings(this.locale, false, Collections.<String, List<String>>emptyMap());
        }
        return this.warnings;
    }

    public void setInvalidWKT(IdentifiedObject identifiedObject, Exception exception) {
        String string;
        ArgumentChecks.ensureNonNull((String)"unformattable", (Object)identifiedObject);
        ReferenceIdentifier referenceIdentifier = identifiedObject.getName();
        if (referenceIdentifier == null || (string = referenceIdentifier.getCode()) == null) {
            string = Formatter.getName(identifiedObject.getClass());
        }
        this.setInvalidWKT(string, exception);
    }

    public void setInvalidWKT(Class<?> clazz, Exception exception) {
        ArgumentChecks.ensureNonNull((String)"unformattable", clazz);
        this.setInvalidWKT(Formatter.getName(clazz), exception);
    }

    private void setInvalidWKT(String string, Exception exception) {
        this.warnings().add(Errors.formatInternational((short)10, (Object[])new Object[]{"WKT", string}), exception, null);
        this.highlightError = true;
    }

    private static String getName(Class<?> clazz) {
        if (!clazz.isInterface()) {
            for (Class<?> clazz2 : clazz.getInterfaces()) {
                if (!clazz2.getName().startsWith("org.opengis.")) continue;
                clazz = clazz2;
                break;
            }
        }
        return Classes.getShortName(clazz);
    }

    final Warnings getWarnings() {
        return this.warnings;
    }

    public String toWKT() {
        return this.buffer.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(Classes.getShortClassName((Object)this)).append('[');
        String string = "";
        for (FormattableObject formattableObject : this.enclosingElements) {
            stringBuilder.append(string).append(Classes.getShortClassName((Object)formattableObject));
            string = " \u3009 ";
        }
        return stringBuilder.append(']').toString();
    }

    final void clear() {
        if (this.buffer != null) {
            this.buffer.setLength(0);
        }
        this.enclosingElements.clear();
        this.units.clear();
        this.hasContextualUnit = 0L;
        this.elementStart = 0;
        this.colorApplied = 0;
        this.margin = 0;
        this.requestNewLine = false;
        this.isComplement = false;
        this.highlightError = false;
        this.warnings = null;
    }
}

