/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.citation.DefaultIndividual;
import org.apache.sis.metadata.iso.citation.DefaultOrganisation;
import org.apache.sis.util.iso.Types;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Contact;
import org.opengis.util.InternationalString;

@XmlType(name="AbstractCI_Party_Type", propOrder={"name", "contactInfo"})
@XmlRootElement(name="CI_Party")
@XmlSeeAlso(value={DefaultIndividual.class, DefaultOrganisation.class})
@UML(identifier="CI_Party", specification=Specification.ISO_19115)
public class AbstractParty
extends ISOMetadata {
    private static final long serialVersionUID = 1486981243884830979L;
    private InternationalString name;
    private Collection<Contact> contactInfo;

    public AbstractParty() {
    }

    public AbstractParty(CharSequence charSequence, Contact contact) {
        this.name = Types.toInternationalString((CharSequence)charSequence);
        this.contactInfo = this.singleton(contact, Contact.class);
    }

    public AbstractParty(AbstractParty abstractParty) {
        super(abstractParty);
        if (abstractParty != null) {
            this.name = abstractParty.getName();
            this.contactInfo = this.copyList(abstractParty.getContactInfo(), Contact.class);
        }
    }

    @XmlElement(name="name")
    @UML(identifier="name", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public InternationalString getName() {
        return this.name;
    }

    public void setName(InternationalString internationalString) {
        this.checkWritePermission();
        this.name = internationalString;
    }

    @XmlElement(name="contactInfo")
    @UML(identifier="contactInfo", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Contact> getContactInfo() {
        this.contactInfo = this.nonNullCollection(this.contactInfo, Contact.class);
        return this.contactInfo;
    }

    public void setContactInfo(Collection<? extends Contact> collection) {
        this.contactInfo = this.writeCollection(collection, this.contactInfo, Contact.class);
    }
}

