/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.content;

import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.gmi.MI_Band;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.iso.content.DefaultSampleDimension;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.content.Band;
import org.opengis.metadata.content.BandDefinition;
import org.opengis.metadata.content.PolarizationOrientation;
import org.opengis.metadata.content.TransferFunctionType;

@XmlType(name="MD_Band_Type", propOrder={"peakResponse", "bitsPerValue", "toneGradation", "scaleFactor", "offset", "bandBoundaryDefinition", "nominalSpatialResolution", "transferFunctionType", "transmittedPolarization", "detectedPolarization"})
@XmlRootElement(name="MD_Band")
@XmlSeeAlso(value={MI_Band.class})
public class DefaultBand
extends DefaultSampleDimension
implements Band {
    private static final long serialVersionUID = -2474871120376144737L;
    private Double boundMin;
    private Double boundMax;
    private Unit<Length> boundUnits;
    private BandDefinition bandBoundaryDefinition;
    private Double peakResponse;
    private Integer toneGradation;
    private PolarizationOrientation transmittedPolarization;
    private PolarizationOrientation detectedPolarization;

    public DefaultBand() {
    }

    public DefaultBand(Band band) {
        super(band);
        if (band != null) {
            if (band instanceof DefaultBand) {
                DefaultBand defaultBand = (DefaultBand)band;
                this.boundMin = defaultBand.getBoundMin();
                this.boundMax = defaultBand.getBoundMax();
                this.boundUnits = defaultBand.getBoundUnits();
            }
            this.peakResponse = band.getPeakResponse();
            this.toneGradation = band.getToneGradation();
            this.bandBoundaryDefinition = band.getBandBoundaryDefinition();
            this.transmittedPolarization = band.getTransmittedPolarization();
            this.detectedPolarization = band.getDetectedPolarization();
        }
    }

    public static DefaultBand castOrCopy(Band band) {
        if (band == null || band instanceof DefaultBand) {
            return (DefaultBand)band;
        }
        return new DefaultBand(band);
    }

    @ValueRange(minimum=0.0)
    @UML(identifier="boundMin", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Double getBoundMin() {
        return this.boundMin;
    }

    public void setBoundMin(Double d) {
        this.checkWritePermission();
        if (MetadataUtilities.ensurePositive(DefaultBand.class, "boundMin", false, d)) {
            this.boundMin = d;
        }
    }

    @ValueRange(minimum=0.0)
    @UML(identifier="boundMax", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Double getBoundMax() {
        return this.boundMax;
    }

    public void setBoundMax(Double d) {
        this.checkWritePermission();
        if (MetadataUtilities.ensurePositive(DefaultBand.class, "boundMax", false, d)) {
            this.boundMax = d;
        }
    }

    @UML(identifier="boundUnits", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Unit<Length> getBoundUnits() {
        return this.boundUnits;
    }

    public void setBoundUnits(Unit<Length> unit) {
        this.checkWritePermission();
        this.boundUnits = unit;
    }

    @XmlElement(name="bandBoundaryDefinition", namespace="http://www.isotc211.org/2005/gmi")
    public BandDefinition getBandBoundaryDefinition() {
        return this.bandBoundaryDefinition;
    }

    public void setBandBoundaryDefinition(BandDefinition bandDefinition) {
        this.checkWritePermission();
        this.bandBoundaryDefinition = bandDefinition;
    }

    public Unit<Length> getUnits() {
        Unit<?> unit = super.getUnits();
        return unit != null ? unit.asType(Length.class) : null;
    }

    @Override
    public void setUnits(Unit<?> unit) {
        super.setUnits(unit.asType(Length.class));
    }

    @ValueRange(minimum=0.0)
    @XmlElement(name="peakResponse")
    public Double getPeakResponse() {
        return this.peakResponse;
    }

    public void setPeakResponse(Double d) {
        this.checkWritePermission();
        if (MetadataUtilities.ensurePositive(DefaultBand.class, "peakResponse", false, d)) {
            this.peakResponse = d;
        }
    }

    @Override
    @ValueRange(minimum=1.0)
    @XmlElement(name="bitsPerValue")
    public Integer getBitsPerValue() {
        return super.getBitsPerValue();
    }

    @Override
    public void setBitsPerValue(Integer n) {
        super.setBitsPerValue(n);
    }

    @ValueRange(minimum=0.0)
    @XmlElement(name="toneGradation")
    public Integer getToneGradation() {
        return this.toneGradation;
    }

    public void setToneGradation(Integer n) {
        this.checkWritePermission();
        if (MetadataUtilities.ensurePositive(DefaultBand.class, "toneGradation", false, n)) {
            this.toneGradation = n;
        }
    }

    @Override
    @XmlElement(name="scaleFactor")
    public Double getScaleFactor() {
        return super.getScaleFactor();
    }

    @Override
    public void setScaleFactor(Double d) {
        super.setScaleFactor(d);
    }

    @Override
    @XmlElement(name="offset")
    public Double getOffset() {
        return super.getOffset();
    }

    @Override
    public void setOffset(Double d) {
        super.setOffset(d);
    }

    @Override
    @ValueRange(minimum=0.0, isMinIncluded=false)
    @XmlElement(name="nominalSpatialResolution", namespace="http://www.isotc211.org/2005/gmi")
    public Double getNominalSpatialResolution() {
        return super.getNominalSpatialResolution();
    }

    @Override
    public void setNominalSpatialResolution(Double d) {
        super.setNominalSpatialResolution(d);
    }

    @Override
    @XmlElement(name="transferFunctionType", namespace="http://www.isotc211.org/2005/gmi")
    public TransferFunctionType getTransferFunctionType() {
        return super.getTransferFunctionType();
    }

    @Override
    public void setTransferFunctionType(TransferFunctionType transferFunctionType) {
        super.setTransferFunctionType(transferFunctionType);
    }

    @XmlElement(name="transmittedPolarization", namespace="http://www.isotc211.org/2005/gmi")
    public PolarizationOrientation getTransmittedPolarization() {
        return this.transmittedPolarization;
    }

    public void setTransmittedPolarization(PolarizationOrientation polarizationOrientation) {
        this.checkWritePermission();
        this.transmittedPolarization = polarizationOrientation;
    }

    @XmlElement(name="detectedPolarization", namespace="http://www.isotc211.org/2005/gmi")
    public PolarizationOrientation getDetectedPolarization() {
        return this.detectedPolarization;
    }

    public void setDetectedPolarization(PolarizationOrientation polarizationOrientation) {
        this.checkWritePermission();
        this.detectedPolarization = polarizationOrientation;
    }
}

