/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import java.util.Collection;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.code.SV_CouplingType;
import org.apache.sis.metadata.iso.identification.AbstractIdentification;
import org.apache.sis.metadata.iso.identification.DefaultCoupledResource;
import org.apache.sis.metadata.iso.identification.DefaultOperationChainMetadata;
import org.apache.sis.metadata.iso.identification.DefaultOperationMetadata;
import org.apache.sis.metadata.iso.identification.OperationName;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.distribution.StandardOrderProcess;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.metadata.identification.Identification;
import org.opengis.metadata.identification.ServiceIdentification;
import org.opengis.util.CodeList;
import org.opengis.util.GenericName;

@XmlType(name="MD_ServiceIdentification_Type", propOrder={"serviceType", "serviceTypeVersions", "coupledResources", "couplingType", "containsOperations", "operatesOn"})
@XmlRootElement(name="SV_ServiceIdentification", namespace="http://www.isotc211.org/2005/srv")
public class DefaultServiceIdentification
extends AbstractIdentification
implements ServiceIdentification {
    private static final long serialVersionUID = 7700836694236616300L;
    private GenericName serviceType;
    private Collection<String> serviceTypeVersions;
    private StandardOrderProcess accessProperties;
    private CodeList<?> couplingType;
    private Collection<DefaultCoupledResource> coupledResources;
    private Collection<Citation> operatedDatasets;
    private Collection<Citation> profiles;
    private Collection<Citation> serviceStandards;
    private Collection<DefaultOperationMetadata> containsOperations;
    private Collection<DataIdentification> operatesOn;
    private Collection<DefaultOperationChainMetadata> containsChain;

    public DefaultServiceIdentification() {
    }

    public DefaultServiceIdentification(GenericName genericName, Citation citation, CharSequence charSequence) {
        super(citation, charSequence);
        this.serviceType = genericName;
    }

    public DefaultServiceIdentification(ServiceIdentification serviceIdentification) {
        super((Identification)serviceIdentification);
        if (serviceIdentification instanceof DefaultServiceIdentification) {
            DefaultServiceIdentification defaultServiceIdentification = (DefaultServiceIdentification)serviceIdentification;
            this.serviceType = defaultServiceIdentification.getServiceType();
            this.serviceTypeVersions = this.copyCollection(defaultServiceIdentification.getServiceTypeVersions(), String.class);
            this.accessProperties = defaultServiceIdentification.getAccessProperties();
            this.couplingType = defaultServiceIdentification.getCouplingType();
            this.coupledResources = this.copyCollection(defaultServiceIdentification.getCoupledResources(), DefaultCoupledResource.class);
            this.operatedDatasets = this.copyCollection(defaultServiceIdentification.getOperatedDatasets(), Citation.class);
            this.profiles = this.copyCollection(defaultServiceIdentification.getProfiles(), Citation.class);
            this.serviceStandards = this.copyCollection(defaultServiceIdentification.getServiceStandards(), Citation.class);
            this.containsOperations = this.copyCollection(defaultServiceIdentification.getContainsOperations(), DefaultOperationMetadata.class);
            this.operatesOn = this.copyCollection(defaultServiceIdentification.getOperatesOn(), DataIdentification.class);
            this.containsChain = this.copyCollection(defaultServiceIdentification.getContainsChain(), DefaultOperationChainMetadata.class);
        }
    }

    public static DefaultServiceIdentification castOrCopy(ServiceIdentification serviceIdentification) {
        if (serviceIdentification == null || serviceIdentification instanceof DefaultServiceIdentification) {
            return (DefaultServiceIdentification)serviceIdentification;
        }
        return new DefaultServiceIdentification(serviceIdentification);
    }

    @XmlElement(name="serviceType", namespace="http://www.isotc211.org/2005/srv", required=true)
    @UML(identifier="serviceType", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public GenericName getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(GenericName genericName) {
        this.checkWritePermission();
        this.serviceType = genericName;
    }

    @XmlElement(name="serviceTypeVersion", namespace="http://www.isotc211.org/2005/srv")
    @UML(identifier="serviceTypeVersion", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<String> getServiceTypeVersions() {
        this.serviceTypeVersions = this.nonNullCollection(this.serviceTypeVersions, String.class);
        return this.serviceTypeVersions;
    }

    public void setServiceTypeVersions(Collection<? extends String> collection) {
        this.serviceTypeVersions = this.writeCollection(collection, this.serviceTypeVersions, String.class);
    }

    @UML(identifier="accessProperties", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public StandardOrderProcess getAccessProperties() {
        return this.accessProperties;
    }

    public void setAccessProperties(StandardOrderProcess standardOrderProcess) {
        this.checkWritePermission();
        this.accessProperties = standardOrderProcess;
    }

    @XmlJavaTypeAdapter(value=SV_CouplingType.class)
    @XmlElement(name="couplingType", namespace="http://www.isotc211.org/2005/srv")
    @UML(identifier="couplingType", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public CodeList<?> getCouplingType() {
        return this.couplingType;
    }

    public void setCouplingType(CodeList<?> codeList) {
        this.checkWritePermission();
        this.couplingType = codeList;
    }

    @XmlElement(name="coupledResource", namespace="http://www.isotc211.org/2005/srv")
    @UML(identifier="coupledResource", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Collection<DefaultCoupledResource> getCoupledResources() {
        this.coupledResources = this.nonNullCollection(this.coupledResources, DefaultCoupledResource.class);
        return this.coupledResources;
    }

    public void setCoupledResources(Collection<? extends DefaultCoupledResource> collection) {
        this.coupledResources = this.writeCollection(collection, this.coupledResources, DefaultCoupledResource.class);
    }

    @UML(identifier="operatedDataset", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Citation> getOperatedDatasets() {
        this.operatedDatasets = this.nonNullCollection(this.operatedDatasets, Citation.class);
        return this.operatedDatasets;
    }

    public void setOperatedDatasets(Collection<? extends Citation> collection) {
        this.operatedDatasets = this.writeCollection(collection, this.operatedDatasets, Citation.class);
    }

    @UML(identifier="profile", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Citation> getProfiles() {
        this.profiles = this.nonNullCollection(this.profiles, Citation.class);
        return this.profiles;
    }

    public void setProfiles(Collection<? extends Citation> collection) {
        this.profiles = this.writeCollection(collection, this.profiles, Citation.class);
    }

    @UML(identifier="serviceStandard", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Citation> getServiceStandards() {
        this.serviceStandards = this.nonNullCollection(this.serviceStandards, Citation.class);
        return this.serviceStandards;
    }

    public void setServiceStandards(Collection<? extends Citation> collection) {
        this.serviceStandards = this.writeCollection(collection, this.serviceStandards, Citation.class);
    }

    @XmlElement(name="containsOperations", namespace="http://www.isotc211.org/2005/srv")
    @UML(identifier="containsOperations", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<DefaultOperationMetadata> getContainsOperations() {
        this.containsOperations = this.nonNullCollection(this.containsOperations, DefaultOperationMetadata.class);
        return this.containsOperations;
    }

    public void setContainsOperations(Collection<? extends DefaultOperationMetadata> collection) {
        this.containsOperations = this.writeCollection(collection, this.containsOperations, DefaultOperationMetadata.class);
    }

    @XmlElement(name="operatesOn", namespace="http://www.isotc211.org/2005/srv")
    @UML(identifier="operatesOn", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<DataIdentification> getOperatesOn() {
        this.operatesOn = this.nonNullCollection(this.operatesOn, DataIdentification.class);
        return this.operatesOn;
    }

    public void setOperatesOn(Collection<? extends DataIdentification> collection) {
        this.operatesOn = this.writeCollection(collection, this.operatesOn, DataIdentification.class);
    }

    @UML(identifier="containsChain", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<DefaultOperationChainMetadata> getContainsChain() {
        this.containsChain = this.nonNullCollection(this.containsChain, DefaultOperationChainMetadata.class);
        return this.containsChain;
    }

    public void setContainsChain(Collection<? extends DefaultOperationChainMetadata> collection) {
        this.containsChain = this.writeCollection(collection, this.containsChain, DefaultOperationChainMetadata.class);
    }

    private void afterUnmarshal(Unmarshaller unmarshaller, Object object) {
        if (this.containsOperations != null && this.coupledResources != null) {
            OperationName.resolve(this.containsOperations, this.coupledResources);
        }
    }
}

