/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata;

import java.text.Format;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.metadata.sql.Initializer;
import org.apache.sis.internal.simple.CitationConstant;
import org.apache.sis.internal.util.MetadataServices;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.ImmutableIdentifier;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.metadata.iso.citation.DefaultOrganisation;
import org.apache.sis.metadata.iso.citation.DefaultResponsibleParty;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;

public final class ServicesForUtility
extends MetadataServices {
    public CitationConstant getCitationConstant(String string) {
        Citation citation = Citations.fromName(string);
        return citation instanceof CitationConstant ? (CitationConstant)citation : null;
    }

    public Citation createCitation(String string) {
        String string2;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        Identifier[] identifierArray = null;
        String string8 = null;
        PresentationForm presentationForm = null;
        Citation[] citationArray = null;
        switch (string) {
            case "ISO 19115-1": {
                string2 = "Geographic Information \u2014 Metadata Part 1: Fundamentals";
                string4 = "ISO 19115-1:2014(E)";
                string5 = "19115-1";
                string6 = "ISO";
                string7 = "2014(E)";
                string8 = "International Organization for Standardization";
                presentationForm = PresentationForm.DOCUMENT_DIGITAL;
                break;
            }
            case "ISO 19115-2": {
                string2 = "Geographic Information \u2014 Metadata Part 2: Extensions for imagery and gridded data";
                string4 = "ISO 19115-2:2009(E)";
                string5 = "19115-2";
                string6 = "ISO";
                string7 = "2009(E)";
                citationArray = new Citation[]{Citations.ISO_19115.get(0)};
                presentationForm = PresentationForm.DOCUMENT_DIGITAL;
                break;
            }
            case "WMS": {
                string2 = "Web Map Server";
                string3 = "Geographic Information \u2014 Web map server interface";
                identifierArray = new Identifier[]{new ImmutableIdentifier(null, "OGC", "06-042", null, null), new ImmutableIdentifier(null, "ISO", "19128", "2005", null)};
                string4 = "1.3";
                string5 = "WMS";
                string6 = "OGC";
                citationArray = new Citation[]{Citations.OGC, Citations.ISO_19115.get(0)};
                presentationForm = PresentationForm.DOCUMENT_DIGITAL;
                break;
            }
            case "OGC": {
                string2 = "Identifiers in OGC namespace";
                string5 = "OGC";
                string8 = "Open Geospatial Consortium";
                presentationForm = PresentationForm.DOCUMENT_DIGITAL;
                break;
            }
            case "IOGP": {
                string2 = "Using the EPSG Geodetic Parameter Dataset";
                string5 = "IOGP";
                citationArray = new Citation[]{Citations.EPSG};
                presentationForm = PresentationForm.DOCUMENT_DIGITAL;
                break;
            }
            case "EPSG": {
                string2 = "EPSG Geodetic Parameter Dataset";
                string5 = "EPSG";
                string6 = "IOGP";
                string8 = "International Association of Oil & Gas producers";
                presentationForm = PresentationForm.TABLE_DIGITAL;
                break;
            }
            case "SIS": {
                string2 = "Apache Spatial Information System";
                string5 = string;
                break;
            }
            case "ISBN": {
                string2 = "International Standard Book Number";
                string3 = string;
                break;
            }
            case "ISSN": {
                string2 = "International Standard Serial Number";
                string3 = string;
                break;
            }
            case "Proj4": {
                string2 = "Proj.4";
                break;
            }
            case "S57": {
                string2 = "S-57";
                break;
            }
            default: {
                return super.createCitation(string);
            }
        }
        Object object = new DefaultCitation(string2);
        if (string3 != null) {
            ((DefaultCitation)object).setAlternateTitles(Collections.singleton(Types.toInternationalString((CharSequence)string3)));
        }
        if (string4 != null) {
            ((DefaultCitation)object).setEdition(Types.toInternationalString((CharSequence)string4));
        }
        if (string5 != null) {
            ((DefaultCitation)object).setIdentifiers(Collections.singleton(new ImmutableIdentifier(null, string6, string5, string7, null)));
        }
        if (presentationForm != null) {
            ((DefaultCitation)object).setPresentationForms(Collections.singleton(presentationForm));
        }
        if (string8 != null) {
            DefaultResponsibleParty defaultResponsibleParty = new DefaultResponsibleParty(Role.PRINCIPAL_INVESTIGATOR);
            defaultResponsibleParty.setParties(Collections.singleton(new DefaultOrganisation(string8, null, null, null)));
            ((DefaultCitation)object).setCitedResponsibleParties(Collections.singleton(defaultResponsibleParty));
        }
        if (citationArray != null) {
            for (Citation citation : citationArray) {
                Collection collection = citation.getCitedResponsibleParties();
                Collection<ResponsibleParty> collection2 = ((DefaultCitation)object).getCitedResponsibleParties();
                if (collection2 != null) {
                    collection2.addAll(collection);
                    continue;
                }
                ((DefaultCitation)object).setCitedResponsibleParties(collection);
            }
        }
        if (identifierArray != null) {
            ((DefaultCitation)object).getIdentifiers().addAll(Arrays.asList(identifierArray));
        }
        ((ISOMetadata)object).freeze();
        return object;
    }

    public String getInformation(String string, Locale locale) {
        switch (string) {
            case "DataSource": {
                Object object = null;
                Object object2 = null;
                try {
                    DataSource dataSource = Initializer.getDataSource();
                    if (dataSource != null) {
                        Class<?> clazz = dataSource.getClass();
                        object2 = clazz.getMethod("getDatabaseName", null).invoke((Object)dataSource, (Object[])null);
                        object = clazz.getMethod("getServerName", null).invoke((Object)dataSource, (Object[])null);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Logging.recoverableException((Logger)Logging.getLogger((String)"org.apache.sis.system"), MetadataServices.class, (String)"getInformation", (Throwable)noSuchMethodException);
                }
                catch (Exception exception) {
                    String string2 = Exceptions.getLocalizedMessage((Throwable)exception, (Locale)locale);
                    if (string2 == null || string2.indexOf(32) < 0) {
                        string2 = Classes.getShortClassName((Object)exception) + ": " + string2;
                    }
                    return string2;
                }
                if (object2 != null) {
                    if (object != null) {
                        object2 = "//" + object + '/' + object2;
                    }
                    return object2.toString();
                }
                return null;
            }
        }
        return ReferencingServices.getInstance().getInformation(string, locale);
    }

    public Format createCoordinateFormat(Locale locale, TimeZone timeZone) {
        return ReferencingServices.getInstance().createCoordinateFormat(locale, timeZone);
    }
}

