/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso;

import java.net.URI;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.ApplicationSchemaInformation;
import org.opengis.metadata.citation.Citation;

@XmlType(name="MD_ApplicationSchemaInformation_Type", propOrder={"name", "schemaLanguage", "constraintLanguage", "schemaAscii", "graphicsFile", "softwareDevelopmentFile", "softwareDevelopmentFileFormat"})
@XmlRootElement(name="MD_ApplicationSchemaInformation")
public class DefaultApplicationSchemaInformation
extends ISOMetadata
implements ApplicationSchemaInformation {
    private static final long serialVersionUID = -884081423040392985L;
    private Citation name;
    private String schemaLanguage;
    private String constraintLanguage;
    private URI schemaAscii;
    private URI graphicsFile;
    private URI softwareDevelopmentFile;
    private String softwareDevelopmentFileFormat;

    public DefaultApplicationSchemaInformation() {
    }

    public DefaultApplicationSchemaInformation(Citation citation, String string, String string2) {
        this.name = citation;
        this.schemaLanguage = string;
        this.constraintLanguage = string2;
    }

    public DefaultApplicationSchemaInformation(ApplicationSchemaInformation applicationSchemaInformation) {
        super(applicationSchemaInformation);
        if (applicationSchemaInformation != null) {
            this.name = applicationSchemaInformation.getName();
            this.schemaLanguage = applicationSchemaInformation.getSchemaLanguage();
            this.constraintLanguage = applicationSchemaInformation.getConstraintLanguage();
            this.schemaAscii = applicationSchemaInformation.getSchemaAscii();
            this.graphicsFile = applicationSchemaInformation.getGraphicsFile();
            this.softwareDevelopmentFile = applicationSchemaInformation.getSoftwareDevelopmentFile();
            this.softwareDevelopmentFileFormat = applicationSchemaInformation.getSoftwareDevelopmentFileFormat();
        }
    }

    public static DefaultApplicationSchemaInformation castOrCopy(ApplicationSchemaInformation applicationSchemaInformation) {
        if (applicationSchemaInformation == null || applicationSchemaInformation instanceof DefaultApplicationSchemaInformation) {
            return (DefaultApplicationSchemaInformation)applicationSchemaInformation;
        }
        return new DefaultApplicationSchemaInformation(applicationSchemaInformation);
    }

    @XmlElement(name="name", required=true)
    public Citation getName() {
        return this.name;
    }

    public void setName(Citation citation) {
        this.checkWritePermission();
        this.name = citation;
    }

    @XmlElement(name="schemaLanguage", required=true)
    public String getSchemaLanguage() {
        return this.schemaLanguage;
    }

    public void setSchemaLanguage(String string) {
        this.checkWritePermission();
        this.schemaLanguage = string;
    }

    @XmlElement(name="constraintLanguage", required=true)
    public String getConstraintLanguage() {
        return this.constraintLanguage;
    }

    public void setConstraintLanguage(String string) {
        this.checkWritePermission();
        this.constraintLanguage = string;
    }

    @XmlElement(name="schemaAscii")
    public URI getSchemaAscii() {
        return this.schemaAscii;
    }

    public void setSchemaAscii(URI uRI) {
        this.checkWritePermission();
        this.schemaAscii = uRI;
    }

    @XmlElement(name="graphicsFile")
    public URI getGraphicsFile() {
        return this.graphicsFile;
    }

    public void setGraphicsFile(URI uRI) {
        this.checkWritePermission();
        this.graphicsFile = uRI;
    }

    @XmlElement(name="softwareDevelopmentFile")
    public URI getSoftwareDevelopmentFile() {
        return this.softwareDevelopmentFile;
    }

    public void setSoftwareDevelopmentFile(URI uRI) {
        this.checkWritePermission();
        this.softwareDevelopmentFile = uRI;
    }

    @XmlElement(name="softwareDevelopmentFileFormat")
    public String getSoftwareDevelopmentFileFormat() {
        return this.softwareDevelopmentFileFormat;
    }

    public void setSoftwareDevelopmentFileFormat(String string) {
        this.checkWritePermission();
        this.softwareDevelopmentFileFormat = string;
    }
}

