/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.j2d;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.internal.referencing.ExtendedPrecisionMatrix;
import org.apache.sis.internal.referencing.j2d.AffineMatrix;
import org.apache.sis.internal.referencing.j2d.ImmutableAffineTransform;
import org.apache.sis.internal.referencing.provider.Affine;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.referencing.operation.matrix.AffineTransforms2D;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;

public class AffineTransform2D
extends ImmutableAffineTransform
implements MathTransform2D,
LinearTransform,
LenientComparable,
Parameterized {
    private static final long serialVersionUID = -5299837898367149069L;
    private final AffineMatrix matrix;
    private volatile transient AffineTransform2D inverse;

    public AffineTransform2D(AffineTransform affineTransform) {
        super(affineTransform);
        this.forcePositiveZeros();
        this.matrix = new AffineMatrix(this, null);
    }

    public AffineTransform2D(double[] dArray) {
        super(AffineTransform2D.pz(dArray[0]), AffineTransform2D.pz(dArray[3]), AffineTransform2D.pz(dArray[1]), AffineTransform2D.pz(dArray[4]), AffineTransform2D.pz(dArray[2]), AffineTransform2D.pz(dArray[5]));
        this.matrix = new AffineMatrix(this, dArray);
    }

    public AffineTransform2D(double d, double d2, double d3, double d4, double d5, double d6) {
        super(AffineTransform2D.pz(d), AffineTransform2D.pz(d2), AffineTransform2D.pz(d3), AffineTransform2D.pz(d4), AffineTransform2D.pz(d5), AffineTransform2D.pz(d6));
        this.matrix = new AffineMatrix(this, null);
    }

    private static double pz(double d) {
        return d != 0.0 ? d : 0.0;
    }

    public final void forcePositiveZeros() {
        super.setTransform(AffineTransform2D.pz(super.getScaleX()), AffineTransform2D.pz(super.getShearY()), AffineTransform2D.pz(super.getShearX()), AffineTransform2D.pz(super.getScaleY()), AffineTransform2D.pz(super.getTranslateX()), AffineTransform2D.pz(super.getTranslateY()));
    }

    @Override
    protected final void checkPermission() throws UnsupportedOperationException {
        if (this.matrix != null) {
            super.checkPermission();
        }
    }

    @Override
    public final boolean isAffine() {
        return true;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Affine.getProvider(2, 2, true).getParameters();
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return Affine.parameters(this.matrix);
    }

    public final int getSourceDimensions() {
        return 2;
    }

    public final int getTargetDimensions() {
        return 2;
    }

    public final DirectPosition transform(DirectPosition directPosition, DirectPosition directPosition2) {
        ArgumentChecks.ensureDimensionMatches((String)"ptSrc", (int)2, (DirectPosition)directPosition);
        if (directPosition2 == directPosition) {
            if (directPosition instanceof Point2D) {
                Point2D point2D = (Point2D)directPosition;
                super.transform(point2D, point2D);
                return directPosition;
            }
        } else {
            if (directPosition2 == null) {
                DirectPosition2D directPosition2D = new DirectPosition2D(directPosition.getOrdinate(0), directPosition.getOrdinate(1));
                super.transform(directPosition2D, directPosition2D);
                return directPosition2D;
            }
            ArgumentChecks.ensureDimensionMatches((String)"ptDst", (int)2, (DirectPosition)directPosition2);
            if (directPosition2 instanceof Point2D) {
                Point2D point2D = (Point2D)directPosition2;
                point2D.setLocation(directPosition.getOrdinate(0), directPosition.getOrdinate(1));
                super.transform(point2D, point2D);
                return directPosition2;
            }
        }
        Point2D.Double double_ = new Point2D.Double(directPosition.getOrdinate(0), directPosition.getOrdinate(1));
        super.transform(double_, double_);
        directPosition2.setOrdinate(0, double_.x);
        directPosition2.setOrdinate(1, double_.y);
        return directPosition2;
    }

    @Override
    public final Shape createTransformedShape(Shape shape) {
        return AffineTransforms2D.transform((AffineTransform)this, shape, false);
    }

    @Override
    public final Matrix getMatrix() {
        return this.matrix;
    }

    public final Matrix derivative(Point2D point2D) {
        return new Matrix2(this.getScaleX(), this.getShearX(), this.getShearY(), this.getScaleY());
    }

    public final Matrix derivative(DirectPosition directPosition) {
        return this.derivative((Point2D)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MathTransform2D inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            if (super.isIdentity()) {
                this.inverse = this;
            } else {
                AffineTransform2D affineTransform2D = this;
                synchronized (affineTransform2D) {
                    if (this.inverse == null) {
                        AffineTransform2D affineTransform2D2 = new AffineTransform2D(((ExtendedPrecisionMatrix)((Object)Matrices.inverse(this.matrix))).getExtendedElements());
                        affineTransform2D2.inverse = this;
                        this.inverse = affineTransform2D2;
                    }
                }
            }
        }
        return this.inverse;
    }

    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (comparisonMode == ComparisonMode.STRICT) {
            return this.equals(object);
        }
        if (object instanceof LinearTransform) {
            Matrix matrix = ((LinearTransform)object).getMatrix();
            return AffineTransforms2D.toMatrix(this).equals((Object)matrix, comparisonMode);
        }
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (object != this) {
            if (!super.equals(object)) {
                return false;
            }
            if (object instanceof AffineTransform2D) {
                return object.getClass() == this.getClass();
            }
        }
        return true;
    }

    @Override
    public AffineTransform clone() {
        return new AffineTransform(this);
    }

    public String toWKT() {
        Formatter formatter = new Formatter();
        formatter.append((MathTransform)this);
        return formatter.toWKT();
    }

    @Override
    public String toString() {
        return Matrices.toString(this.getMatrix());
    }
}

