/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.referencing.CC_OperationParameterGroup;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.parameter.AbstractParameterDescriptor;
import org.apache.sis.parameter.DefaultParameterValue;
import org.apache.sis.parameter.DefaultParameterValueGroup;
import org.apache.sis.parameter.Verifier;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;

@XmlType(name="OperationParameterGroupType")
@XmlRootElement(name="OperationParameterGroup")
public class DefaultParameterDescriptorGroup
extends AbstractParameterDescriptor
implements ParameterDescriptorGroup {
    private static final long serialVersionUID = 6058599597772994456L;
    private List<GeneralParameterDescriptor> descriptors;

    public DefaultParameterDescriptorGroup(Map<String, ?> map, int n, int n2, GeneralParameterDescriptor ... generalParameterDescriptorArray) {
        super(map, n, n2);
        ArgumentChecks.ensureNonNull((String)"parameters", (Object)generalParameterDescriptorArray);
        generalParameterDescriptorArray = (GeneralParameterDescriptor[])generalParameterDescriptorArray.clone();
        DefaultParameterDescriptorGroup.verifyNames(map, generalParameterDescriptorArray);
        this.descriptors = DefaultParameterDescriptorGroup.asList(generalParameterDescriptorArray);
    }

    DefaultParameterDescriptorGroup(Map<String, ?> map, GeneralParameterDescriptor[] generalParameterDescriptorArray) {
        super(map, 1, 1);
        DefaultParameterDescriptorGroup.verifyNames(map, (GeneralParameterDescriptor[])generalParameterDescriptorArray.clone());
        this.descriptors = DefaultParameterDescriptorGroup.asList(generalParameterDescriptorArray);
    }

    private static void verifyNames(Map<String, ?> map, GeneralParameterDescriptor[] generalParameterDescriptorArray) {
        for (int i = 0; i < generalParameterDescriptorArray.length; ++i) {
            ArgumentChecks.ensureNonNullElement((String)"parameters", (int)i, (Object)generalParameterDescriptorArray);
            String string = generalParameterDescriptorArray[i].getName().getCode();
            for (int j = 0; j < i; ++j) {
                if (!IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)generalParameterDescriptorArray[j], string)) continue;
                throw new InvalidParameterNameException(Errors.getResources(map).getString((short)150, (Object)Verifier.getDisplayName(generalParameterDescriptorArray[j]), (Object)j, (Object)string, (Object)i), string);
            }
        }
    }

    protected DefaultParameterDescriptorGroup(ParameterDescriptorGroup parameterDescriptorGroup) {
        super((GeneralParameterDescriptor)parameterDescriptorGroup);
        List<Object> list = parameterDescriptorGroup.descriptors();
        this.descriptors = parameterDescriptorGroup instanceof DefaultParameterDescriptorGroup && ((DefaultParameterDescriptorGroup)parameterDescriptorGroup).descriptors == list ? list : DefaultParameterDescriptorGroup.asList(list.toArray(new GeneralParameterDescriptor[list.size()]));
    }

    private static List<GeneralParameterDescriptor> asList(GeneralParameterDescriptor[] generalParameterDescriptorArray) {
        switch (generalParameterDescriptorArray.length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(generalParameterDescriptorArray[0]);
            }
            case 2: 
            case 3: {
                return UnmodifiableArrayList.wrap((Object[])generalParameterDescriptorArray);
            }
        }
        return new AsList(generalParameterDescriptorArray);
    }

    public static DefaultParameterDescriptorGroup castOrCopy(ParameterDescriptorGroup parameterDescriptorGroup) {
        return parameterDescriptorGroup == null || parameterDescriptorGroup instanceof DefaultParameterDescriptorGroup ? (DefaultParameterDescriptorGroup)parameterDescriptorGroup : new DefaultParameterDescriptorGroup(parameterDescriptorGroup);
    }

    public Class<? extends ParameterDescriptorGroup> getInterface() {
        return ParameterDescriptorGroup.class;
    }

    public List<GeneralParameterDescriptor> descriptors() {
        return this.descriptors;
    }

    public GeneralParameterDescriptor descriptor(String string) throws ParameterNotFoundException {
        GeneralParameterDescriptor generalParameterDescriptor2;
        ArgumentChecks.ensureNonNull((String)"name", (Object)string);
        for (GeneralParameterDescriptor generalParameterDescriptor2 : this.descriptors) {
            if (!string.equals(generalParameterDescriptor2.getName().getCode())) continue;
            return generalParameterDescriptor2;
        }
        GeneralParameterDescriptor generalParameterDescriptor3 = null;
        generalParameterDescriptor2 = null;
        for (GeneralParameterDescriptor generalParameterDescriptor4 : this.descriptors) {
            if (!IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)generalParameterDescriptor4, string)) continue;
            if (generalParameterDescriptor3 == null) {
                generalParameterDescriptor3 = generalParameterDescriptor4;
                continue;
            }
            generalParameterDescriptor2 = generalParameterDescriptor4;
        }
        if (generalParameterDescriptor3 != null && generalParameterDescriptor2 == null) {
            return generalParameterDescriptor3;
        }
        throw new ParameterNotFoundException(generalParameterDescriptor2 != null ? Errors.format((short)151, (Object)IdentifiedObjects.toString((Identifier)generalParameterDescriptor3.getName()), (Object)IdentifiedObjects.toString((Identifier)generalParameterDescriptor2.getName()), (Object)string) : Errors.format((short)147, (Object)Verifier.getDisplayName(this), (Object)string), string);
    }

    public ParameterValueGroup createValue() {
        return new DefaultParameterValueGroup(this);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            switch (comparisonMode) {
                case STRICT: {
                    return this.descriptors.equals(((DefaultParameterDescriptorGroup)object).descriptors);
                }
            }
            return Utilities.deepEquals(this.descriptors(), (Object)((ParameterDescriptorGroup)object).descriptors(), (ComparisonMode)comparisonMode);
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)this.descriptors.hashCode();
    }

    DefaultParameterDescriptorGroup() {
        this.descriptors = Collections.emptyList();
    }

    @XmlElement(name="parameter", required=true)
    private GeneralParameterDescriptor[] getDescriptors() {
        List<GeneralParameterDescriptor> list = this.descriptors();
        return list.toArray(new GeneralParameterDescriptor[list.size()]);
    }

    private void setDescriptors(GeneralParameterDescriptor[] generalParameterDescriptorArray) {
        if (this.descriptors.isEmpty()) {
            DefaultParameterDescriptorGroup.verifyNames(null, generalParameterDescriptorArray);
            this.descriptors = DefaultParameterDescriptorGroup.asList(generalParameterDescriptorArray);
        } else {
            ReferencingUtilities.propertyAlreadySet(DefaultParameterValue.class, "setDescriptors", "parameter");
        }
    }

    final void merge(GeneralParameterDescriptor[] generalParameterDescriptorArray, Map<GeneralParameterDescriptor, GeneralParameterDescriptor> map) {
        generalParameterDescriptorArray = CC_OperationParameterGroup.merge(this.descriptors, generalParameterDescriptorArray, map);
        DefaultParameterDescriptorGroup.verifyNames(null, generalParameterDescriptorArray);
        this.descriptors = DefaultParameterDescriptorGroup.asList(generalParameterDescriptorArray);
    }

    private static final class AsList
    extends UnmodifiableArrayList<GeneralParameterDescriptor> {
        private static final long serialVersionUID = -2116304004367396735L;
        private volatile transient Set<GeneralParameterDescriptor> asSet;

        public AsList(GeneralParameterDescriptor[] generalParameterDescriptorArray) {
            super((Object[])generalParameterDescriptorArray);
        }

        public boolean contains(Object object) {
            Set<GeneralParameterDescriptor> set = this.asSet;
            if (set == null) {
                this.asSet = set = new HashSet<GeneralParameterDescriptor>((Collection<GeneralParameterDescriptor>)((Object)this));
            }
            return set.contains(object);
        }
    }
}

