/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.io.IOException;
import java.lang.reflect.Array;
import java.text.FieldPosition;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.measure.unit.Unit;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.metadata.NameToIdentifier;
import org.apache.sis.internal.util.X364;
import org.apache.sis.io.wkt.Colors;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.measure.Range;
import org.apache.sis.measure.RangeFormat;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.Deprecable;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;

final class ParameterTableRow {
    private final Map<String, Set<Object>> identifiers;
    int codespaceWidth;
    String valueDomain;
    int valueDomainAlignment;
    final List<Object> values = new ArrayList<Object>(2);
    final List<Object> units = new ArrayList<Object>(2);
    private int remarks;

    ParameterTableRow(IdentifiedObject identifiedObject, Locale locale, Set<String> set, Map<String, Integer> map, boolean bl) {
        String string;
        Object object;
        Iterator iterator;
        Object object2;
        this.identifiers = new LinkedHashMap<String, Set<Object>>();
        ReferenceIdentifier referenceIdentifier = identifiedObject.getName();
        if (referenceIdentifier != null) {
            object2 = referenceIdentifier.getCodeSpace();
            if (set == null || set.contains(object2)) {
                this.addIdentifier((String)object2, referenceIdentifier.getCode());
                referenceIdentifier = null;
            }
        }
        if ((!bl || this.identifiers.isEmpty()) && (object2 = identifiedObject.getAlias()) != null) {
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (GenericName)iterator.next();
                if (ParameterTableRow.isDeprecated(object)) continue;
                string = NameToIdentifier.getCodeSpace((GenericName)object, (Locale)locale);
                if (string != null) {
                    object = object.tip();
                }
                if (set != null && !set.contains(string)) continue;
                this.addIdentifier(string, NameToIdentifier.toString((GenericName)object, (Locale)locale));
                referenceIdentifier = null;
                if (!bl) continue;
                break;
            }
        }
        if (referenceIdentifier != null) {
            this.addIdentifier(referenceIdentifier.getCodeSpace(), referenceIdentifier.getCode());
        }
        if (!bl && (object2 = identifiedObject.getIdentifiers()) != null) {
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (ReferenceIdentifier)iterator.next();
                if (ParameterTableRow.isDeprecated(object)) continue;
                string = object.getCodeSpace();
                if (set != null && !set.contains(string)) continue;
                this.addIdentifier(string, object);
            }
        }
        if ((object2 = identifiedObject.getRemarks()) != null) {
            int n = map.size() + 1;
            object = (Integer)JDK8.putIfAbsent(map, (Object)object2.toString(locale), (Object)n);
            this.remarks = object != null ? (Integer)object : n;
        }
    }

    private static boolean isDeprecated(Object object) {
        return object instanceof Deprecable && ((Deprecable)object).isDeprecated();
    }

    private void addIdentifier(String string, Object object) {
        Set<Object> set;
        int n;
        if (string != null && (n = string.codePointCount(0, string.length())) > this.codespaceWidth) {
            this.codespaceWidth = n;
        }
        if ((set = this.identifiers.get(string)) == null) {
            set = new LinkedHashSet<Object>(8);
            this.identifiers.put(string, set);
        }
        set.add(object);
    }

    final String getCodeSpace() {
        Iterator<Map.Entry<String, Set<Object>>> iterator = this.identifiers.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, Set<Object>> entry = iterator.next();
            if (!iterator.hasNext()) {
                return entry.getKey();
            }
        }
        return null;
    }

    final int setValueDomain(Range<?> range, Format format, StringBuffer stringBuffer) {
        FieldPosition fieldPosition = new FieldPosition((Format.Field)RangeFormat.Field.MAX_VALUE);
        this.valueDomain = format.format(range, stringBuffer, fieldPosition).toString();
        stringBuffer.setLength(0);
        this.valueDomainAlignment = fieldPosition.getBeginIndex();
        return this.valueDomainAlignment;
    }

    final void addValue(Object object, Unit<?> unit) {
        this.values.add(object);
        this.units.add(unit);
    }

    final void expandSingleton() {
        Object[] objectArray;
        assert (this.values.size() == this.units.size());
        if (this.values.size() == 1 && (objectArray = this.values.get(0)) != null) {
            if (objectArray instanceof Collection) {
                objectArray = ((Collection)objectArray).toArray();
            }
            if (objectArray.getClass().isArray()) {
                int n = Array.getLength(objectArray);
                Object object = this.units.get(0);
                this.values.clear();
                this.units.clear();
                for (int i = 0; i < n; ++i) {
                    this.values.add(Array.get(objectArray, i));
                    this.units.add(object);
                }
            }
        }
    }

    private static void writeColor(Appendable appendable, Colors colors, ElementKind elementKind) throws IOException {
        String string;
        if (colors != null && (string = colors.getName(elementKind)) != null) {
            appendable.append(X364.forColorName((String)string).sequence());
        }
    }

    private static void writeColor(Appendable appendable, X364 x364, boolean bl) throws IOException {
        if (bl) {
            appendable.append(x364.sequence());
        }
    }

    final void writeIdentifiers(Appendable appendable, boolean bl, Colors colors, boolean bl2, String string) throws IOException {
        if (this.codespaceWidth != 0) {
            this.codespaceWidth += 2;
        }
        boolean bl3 = false;
        for (Map.Entry<String, Set<Object>> entry : this.identifiers.entrySet()) {
            String string2 = entry.getKey();
            Set<Object> set = entry.getValue();
            Iterator<Object> iterator = set.iterator();
            while (iterator.hasNext()) {
                int n;
                if (bl3) {
                    appendable.append(string);
                }
                bl3 = true;
                ParameterTableRow.writeColor(appendable, colors, ElementKind.NAME);
                if (bl) {
                    n = this.codespaceWidth;
                    if (string2 != null) {
                        ParameterTableRow.writeColor(appendable, X364.FAINT, bl2);
                        appendable.append(string2).append(':');
                        ParameterTableRow.writeColor(appendable, X364.NORMAL, bl2);
                        n -= string2.length() + 1;
                    }
                    appendable.append(CharSequences.spaces((int)n));
                }
                ParameterTableRow.writeColor(appendable, X364.BOLD, colors != null);
                appendable.append(ParameterTableRow.toString(iterator.next()));
                ParameterTableRow.writeColor(appendable, X364.RESET, colors != null);
                iterator.remove();
                if (this.remarks != 0) {
                    ParameterTableRow.writeFootnoteNumber(appendable, this.remarks);
                    this.remarks = 0;
                }
                n = 0;
                boolean bl4 = false;
                while (iterator.hasNext()) {
                    Object object = iterator.next();
                    if (object instanceof Identifier) {
                        appendable.append(bl4 ? ", " : " (");
                        ParameterTableRow.writeColor(appendable, colors, ElementKind.IDENTIFIER);
                        appendable.append(ParameterTableRow.toString(object));
                        ParameterTableRow.writeColor(appendable, X364.FOREGROUND_DEFAULT, colors != null);
                        bl4 = true;
                        iterator.remove();
                        continue;
                    }
                    n = 1;
                }
                if (bl4) {
                    appendable.append(')');
                }
                if (n == 0) continue;
                iterator = set.iterator();
            }
        }
    }

    static void writeFootnoteNumber(Appendable appendable, int n) throws IOException {
        if (n >= 0 && n < 10) {
            appendable.append(Characters.toSuperScript((char)((char)(48 + n))));
        } else {
            appendable.append('(').append(Integer.toString(n)).append(')');
        }
    }

    private static String toString(Object object) {
        if (object instanceof Identifier) {
            object = ((Identifier)object).getCode();
        }
        return object.toString();
    }
}

