/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.logging.Logger;
import javax.measure.unit.BaseUnit;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.apache.sis.internal.system.SystemListener;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.StandardDefinitions;
import org.apache.sis.referencing.crs.DefaultGeocentricCRS;
import org.apache.sis.referencing.crs.DefaultGeographicCRS;
import org.apache.sis.referencing.crs.DefaultTemporalCRS;
import org.apache.sis.referencing.crs.DefaultVerticalCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.DefaultCoordinateSystemAxis;
import org.apache.sis.referencing.cs.DefaultTimeCS;
import org.apache.sis.referencing.cs.DefaultVerticalCS;
import org.apache.sis.referencing.datum.DefaultTemporalDatum;
import org.apache.sis.referencing.datum.DefaultVerticalDatum;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;
import org.opengis.util.NoSuchIdentifierException;

public enum CommonCRS {
    WGS84(4326, 4979, 4978, 6326, 7030),
    WGS72(4322, 4985, 4984, 6322, 7043),
    ETRS89(4258, 4937, 4936, 6258, 7019),
    NAD83(4269, 0, 0, 6269, 7019),
    NAD27(4267, 0, 0, 6267, 7008),
    ED50(4230, 0, 0, 6230, 7022),
    SPHERE(4047, 0, 0, 6047, 7048);

    static final CommonCRS DEFAULT;
    final short geographic;
    final short geo3D;
    final short geocentric;
    final short datum;
    final short ellipsoid;
    private volatile transient IdentifiedObject cached;
    private volatile transient GeographicCRS cachedNormalized;
    private volatile transient GeographicCRS cachedGeo3D;
    private volatile transient GeocentricCRS cachedGeocentric;

    private CommonCRS(short s, short s2, short s3, short s4, short s5) {
        this.geographic = s;
        this.geocentric = s3;
        this.geo3D = s2;
        this.datum = s4;
        this.ellipsoid = s5;
    }

    synchronized void clear() {
        this.cached = null;
        this.cachedGeo3D = null;
        this.cachedNormalized = null;
        this.cachedGeocentric = null;
    }

    public static GeographicCRS defaultGeographic() {
        return DEFAULT.normalizedGeographic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeographicCRS normalizedGeographic() {
        GeographicCRS geographicCRS = this.cachedNormalized;
        if (geographicCRS == null) {
            DefaultGeographicCRS defaultGeographicCRS = DefaultGeographicCRS.castOrCopy(this.geographic());
            defaultGeographicCRS = defaultGeographicCRS.forConvention(AxesConvention.RIGHT_HANDED);
            CommonCRS commonCRS = this;
            synchronized (commonCRS) {
                geographicCRS = this.cachedNormalized;
                if (geographicCRS == null) {
                    this.cachedNormalized = geographicCRS = defaultGeographicCRS;
                }
            }
        }
        return geographicCRS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeographicCRS geographic() {
        GeographicCRS geographicCRS = CommonCRS.geographic(this.cached);
        if (geographicCRS == null) {
            CommonCRS commonCRS = this;
            synchronized (commonCRS) {
                geographicCRS = CommonCRS.geographic(this.cached);
                if (geographicCRS == null) {
                    CRSAuthorityFactory cRSAuthorityFactory = CommonCRS.crsFactory();
                    if (cRSAuthorityFactory != null) {
                        try {
                            geographicCRS = cRSAuthorityFactory.createGeographicCRS(String.valueOf(this.geographic));
                            this.cached = geographicCRS;
                            return geographicCRS;
                        }
                        catch (FactoryException factoryException) {
                            CommonCRS.failure((Object)this, "geographic", factoryException);
                        }
                    }
                    EllipsoidalCS ellipsoidalCS = this == DEFAULT ? (EllipsoidalCS)StandardDefinitions.createCoordinateSystem((short)6422) : DEFAULT.geographic().getCoordinateSystem();
                    geographicCRS = StandardDefinitions.createGeographicCRS(this.geographic, this.datum(), ellipsoidalCS);
                    this.cached = geographicCRS;
                }
            }
        }
        return geographicCRS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeographicCRS geographic3D() {
        GeographicCRS geographicCRS = this.cachedGeo3D;
        if (geographicCRS == null) {
            CommonCRS commonCRS = this;
            synchronized (commonCRS) {
                geographicCRS = this.cachedGeo3D;
                if (geographicCRS == null) {
                    CRSAuthorityFactory cRSAuthorityFactory;
                    if (this.geo3D != 0 && (cRSAuthorityFactory = CommonCRS.crsFactory()) != null) {
                        try {
                            this.cachedGeo3D = geographicCRS = cRSAuthorityFactory.createGeographicCRS(String.valueOf(this.geo3D));
                            return geographicCRS;
                        }
                        catch (FactoryException factoryException) {
                            CommonCRS.failure((Object)this, "geographic3D", factoryException);
                        }
                    }
                    cRSAuthorityFactory = this == DEFAULT ? (EllipsoidalCS)StandardDefinitions.createCoordinateSystem((short)6423) : DEFAULT.geographic3D().getCoordinateSystem();
                    GeographicCRS geographicCRS2 = this.geographic();
                    this.cachedGeo3D = geographicCRS = new DefaultGeographicCRS(IdentifiedObjects.getProperties((IdentifiedObject)geographicCRS2, new String[0]), geographicCRS2.getDatum(), (EllipsoidalCS)cRSAuthorityFactory);
                }
            }
        }
        return geographicCRS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeocentricCRS geocentric() {
        GeocentricCRS geocentricCRS = this.cachedGeocentric;
        if (geocentricCRS == null) {
            CommonCRS commonCRS = this;
            synchronized (commonCRS) {
                geocentricCRS = this.cachedGeocentric;
                if (geocentricCRS == null) {
                    CRSAuthorityFactory cRSAuthorityFactory;
                    if (this.geocentric != 0 && (cRSAuthorityFactory = CommonCRS.crsFactory()) != null) {
                        try {
                            this.cachedGeocentric = geocentricCRS = cRSAuthorityFactory.createGeocentricCRS(String.valueOf(this.geocentric));
                            return geocentricCRS;
                        }
                        catch (FactoryException factoryException) {
                            CommonCRS.failure((Object)this, "geocentric", factoryException);
                        }
                    }
                    cRSAuthorityFactory = this == DEFAULT ? (CartesianCS)StandardDefinitions.createCoordinateSystem((short)6500) : (CartesianCS)DEFAULT.geocentric().getCoordinateSystem();
                    GeographicCRS geographicCRS = this.geographic();
                    this.cachedGeocentric = geocentricCRS = new DefaultGeocentricCRS(IdentifiedObjects.getProperties((IdentifiedObject)geographicCRS, new String[0]), geographicCRS.getDatum(), (CartesianCS)cRSAuthorityFactory);
                }
            }
        }
        return geocentricCRS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeodeticDatum datum() {
        GeodeticDatum geodeticDatum = CommonCRS.datum(this.cached);
        if (geodeticDatum == null) {
            CommonCRS commonCRS = this;
            synchronized (commonCRS) {
                geodeticDatum = CommonCRS.datum(this.cached);
                if (geodeticDatum == null) {
                    DatumAuthorityFactory datumAuthorityFactory = CommonCRS.datumFactory();
                    if (datumAuthorityFactory != null) {
                        try {
                            geodeticDatum = datumAuthorityFactory.createGeodeticDatum(String.valueOf(this.datum));
                            this.cached = geodeticDatum;
                            return geodeticDatum;
                        }
                        catch (FactoryException factoryException) {
                            CommonCRS.failure((Object)this, "datum", factoryException);
                        }
                    }
                    geodeticDatum = StandardDefinitions.createGeodeticDatum(this.datum, this.ellipsoid(), this.primeMeridian());
                    this.cached = geodeticDatum;
                }
            }
        }
        return geodeticDatum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ellipsoid ellipsoid() {
        Ellipsoid ellipsoid = CommonCRS.ellipsoid(this.cached);
        if (ellipsoid == null) {
            CommonCRS commonCRS = this;
            synchronized (commonCRS) {
                ellipsoid = CommonCRS.ellipsoid(this.cached);
                if (ellipsoid == null) {
                    if (this == NAD83) {
                        ellipsoid = ETRS89.ellipsoid();
                    } else {
                        DatumAuthorityFactory datumAuthorityFactory = CommonCRS.datumFactory();
                        if (datumAuthorityFactory != null) {
                            try {
                                ellipsoid = datumAuthorityFactory.createEllipsoid(String.valueOf(this.ellipsoid));
                                this.cached = ellipsoid;
                                return ellipsoid;
                            }
                            catch (FactoryException factoryException) {
                                CommonCRS.failure((Object)this, "ellipsoid", factoryException);
                            }
                        }
                        ellipsoid = StandardDefinitions.createEllipsoid(this.ellipsoid);
                    }
                    this.cached = ellipsoid;
                }
            }
        }
        return ellipsoid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrimeMeridian primeMeridian() {
        PrimeMeridian primeMeridian = CommonCRS.primeMeridian(this.cached);
        if (primeMeridian == null) {
            CommonCRS commonCRS = this;
            synchronized (commonCRS) {
                primeMeridian = CommonCRS.primeMeridian(this.cached);
                if (primeMeridian == null) {
                    if (this != DEFAULT) {
                        primeMeridian = DEFAULT.primeMeridian();
                    } else {
                        DatumAuthorityFactory datumAuthorityFactory = CommonCRS.datumFactory();
                        if (datumAuthorityFactory != null) {
                            try {
                                primeMeridian = datumAuthorityFactory.createPrimeMeridian("8901");
                                this.cached = primeMeridian;
                                return primeMeridian;
                            }
                            catch (FactoryException factoryException) {
                                CommonCRS.failure((Object)this, "primeMeridian", factoryException);
                            }
                        }
                        primeMeridian = StandardDefinitions.primeMeridian();
                    }
                    this.cached = primeMeridian;
                }
            }
        }
        return primeMeridian;
    }

    private static GeographicCRS geographic(IdentifiedObject identifiedObject) {
        return identifiedObject instanceof GeographicCRS ? (GeographicCRS)identifiedObject : null;
    }

    private static GeodeticDatum datum(IdentifiedObject identifiedObject) {
        if (identifiedObject instanceof GeodeticDatum) {
            return (GeodeticDatum)identifiedObject;
        }
        if (identifiedObject instanceof GeodeticCRS) {
            return ((GeodeticCRS)identifiedObject).getDatum();
        }
        return null;
    }

    private static Ellipsoid ellipsoid(IdentifiedObject identifiedObject) {
        if (identifiedObject instanceof Ellipsoid) {
            return (Ellipsoid)identifiedObject;
        }
        GeodeticDatum geodeticDatum = CommonCRS.datum(identifiedObject);
        return geodeticDatum != null ? geodeticDatum.getEllipsoid() : null;
    }

    private static PrimeMeridian primeMeridian(IdentifiedObject identifiedObject) {
        if (identifiedObject instanceof PrimeMeridian) {
            return (PrimeMeridian)identifiedObject;
        }
        GeodeticDatum geodeticDatum = CommonCRS.datum(identifiedObject);
        return geodeticDatum != null ? geodeticDatum.getPrimeMeridian() : null;
    }

    static Map<String, ?> properties(short s) {
        return CommonCRS.properties(Vocabulary.formatInternational((short)s));
    }

    static Map<String, ?> properties(InternationalString internationalString) {
        return Collections.singletonMap("name", new NamedIdentifier(null, (CharSequence)internationalString));
    }

    static CRSAuthorityFactory crsFactory() {
        return null;
    }

    static DatumAuthorityFactory datumFactory() {
        return null;
    }

    static void failure(Object object, String string, FactoryException factoryException) {
        Logging.unexpectedException((Logger)Logging.getLogger((String)"org.apache.sis.referencing.factory"), object.getClass(), (String)string, (Throwable)factoryException);
    }

    static CoordinateReferenceSystem forCode(String string, String string2, FactoryException factoryException) throws FactoryException {
        NumberFormatException numberFormatException;
        block16: {
            numberFormatException = null;
            try {
                if (string.equalsIgnoreCase("CRS")) {
                    switch (Integer.parseInt(string2)) {
                        case 27: {
                            return NAD27.normalizedGeographic();
                        }
                        case 83: {
                            return NAD83.normalizedGeographic();
                        }
                        case 84: {
                            return WGS84.normalizedGeographic();
                        }
                    }
                    break block16;
                }
                if (string.equalsIgnoreCase("EPSG")) {
                    int n = Integer.parseInt(string2);
                    if (n != 0) {
                        for (CommonCRS enum_ : CommonCRS.values()) {
                            if (enum_.geographic == n) {
                                return enum_.geographic();
                            }
                            if (enum_.geocentric == n) {
                                return enum_.geocentric();
                            }
                            if (enum_.geo3D != n) continue;
                            return enum_.geographic3D();
                        }
                        for (Enum enum_ : Vertical.values()) {
                            if (!((Vertical)enum_).isEPSG || ((Vertical)enum_).crs != n) continue;
                            return ((Vertical)enum_).crs();
                        }
                    }
                    break block16;
                }
                if (factoryException != null) {
                    throw factoryException;
                }
                throw new NoSuchIdentifierException(Errors.format((short)136, (Object)string), string);
            }
            catch (NumberFormatException numberFormatException2) {
                numberFormatException = numberFormatException2;
            }
        }
        if (factoryException != null) {
            throw factoryException;
        }
        NoSuchAuthorityCodeException noSuchAuthorityCodeException = new NoSuchAuthorityCodeException(Errors.format((short)137, (Object)string, CoordinateReferenceSystem.class, (Object)string2), string, string2, string2);
        noSuchAuthorityCodeException.initCause((Throwable)numberFormatException);
        throw noSuchAuthorityCodeException;
    }

    static {
        DEFAULT = WGS84;
        SystemListener.add((SystemListener)new SystemListener("org.apache.sis.referencing"){

            protected void classpathChanged() {
                for (CommonCRS commonCRS : CommonCRS.values()) {
                    commonCRS.clear();
                }
            }
        });
    }

    public static enum Temporal {
        JULIAN(25, -210866760000000L),
        MODIFIED_JULIAN(36, -3506716800000L),
        TRUNCATED_JULIAN(55, -50716800000L),
        DUBLIN_JULIAN(17, -2209032000000L),
        UNIX(53, 0L),
        JAVA(53, 0L);

        private final short key;
        private final long epoch;
        private volatile transient IdentifiedObject cached;

        private Temporal(short s, long l) {
            this.key = s;
            this.epoch = l;
        }

        synchronized void clear() {
            this.cached = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TemporalCRS crs() {
            TemporalCRS temporalCRS = Temporal.crs(this.cached);
            if (temporalCRS == null) {
                Temporal temporal = this;
                synchronized (temporal) {
                    temporalCRS = Temporal.crs(this.cached);
                    if (temporalCRS == null) {
                        TemporalDatum temporalDatum = this.datum();
                        temporalCRS = new DefaultTemporalCRS(IdentifiedObjects.getProperties((IdentifiedObject)temporalDatum, new String[0]), temporalDatum, this.cs());
                        this.cached = temporalCRS;
                    }
                }
            }
            return temporalCRS;
        }

        private TimeCS cs() {
            Map<String, ?> map;
            Map<String, ?> map2;
            BaseUnit baseUnit = SI.SECOND;
            switch (this) {
                default: {
                    return TRUNCATED_JULIAN.crs().getCoordinateSystem();
                }
                case TRUNCATED_JULIAN: {
                    baseUnit = NonSI.DAY;
                }
                case UNIX: {
                    TimeCS timeCS = JAVA.crs().getCoordinateSystem();
                    map2 = IdentifiedObjects.getProperties((IdentifiedObject)timeCS, new String[0]);
                    map = IdentifiedObjects.getProperties((IdentifiedObject)timeCS.getAxis(0), new String[0]);
                    break;
                }
                case JAVA: {
                    map2 = CommonCRS.properties((short)66);
                    map = CommonCRS.properties((short)67);
                    baseUnit = Units.MILLISECOND;
                }
            }
            return new DefaultTimeCS(map2, new DefaultCoordinateSystemAxis(map, "t", AxisDirection.FUTURE, (Unit<?>)baseUnit));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TemporalDatum datum() {
            TemporalDatum temporalDatum = Temporal.datum(this.cached);
            if (temporalDatum == null) {
                Temporal temporal = this;
                synchronized (temporal) {
                    temporalDatum = Temporal.datum(this.cached);
                    if (temporalDatum == null) {
                        if (this == UNIX) {
                            temporalDatum = JAVA.datum();
                        } else {
                            Map<String, ?> map = this.key == 53 ? CommonCRS.properties(Vocabulary.formatInternational((short)this.key, (Object)(this == JAVA ? "Java" : "Unix/POSIX"))) : CommonCRS.properties(this.key);
                            temporalDatum = new DefaultTemporalDatum(map, new Date(this.epoch));
                        }
                        this.cached = temporalDatum;
                    }
                }
            }
            return temporalDatum;
        }

        private static TemporalCRS crs(IdentifiedObject identifiedObject) {
            return identifiedObject instanceof TemporalCRS ? (TemporalCRS)identifiedObject : null;
        }

        private static TemporalDatum datum(IdentifiedObject identifiedObject) {
            if (identifiedObject instanceof TemporalDatum) {
                return (TemporalDatum)identifiedObject;
            }
            if (identifiedObject instanceof TemporalCRS) {
                return ((TemporalCRS)identifiedObject).getDatum();
            }
            return null;
        }

        static {
            SystemListener.add((SystemListener)new SystemListener("org.apache.sis.referencing"){

                protected void classpathChanged() {
                    for (Temporal temporal : Temporal.values()) {
                        temporal.clear();
                    }
                }
            });
        }
    }

    public static enum Vertical {
        BAROMETRIC(false, 5, 19),
        MEAN_SEA_LEVEL(true, 5714, 5100),
        DEPTH(true, 5715, 5100),
        ELLIPSOIDAL(false, 18, 70),
        OTHER_SURFACE(false, 69, 44);

        final boolean isEPSG;
        final short crs;
        final short datum;
        private volatile transient IdentifiedObject cached;

        private Vertical(boolean bl, short s, short s2) {
            this.isEPSG = bl;
            this.crs = s;
            this.datum = s2;
        }

        synchronized void clear() {
            this.cached = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public VerticalCRS crs() {
            VerticalCRS verticalCRS = Vertical.crs(this.cached);
            if (verticalCRS == null) {
                Vertical vertical = this;
                synchronized (vertical) {
                    verticalCRS = Vertical.crs(this.cached);
                    if (verticalCRS == null) {
                        if (this.isEPSG) {
                            CRSAuthorityFactory cRSAuthorityFactory = CommonCRS.crsFactory();
                            if (cRSAuthorityFactory != null) {
                                try {
                                    verticalCRS = cRSAuthorityFactory.createVerticalCRS(String.valueOf(this.crs));
                                    this.cached = verticalCRS;
                                    return verticalCRS;
                                }
                                catch (FactoryException factoryException) {
                                    CommonCRS.failure((Object)this, "crs", factoryException);
                                }
                            }
                            verticalCRS = StandardDefinitions.createVerticalCRS(this.crs, this.datum());
                        } else {
                            VerticalCS verticalCS = this.cs();
                            verticalCRS = new DefaultVerticalCRS(IdentifiedObjects.getProperties((IdentifiedObject)verticalCS, new String[0]), this.datum(), verticalCS);
                        }
                        this.cached = verticalCRS;
                    }
                }
            }
            return verticalCRS;
        }

        private VerticalCS cs() {
            BaseUnit baseUnit;
            Map<String, ?> map = CommonCRS.properties(this.crs);
            switch (this) {
                default: {
                    baseUnit = SI.METRE;
                    break;
                }
                case BAROMETRIC: {
                    baseUnit = SI.MetricPrefix.HECTO((Unit)SI.PASCAL);
                }
            }
            return new DefaultVerticalCS(map, new DefaultCoordinateSystemAxis(map, "h", AxisDirection.UP, (Unit<?>)baseUnit));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public VerticalDatum datum() {
            VerticalDatum verticalDatum = Vertical.datum(this.cached);
            if (verticalDatum == null) {
                Vertical vertical = this;
                synchronized (vertical) {
                    verticalDatum = Vertical.datum(this.cached);
                    if (verticalDatum == null) {
                        if (this.isEPSG) {
                            DatumAuthorityFactory datumAuthorityFactory = CommonCRS.datumFactory();
                            if (datumAuthorityFactory != null) {
                                try {
                                    verticalDatum = datumAuthorityFactory.createVerticalDatum(String.valueOf(this.datum));
                                    this.cached = verticalDatum;
                                    return verticalDatum;
                                }
                                catch (FactoryException factoryException) {
                                    CommonCRS.failure((Object)this, "datum", factoryException);
                                }
                            }
                            verticalDatum = StandardDefinitions.createVerticalDatum(this.datum);
                        } else {
                            verticalDatum = new DefaultVerticalDatum(CommonCRS.properties(this.datum), VerticalDatumType.valueOf((String)this.name()));
                        }
                        this.cached = verticalDatum;
                    }
                }
            }
            return verticalDatum;
        }

        private static VerticalCRS crs(IdentifiedObject identifiedObject) {
            return identifiedObject instanceof VerticalCRS ? (VerticalCRS)identifiedObject : null;
        }

        private static VerticalDatum datum(IdentifiedObject identifiedObject) {
            if (identifiedObject instanceof VerticalDatum) {
                return (VerticalDatum)identifiedObject;
            }
            if (identifiedObject instanceof VerticalCRS) {
                return ((VerticalCRS)identifiedObject).getDatum();
            }
            return null;
        }

        static {
            SystemListener.add((SystemListener)new SystemListener("org.apache.sis.referencing"){

                protected void classpathChanged() {
                    for (Vertical vertical : Vertical.values()) {
                        vertical.clear();
                    }
                }
            });
        }
    }
}

