/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import java.util.Map;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.crs.AbstractDerivedCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;

@XmlTransient
public class DefaultDerivedCRS
extends AbstractDerivedCRS<Conversion>
implements DerivedCRS {
    private static final long serialVersionUID = -8149602276542469876L;

    protected DefaultDerivedCRS(Map<String, ?> map, SingleCRS singleCRS, Conversion conversion, CoordinateSystem coordinateSystem) throws MismatchedDimensionException {
        super(map, singleCRS, conversion, coordinateSystem);
    }

    protected DefaultDerivedCRS(Map<String, ?> map, SingleCRS singleCRS, CoordinateReferenceSystem coordinateReferenceSystem, OperationMethod operationMethod, MathTransform mathTransform, CoordinateSystem coordinateSystem) {
        super(map, singleCRS, coordinateReferenceSystem, operationMethod, mathTransform, coordinateSystem);
    }

    protected DefaultDerivedCRS(DerivedCRS derivedCRS) {
        super((GeneralDerivedCRS)derivedCRS);
    }

    public static DefaultDerivedCRS create(Map<String, ?> map, SingleCRS singleCRS, Conversion conversion, CoordinateSystem coordinateSystem) throws MismatchedDimensionException {
        String string;
        if (singleCRS != null && coordinateSystem != null && (string = DefaultDerivedCRS.getType(singleCRS, coordinateSystem)) != null) {
            if ("GeodeticCRS".equals(string)) {
                return new Geodetic(map, (GeodeticCRS)singleCRS, conversion, (EllipsoidalCS)coordinateSystem);
            }
            if ("VerticalCRS".equals(string)) {
                return new Vertical(map, (VerticalCRS)singleCRS, conversion, (VerticalCS)coordinateSystem);
            }
            if ("TimeCRS".equals(string)) {
                return new Temporal(map, (TemporalCRS)singleCRS, conversion, (TimeCS)coordinateSystem);
            }
            if ("EngineeringCRS".equals(string) && singleCRS instanceof EngineeringCRS) {
                return new Engineering(map, (EngineeringCRS)singleCRS, conversion, coordinateSystem);
            }
        }
        return new DefaultDerivedCRS(map, singleCRS, conversion, coordinateSystem);
    }

    public static DefaultDerivedCRS create(Map<String, ?> map, SingleCRS singleCRS, CoordinateReferenceSystem coordinateReferenceSystem, OperationMethod operationMethod, MathTransform mathTransform, CoordinateSystem coordinateSystem) {
        String string;
        if (singleCRS != null && coordinateSystem != null && (string = DefaultDerivedCRS.getType(singleCRS, coordinateSystem)) != null) {
            if ("GeodeticCRS".equals(string)) {
                return new Geodetic(map, (GeodeticCRS)singleCRS, coordinateReferenceSystem, operationMethod, mathTransform, (EllipsoidalCS)coordinateSystem);
            }
            if ("VerticalCRS".equals(string)) {
                return new Vertical(map, (VerticalCRS)singleCRS, coordinateReferenceSystem, operationMethod, mathTransform, (VerticalCS)coordinateSystem);
            }
            if ("TimeCRS".equals(string)) {
                return new Temporal(map, (TemporalCRS)singleCRS, coordinateReferenceSystem, operationMethod, mathTransform, (TimeCS)coordinateSystem);
            }
            if ("EngineeringCRS".equals(string) && singleCRS instanceof EngineeringCRS) {
                return new Engineering(map, (EngineeringCRS)singleCRS, coordinateReferenceSystem, operationMethod, mathTransform, coordinateSystem);
            }
        }
        return new DefaultDerivedCRS(map, singleCRS, coordinateReferenceSystem, operationMethod, mathTransform, coordinateSystem);
    }

    public static DefaultDerivedCRS castOrCopy(DerivedCRS derivedCRS) {
        if (derivedCRS == null || derivedCRS instanceof DefaultDerivedCRS) {
            return (DefaultDerivedCRS)derivedCRS;
        }
        String string = DefaultDerivedCRS.getType((SingleCRS)derivedCRS.getBaseCRS(), derivedCRS.getCoordinateSystem());
        if (string != null) {
            if ("GeodeticCRS".equals(string)) {
                return new Geodetic(derivedCRS);
            }
            if ("VerticalCRS".equals(string)) {
                return new Vertical(derivedCRS);
            }
            if ("TimeCRS".equals(string)) {
                return new Temporal(derivedCRS);
            }
            if ("EngineeringCRS".equals(string)) {
                return new Engineering(derivedCRS);
            }
        }
        return new DefaultDerivedCRS(derivedCRS);
    }

    @Override
    final Class<Conversion> getConversionType() {
        return Conversion.class;
    }

    @Override
    public Class<? extends DerivedCRS> getInterface() {
        return DerivedCRS.class;
    }

    @Override
    public Datum getDatum() {
        return this.getBaseCRS().getDatum();
    }

    public SingleCRS getBaseCRS() {
        return (SingleCRS)super.getConversionFromBase().getSourceCRS();
    }

    @Override
    public Conversion getConversionFromBase() {
        return super.getConversionFromBase();
    }

    @Override
    public DefaultDerivedCRS forConvention(AxesConvention axesConvention) {
        return (DefaultDerivedCRS)super.forConvention(axesConvention);
    }

    @Override
    AbstractCRS createSameType(Map<String, ?> map, CoordinateSystem coordinateSystem) {
        Object c = super.getConversionFromBase();
        return new DefaultDerivedCRS(map, (SingleCRS)c.getSourceCRS(), (Conversion)c, coordinateSystem);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        return object == this || super.equals(object, comparisonMode);
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode();
    }

    @Override
    protected String formatTo(Formatter formatter) {
        MathTransform mathTransform;
        boolean bl;
        final Conversion conversion = this.getConversionFromBase();
        if (conversion == null) {
            return super.formatTo(formatter);
        }
        WKTUtilities.appendName(this, formatter, null);
        Convention convention = formatter.getConvention();
        boolean bl2 = bl = convention.majorVersion() == 1;
        if (bl) {
            mathTransform = conversion.getMathTransform();
            try {
                mathTransform = mathTransform.inverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                formatter.setInvalidWKT((IdentifiedObject)this, (Exception)((Object)noninvertibleTransformException));
                mathTransform = null;
            }
            formatter.newLine();
            formatter.append(mathTransform);
        }
        formatter.newLine();
        formatter.append(WKTUtilities.toFormattable((CoordinateReferenceSystem)this.getBaseCRS()));
        if (bl) {
            return "Fitted_CS";
        }
        formatter.newLine();
        formatter.append(new FormattableObject(){

            protected String formatTo(Formatter formatter) {
                WKTUtilities.appendName((IdentifiedObject)conversion, formatter, null);
                formatter.newLine();
                formatter.append((FormattableObject)DefaultOperationMethod.castOrCopy(conversion.getMethod()));
                formatter.newLine();
                for (GeneralParameterValue generalParameterValue : conversion.getParameterValues().values()) {
                    WKTUtilities.append(generalParameterValue, formatter);
                }
                return "DerivingConversion";
            }
        });
        if (convention == Convention.INTERNAL || !DefaultDerivedCRS.isBaseCRS(formatter)) {
            mathTransform = this.getCoordinateSystem();
            this.formatCS(formatter, (CoordinateSystem)mathTransform, ReferencingUtilities.getUnit((CoordinateSystem)mathTransform), bl);
        }
        return this.keyword(formatter);
    }

    String keyword(Formatter formatter) {
        String string;
        String string2 = DefaultDerivedCRS.getType(this.getBaseCRS(), this.getCoordinateSystem());
        if (string2.equals("GeodeticCRS")) {
            string = "GeodCRS";
        } else if (string2.equals("VerticalCRS")) {
            string = "VertCRS";
        } else if (string2.equals("EngineeringCRS")) {
            string = "EngCRS";
        } else {
            return string2;
        }
        return formatter.shortOrLong(string, string2);
    }

    static String getType(SingleCRS singleCRS, CoordinateSystem coordinateSystem) {
        Class<Object> clazz = singleCRS instanceof AbstractIdentifiedObject ? ((AbstractIdentifiedObject)singleCRS).getInterface() : singleCRS.getClass();
        if (GeodeticCRS.class.isAssignableFrom(clazz)) {
            if (Classes.implementSameInterfaces(coordinateSystem.getClass(), singleCRS.getCoordinateSystem().getClass(), CoordinateSystem.class)) {
                return "GeodeticCRS";
            }
            return "EngineeringCRS";
        }
        if (VerticalCRS.class.isAssignableFrom(clazz) && coordinateSystem instanceof VerticalCS) {
            return "VerticalCRS";
        }
        if (TemporalCRS.class.isAssignableFrom(clazz) && coordinateSystem instanceof TimeCS) {
            return "TimeCRS";
        }
        if (ProjectedCRS.class.isAssignableFrom(clazz) || EngineeringCRS.class.isAssignableFrom(clazz)) {
            return "EngineeringCRS";
        }
        return null;
    }

    private DefaultDerivedCRS() {
    }

    @XmlTransient
    private static final class Engineering
    extends DefaultDerivedCRS
    implements EngineeringCRS {
        private static final long serialVersionUID = 42334975023270039L;

        Engineering(DerivedCRS derivedCRS) {
            super(derivedCRS);
        }

        Engineering(Map<String, ?> map, EngineeringCRS engineeringCRS, Conversion conversion, CoordinateSystem coordinateSystem) {
            super(map, (SingleCRS)engineeringCRS, conversion, coordinateSystem);
        }

        Engineering(Map<String, ?> map, EngineeringCRS engineeringCRS, CoordinateReferenceSystem coordinateReferenceSystem, OperationMethod operationMethod, MathTransform mathTransform, CoordinateSystem coordinateSystem) {
            super(map, (SingleCRS)engineeringCRS, coordinateReferenceSystem, operationMethod, mathTransform, coordinateSystem);
        }

        public EngineeringDatum getDatum() {
            return (EngineeringDatum)super.getDatum();
        }

        @Override
        AbstractCRS createSameType(Map<String, ?> map, CoordinateSystem coordinateSystem) {
            Conversion conversion = this.getConversionFromBase();
            return new Engineering(map, (EngineeringCRS)conversion.getSourceCRS(), conversion, coordinateSystem);
        }

        @Override
        String keyword(Formatter formatter) {
            return formatter.shortOrLong("EngCRS", "EngineeringCRS");
        }
    }

    @XmlTransient
    private static final class Temporal
    extends DefaultDerivedCRS
    implements TemporalCRS {
        private static final long serialVersionUID = -4721311735720248819L;

        Temporal(DerivedCRS derivedCRS) {
            super(derivedCRS);
        }

        Temporal(Map<String, ?> map, TemporalCRS temporalCRS, Conversion conversion, TimeCS timeCS) {
            super(map, (SingleCRS)temporalCRS, conversion, (CoordinateSystem)timeCS);
        }

        Temporal(Map<String, ?> map, TemporalCRS temporalCRS, CoordinateReferenceSystem coordinateReferenceSystem, OperationMethod operationMethod, MathTransform mathTransform, TimeCS timeCS) {
            super(map, (SingleCRS)temporalCRS, coordinateReferenceSystem, operationMethod, mathTransform, (CoordinateSystem)timeCS);
        }

        public TemporalDatum getDatum() {
            return (TemporalDatum)super.getDatum();
        }

        public TimeCS getCoordinateSystem() {
            return (TimeCS)super.getCoordinateSystem();
        }

        @Override
        AbstractCRS createSameType(Map<String, ?> map, CoordinateSystem coordinateSystem) {
            Conversion conversion = this.getConversionFromBase();
            return new Temporal(map, (TemporalCRS)conversion.getSourceCRS(), conversion, (TimeCS)coordinateSystem);
        }

        @Override
        String keyword(Formatter formatter) {
            return "TimeCRS";
        }
    }

    @XmlTransient
    private static final class Vertical
    extends DefaultDerivedCRS
    implements VerticalCRS {
        private static final long serialVersionUID = -5599709829566076972L;

        Vertical(DerivedCRS derivedCRS) {
            super(derivedCRS);
        }

        Vertical(Map<String, ?> map, VerticalCRS verticalCRS, Conversion conversion, VerticalCS verticalCS) {
            super(map, (SingleCRS)verticalCRS, conversion, (CoordinateSystem)verticalCS);
        }

        Vertical(Map<String, ?> map, VerticalCRS verticalCRS, CoordinateReferenceSystem coordinateReferenceSystem, OperationMethod operationMethod, MathTransform mathTransform, VerticalCS verticalCS) {
            super(map, (SingleCRS)verticalCRS, coordinateReferenceSystem, operationMethod, mathTransform, (CoordinateSystem)verticalCS);
        }

        public VerticalDatum getDatum() {
            return (VerticalDatum)super.getDatum();
        }

        public VerticalCS getCoordinateSystem() {
            return (VerticalCS)super.getCoordinateSystem();
        }

        @Override
        AbstractCRS createSameType(Map<String, ?> map, CoordinateSystem coordinateSystem) {
            Conversion conversion = this.getConversionFromBase();
            return new Vertical(map, (VerticalCRS)conversion.getSourceCRS(), conversion, (VerticalCS)coordinateSystem);
        }

        @Override
        String keyword(Formatter formatter) {
            return formatter.shortOrLong("VertCRS", "VerticalCRS");
        }
    }

    @XmlTransient
    private static final class Geodetic
    extends DefaultDerivedCRS
    implements GeodeticCRS {
        private static final long serialVersionUID = -1263243517380302846L;

        Geodetic(DerivedCRS derivedCRS) {
            super(derivedCRS);
        }

        Geodetic(Map<String, ?> map, GeodeticCRS geodeticCRS, Conversion conversion, EllipsoidalCS ellipsoidalCS) {
            super(map, (SingleCRS)geodeticCRS, conversion, (CoordinateSystem)ellipsoidalCS);
        }

        Geodetic(Map<String, ?> map, GeodeticCRS geodeticCRS, CoordinateReferenceSystem coordinateReferenceSystem, OperationMethod operationMethod, MathTransform mathTransform, EllipsoidalCS ellipsoidalCS) {
            super(map, (SingleCRS)geodeticCRS, coordinateReferenceSystem, operationMethod, mathTransform, (CoordinateSystem)ellipsoidalCS);
        }

        public GeodeticDatum getDatum() {
            return (GeodeticDatum)super.getDatum();
        }

        public EllipsoidalCS getCoordinateSystem() {
            return (EllipsoidalCS)super.getCoordinateSystem();
        }

        @Override
        AbstractCRS createSameType(Map<String, ?> map, CoordinateSystem coordinateSystem) {
            Conversion conversion = this.getConversionFromBase();
            return new Geodetic(map, (GeodeticCRS)conversion.getSourceCRS(), conversion, (EllipsoidalCS)coordinateSystem);
        }

        @Override
        String keyword(Formatter formatter) {
            return formatter.shortOrLong("GeodCRS", "GeodeticCRS");
        }
    }
}

