/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.internal.referencing.PositionalAccuracyConstant;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.internal.system.Semaphores;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.operation.AbstractSingleOperation;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.SubTypes;
import org.apache.sis.referencing.operation.transform.PassThroughTransform;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.UnsupportedImplementationException;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.InternationalString;

@XmlType(name="AbstractCoordinateOperationType", propOrder={"domainOfValidity", "scope", "operationVersion", "coordinateOperationAccuracy", "source", "target"})
@XmlRootElement(name="AbstractCoordinateOperation")
@XmlSeeAlso(value={AbstractSingleOperation.class})
public class AbstractCoordinateOperation
extends AbstractIdentifiedObject
implements CoordinateOperation {
    private static final long serialVersionUID = 1237358357729193885L;
    private CoordinateReferenceSystem sourceCRS;
    private CoordinateReferenceSystem targetCRS;
    private final CoordinateReferenceSystem interpolationCRS;
    @XmlElement
    private final String operationVersion;
    @XmlElement
    private final Collection<PositionalAccuracy> coordinateOperationAccuracy;
    @XmlElement
    private final Extent domainOfValidity;
    @XmlElement
    private final InternationalString scope;
    private MathTransform transform;

    AbstractCoordinateOperation(CoordinateOperation coordinateOperation, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, MathTransform mathTransform) {
        super((IdentifiedObject)coordinateOperation);
        this.sourceCRS = coordinateReferenceSystem;
        this.targetCRS = coordinateReferenceSystem2;
        this.interpolationCRS = AbstractCoordinateOperation.getInterpolationCRS(coordinateOperation);
        this.operationVersion = coordinateOperation.getOperationVersion();
        this.coordinateOperationAccuracy = coordinateOperation.getCoordinateOperationAccuracy();
        this.domainOfValidity = coordinateOperation.getDomainOfValidity();
        this.scope = coordinateOperation.getScope();
        this.transform = mathTransform;
        this.checkDimensions(null);
    }

    public AbstractCoordinateOperation(Map<String, ?> map, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, CoordinateReferenceSystem coordinateReferenceSystem3, MathTransform mathTransform) {
        super(map);
        this.sourceCRS = coordinateReferenceSystem;
        this.targetCRS = coordinateReferenceSystem2;
        this.interpolationCRS = coordinateReferenceSystem3;
        this.transform = mathTransform;
        this.domainOfValidity = (Extent)Containers.property(map, (Object)"domainOfValidity", Extent.class);
        this.scope = Types.toInternationalString(map, (String)"scope");
        this.operationVersion = (String)Containers.property(map, (Object)"operationVersion", String.class);
        Object obj = map.get("coordinateOperationAccuracy");
        this.coordinateOperationAccuracy = obj instanceof PositionalAccuracy[] ? CollectionsExt.nonEmptySet((Object[])((PositionalAccuracy[])obj)) : (obj != null ? Collections.singleton((PositionalAccuracy)obj) : null);
        this.checkDimensions(map);
    }

    private void checkDimensions(Map<String, ?> map) {
        MathTransform mathTransform = this.transform;
        if (mathTransform != null) {
            int n = ReferencingUtilities.getDimension(this.interpolationCRS);
            int n2 = 0;
            block4: while (true) {
                int n3;
                CoordinateReferenceSystem coordinateReferenceSystem;
                switch (n2) {
                    case 0: {
                        coordinateReferenceSystem = this.sourceCRS;
                        n3 = mathTransform.getSourceDimensions();
                        break;
                    }
                    case 1: {
                        coordinateReferenceSystem = this.targetCRS;
                        n3 = mathTransform.getTargetDimensions();
                        break;
                    }
                    default: {
                        break block4;
                    }
                }
                int n4 = ReferencingUtilities.getDimension(coordinateReferenceSystem);
                if (n != 0) {
                    if (n3 == n4 || n3 < n) {
                        throw new IllegalArgumentException(Errors.getResources(map).getString((short)184));
                    }
                    n4 += n;
                }
                if (coordinateReferenceSystem != null && n3 != n4) {
                    throw new IllegalArgumentException(Errors.getResources(map).getString((short)178, (Object)n2, (Object)n4, (Object)n3));
                }
                ++n2;
            }
        }
    }

    protected AbstractCoordinateOperation(CoordinateOperation coordinateOperation) {
        super((IdentifiedObject)coordinateOperation);
        this.sourceCRS = coordinateOperation.getSourceCRS();
        this.targetCRS = coordinateOperation.getTargetCRS();
        this.interpolationCRS = AbstractCoordinateOperation.getInterpolationCRS(coordinateOperation);
        this.operationVersion = coordinateOperation.getOperationVersion();
        this.coordinateOperationAccuracy = coordinateOperation.getCoordinateOperationAccuracy();
        this.domainOfValidity = coordinateOperation.getDomainOfValidity();
        this.scope = coordinateOperation.getScope();
        this.transform = coordinateOperation.getMathTransform();
    }

    public static AbstractCoordinateOperation castOrCopy(CoordinateOperation coordinateOperation) {
        return SubTypes.castOrCopy(coordinateOperation);
    }

    public Class<? extends CoordinateOperation> getInterface() {
        return CoordinateOperation.class;
    }

    public boolean isDefiningConversion() {
        return this.sourceCRS == null && this.targetCRS == null || this.targetCRS instanceof GeneralDerivedCRS && ((GeneralDerivedCRS)this.targetCRS).getBaseCRS() == this.sourceCRS && ((GeneralDerivedCRS)this.targetCRS).getConversionFromBase() == this;
    }

    public CoordinateReferenceSystem getSourceCRS() {
        return this.sourceCRS;
    }

    public CoordinateReferenceSystem getTargetCRS() {
        return this.targetCRS;
    }

    public CoordinateReferenceSystem getInterpolationCRS() {
        return this.interpolationCRS;
    }

    static CoordinateReferenceSystem getInterpolationCRS(CoordinateOperation coordinateOperation) {
        return coordinateOperation instanceof AbstractCoordinateOperation ? ((AbstractCoordinateOperation)coordinateOperation).getInterpolationCRS() : null;
    }

    public String getOperationVersion() {
        return this.operationVersion;
    }

    public Collection<PositionalAccuracy> getCoordinateOperationAccuracy() {
        return this.coordinateOperationAccuracy != null ? this.coordinateOperationAccuracy : Collections.emptySet();
    }

    public double getLinearAccuracy() {
        return PositionalAccuracyConstant.getLinearAccuracy(this);
    }

    public Extent getDomainOfValidity() {
        return this.domainOfValidity;
    }

    public InternationalString getScope() {
        return this.scope;
    }

    public MathTransform getMathTransform() {
        return this.transform;
    }

    OperationMethod getMethod() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ParameterDescriptorGroup getParameterDescriptors() throws UnsupportedOperationException {
        OperationMethod operationMethod;
        MathTransform mathTransform = this.transform;
        while (mathTransform != null) {
            if (mathTransform instanceof Parameterized) {
                if (Semaphores.queryAndSet((byte)2)) {
                    throw new AssertionError();
                }
                try {
                    operationMethod = ((Parameterized)mathTransform).getParameterDescriptors();
                }
                finally {
                    Semaphores.clear((byte)2);
                }
                if (operationMethod != null) {
                    return operationMethod;
                }
            }
            if (!(mathTransform instanceof PassThroughTransform)) break;
            mathTransform = ((PassThroughTransform)mathTransform).getSubTransform();
        }
        return (operationMethod = this.getMethod()) != null ? operationMethod.getParameters() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ParameterValueGroup getParameterValues() {
        MathTransform mathTransform = this.transform;
        while (mathTransform != null) {
            if (mathTransform instanceof Parameterized) {
                ParameterValueGroup parameterValueGroup;
                if (Semaphores.queryAndSet((byte)2)) {
                    throw new AssertionError();
                }
                try {
                    parameterValueGroup = ((Parameterized)mathTransform).getParameterValues();
                }
                finally {
                    Semaphores.clear((byte)2);
                }
                if (parameterValueGroup != null) {
                    return parameterValueGroup;
                }
            }
            if (!(mathTransform instanceof PassThroughTransform)) break;
            mathTransform = ((PassThroughTransform)mathTransform).getSubTransform();
        }
        throw new UnsupportedImplementationException(Classes.getClass((Object)mathTransform));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (super.equals(object, comparisonMode)) {
            if (comparisonMode == ComparisonMode.STRICT) {
                AbstractCoordinateOperation abstractCoordinateOperation = (AbstractCoordinateOperation)object;
                if (Objects.equals((Object)this.sourceCRS, (Object)abstractCoordinateOperation.sourceCRS) && Objects.equals((Object)this.interpolationCRS, (Object)abstractCoordinateOperation.interpolationCRS) && Objects.equals((Object)this.transform, (Object)abstractCoordinateOperation.transform) && Objects.equals((Object)this.scope, (Object)abstractCoordinateOperation.scope) && Objects.equals((Object)this.domainOfValidity, (Object)abstractCoordinateOperation.domainOfValidity) && Objects.equals(this.coordinateOperationAccuracy, abstractCoordinateOperation.coordinateOperationAccuracy)) {
                    if (Semaphores.queryAndSet((byte)1)) {
                        return true;
                    }
                    try {
                        boolean bl = Objects.equals((Object)this.targetCRS, (Object)abstractCoordinateOperation.targetCRS);
                        return bl;
                    }
                    finally {
                        Semaphores.clear((byte)1);
                    }
                }
            } else {
                CoordinateOperation coordinateOperation = (CoordinateOperation)object;
                if (!(comparisonMode != ComparisonMode.BY_CONTRACT || Utilities.deepEquals((Object)this.getScope(), (Object)coordinateOperation.getScope(), (ComparisonMode)comparisonMode) && Utilities.deepEquals((Object)this.getDomainOfValidity(), (Object)coordinateOperation.getDomainOfValidity(), (ComparisonMode)comparisonMode) && Utilities.deepEquals(this.getCoordinateOperationAccuracy(), (Object)coordinateOperation.getCoordinateOperationAccuracy(), (ComparisonMode)comparisonMode))) {
                    return false;
                }
                if (Utilities.deepEquals((Object)this.getMathTransform(), (Object)coordinateOperation.getMathTransform(), (ComparisonMode)comparisonMode) && Utilities.deepEquals((Object)this.getSourceCRS(), (Object)coordinateOperation.getSourceCRS(), (ComparisonMode)comparisonMode) && Utilities.deepEquals((Object)this.getInterpolationCRS(), (Object)AbstractCoordinateOperation.getInterpolationCRS(coordinateOperation), (ComparisonMode)comparisonMode)) {
                    if (Semaphores.queryAndSet((byte)1)) {
                        return true;
                    }
                    try {
                        boolean bl = Utilities.deepEquals((Object)this.getTargetCRS(), (Object)coordinateOperation.getTargetCRS(), (ComparisonMode)comparisonMode);
                        return bl;
                    }
                    finally {
                        Semaphores.clear((byte)1);
                    }
                }
            }
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Objects.hash((Object[])new Object[]{this.sourceCRS, this.targetCRS, this.interpolationCRS, this.transform});
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        formatter.newLine();
        AbstractCoordinateOperation.append(formatter, this.getSourceCRS(), "SourceCRS");
        AbstractCoordinateOperation.append(formatter, this.getTargetCRS(), "TargetCRS");
        formatter.append((FormattableObject)DefaultOperationMethod.castOrCopy(this.getMethod()));
        ParameterValueGroup parameterValueGroup = this.getParameterValues();
        if (parameterValueGroup != null) {
            formatter.newLine();
            for (GeneralParameterValue generalParameterValue : parameterValueGroup.values()) {
                WKTUtilities.append(generalParameterValue, formatter);
            }
        }
        AbstractCoordinateOperation.append(formatter, this.getInterpolationCRS(), "InterpolationCRS");
        final double d = this.getLinearAccuracy();
        if (d > 0.0) {
            formatter.append(new FormattableObject(){

                protected String formatTo(Formatter formatter) {
                    formatter.append(d);
                    return "OperationAccuracy";
                }
            });
        }
        if (formatter.getConvention().majorVersion() == 1) {
            formatter.setInvalidWKT((IdentifiedObject)this, null);
        }
        return "CoordinateOperation";
    }

    private static void append(Formatter formatter, final CoordinateReferenceSystem coordinateReferenceSystem, final String string) {
        if (coordinateReferenceSystem != null) {
            formatter.append(new FormattableObject(){

                protected String formatTo(Formatter formatter) {
                    formatter.indent(-1);
                    formatter.append(WKTUtilities.toFormattable(coordinateReferenceSystem));
                    formatter.indent(1);
                    return string;
                }
            });
        }
    }

    AbstractCoordinateOperation() {
        super((IdentifiedObject)NilReferencingObject.INSTANCE);
        this.interpolationCRS = null;
        this.operationVersion = null;
        this.coordinateOperationAccuracy = null;
        this.domainOfValidity = null;
        this.scope = null;
    }

    @XmlElement(name="sourceCRS")
    private CoordinateReferenceSystem getSource() {
        return this.isDefiningConversion() ? null : this.getSourceCRS();
    }

    private void setSource(CoordinateReferenceSystem coordinateReferenceSystem) {
        if (this.sourceCRS == null) {
            this.sourceCRS = coordinateReferenceSystem;
        } else {
            ReferencingUtilities.propertyAlreadySet(AbstractCoordinateOperation.class, "setSource", "sourceCRS");
        }
    }

    @XmlElement(name="targetCRS")
    private CoordinateReferenceSystem getTarget() {
        return this.isDefiningConversion() ? null : this.getTargetCRS();
    }

    private void setTarget(CoordinateReferenceSystem coordinateReferenceSystem) {
        if (this.targetCRS == null) {
            this.targetCRS = coordinateReferenceSystem;
        } else {
            ReferencingUtilities.propertyAlreadySet(AbstractCoordinateOperation.class, "setTarget", "targetCRS");
        }
    }

    private void afterUnmarshal(Unmarshaller unmarshaller, Object object) {
        if (this.transform == null && this.sourceCRS != null && this.targetCRS != null) {
            this.transform = this.createMathTransform();
        }
    }

    MathTransform createMathTransform() {
        return null;
    }
}

