/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.Map;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.referencing.operation.AbstractCoordinateOperation;
import org.apache.sis.referencing.operation.transform.PassThroughTransform;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.UnsupportedImplementationException;
import org.apache.sis.util.Utilities;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.PassThroughOperation;
import org.opengis.referencing.operation.SingleOperation;

public class DefaultPassThroughOperation
extends AbstractCoordinateOperation
implements PassThroughOperation {
    private static final long serialVersionUID = 4308173919747248695L;
    private final SingleOperation operation;

    public DefaultPassThroughOperation(Map<String, ?> map, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, SingleOperation singleOperation, int n, int n2) {
        super(map, coordinateReferenceSystem, coordinateReferenceSystem2, null, PassThroughTransform.create(n, singleOperation.getMathTransform(), n2));
        ArgumentChecks.ensureNonNull((String)"operation", (Object)singleOperation);
        this.operation = singleOperation;
    }

    protected DefaultPassThroughOperation(PassThroughOperation passThroughOperation) {
        super((CoordinateOperation)passThroughOperation);
        this.operation = passThroughOperation.getOperation();
    }

    public static DefaultPassThroughOperation castOrCopy(PassThroughOperation passThroughOperation) {
        return passThroughOperation == null || passThroughOperation instanceof DefaultPassThroughOperation ? (DefaultPassThroughOperation)passThroughOperation : new DefaultPassThroughOperation(passThroughOperation);
    }

    public Class<? extends PassThroughOperation> getInterface() {
        return PassThroughOperation.class;
    }

    @Override
    @Deprecated
    public OperationMethod getMethod() {
        return null;
    }

    @Override
    @Deprecated
    public ParameterValueGroup getParameterValues() {
        return null;
    }

    public SingleOperation getOperation() {
        return this.operation;
    }

    public int[] getModifiedCoordinates() {
        MathTransform mathTransform = super.getMathTransform();
        if (mathTransform instanceof PassThroughTransform) {
            return ((PassThroughTransform)mathTransform).getModifiedCoordinates();
        }
        throw new UnsupportedImplementationException(mathTransform.getClass());
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            if (comparisonMode == ComparisonMode.STRICT) {
                return Objects.equals((Object)this.operation, (Object)((DefaultPassThroughOperation)object).operation);
            }
            return Utilities.deepEquals((Object)this.getOperation(), (Object)((PassThroughOperation)object).getOperation(), (ComparisonMode)comparisonMode);
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)(31 * this.operation.hashCode());
    }
}

