/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

public class TransverseMercator
extends NormalizedProjection {
    private static final long serialVersionUID = -4717976245811852528L;
    private static final boolean ORIGINAL_FORMULA = true;
    private final double h1;
    private final double h2;
    private final double h3;
    private final double h4;
    private final double ih1;
    private final double ih2;
    private final double ih3;
    private final double ih4;

    public TransverseMercator(OperationMethod operationMethod, Parameters parameters) {
        this(TransverseMercator.initializer(operationMethod, parameters));
    }

    private static Initializer initializer(OperationMethod operationMethod, Parameters parameters) {
        boolean bl = TransverseMercator.identMatch(operationMethod, "(?i).*\\bSouth\\b.*", "9808");
        EnumMap<NormalizedProjection.ParameterRole, Object> enumMap = new EnumMap<NormalizedProjection.ParameterRole, Object>(NormalizedProjection.ParameterRole.class);
        NormalizedProjection.ParameterRole parameterRole = NormalizedProjection.ParameterRole.FALSE_EASTING;
        NormalizedProjection.ParameterRole parameterRole2 = NormalizedProjection.ParameterRole.FALSE_NORTHING;
        if (bl) {
            parameterRole = NormalizedProjection.ParameterRole.FALSE_WESTING;
            parameterRole2 = NormalizedProjection.ParameterRole.FALSE_SOUTHING;
        }
        enumMap.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, org.apache.sis.internal.referencing.provider.TransverseMercator.LONGITUDE_OF_ORIGIN);
        enumMap.put(NormalizedProjection.ParameterRole.SCALE_FACTOR, org.apache.sis.internal.referencing.provider.TransverseMercator.SCALE_FACTOR);
        enumMap.put(parameterRole, org.apache.sis.internal.referencing.provider.TransverseMercator.FALSE_EASTING);
        enumMap.put(parameterRole2, org.apache.sis.internal.referencing.provider.TransverseMercator.FALSE_NORTHING);
        return new Initializer(operationMethod, parameters, enumMap, bl ? (byte)1 : 0);
    }

    private TransverseMercator(Initializer initializer) {
        super(initializer);
        double d = Math.toRadians(initializer.getAndStore(org.apache.sis.internal.referencing.provider.TransverseMercator.LATITUDE_OF_ORIGIN));
        DoubleDouble doubleDouble = initializer.axisLengthRatio();
        doubleDouble.ratio_1m_1p();
        double d2 = doubleDouble.doubleValue();
        DoubleDouble doubleDouble2 = new DoubleDouble(doubleDouble);
        doubleDouble2.square();
        doubleDouble2.series(new double[]{1.0, 0.25, 0.015625});
        doubleDouble.add(1.0, 0.0);
        doubleDouble2.divide(doubleDouble);
        double d3 = d2 * d2;
        double d4 = d3 * d2;
        double d5 = d3 * d3;
        this.h1 = 0.22777777777777777 * d5 + 0.3125 * d4 + -0.6666666666666666 * d3 + d2 / 2.0;
        this.h2 = 0.38680555555555557 * d5 + -0.6 * d4 + 0.2708333333333333 * d3;
        this.h3 = -0.7357142857142858 * d5 + 0.25416666666666665 * d4;
        this.h4 = 0.30729786706349205 * d5;
        this.ih1 = -0.002777777777777778 * d5 + 0.3854166666666667 * d4 + -0.6666666666666666 * d3 + d2 / 2.0;
        this.ih2 = -0.3034722222222222 * d5 + 0.06666666666666667 * d4 + 0.020833333333333332 * d3;
        this.ih3 = -0.04404761904761905 * d5 + 0.035416666666666666 * d4;
        this.ih4 = 0.02726314484126984 * d5;
        double d6 = MathFunctions.asinh((double)Math.tan(d)) - this.excentricity * MathFunctions.atanh((double)(this.excentricity * Math.sin(d)));
        double d7 = Math.atan(Math.sinh(d6));
        DoubleDouble doubleDouble3 = new DoubleDouble();
        doubleDouble3.value = this.h4 * Math.sin(8.0 * d7) + this.h3 * Math.sin(6.0 * d7) + this.h2 * Math.sin(4.0 * d7) + this.h1 * Math.sin(2.0 * d7) + d7;
        doubleDouble3.multiply(doubleDouble2);
        doubleDouble3.negate();
        MatrixSIS matrixSIS = this.context.getMatrix(false);
        matrixSIS.convertBefore(0, (Number)doubleDouble2, null);
        matrixSIS.convertBefore(1, (Number)doubleDouble2, (Number)doubleDouble3);
    }

    TransverseMercator(TransverseMercator transverseMercator) {
        super(transverseMercator);
        this.h1 = transverseMercator.h1;
        this.h2 = transverseMercator.h2;
        this.h3 = transverseMercator.h3;
        this.h4 = transverseMercator.h4;
        this.ih1 = transverseMercator.ih1;
        this.ih2 = transverseMercator.ih2;
        this.ih3 = transverseMercator.ih3;
        this.ih4 = transverseMercator.ih4;
    }

    @Override
    public MathTransform createMapProjection(MathTransformFactory mathTransformFactory) throws FactoryException {
        TransverseMercator transverseMercator = this;
        if (this.excentricity == 0.0) {
            transverseMercator = new Spherical(this);
        }
        return this.context.completeTransform(mathTransformFactory, transverseMercator);
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        double d3 = this.excentricity * Math.sin(d2);
        double d4 = MathFunctions.asinh((double)Math.tan(d2)) - MathFunctions.atanh((double)d3) * this.excentricity;
        double d5 = Math.sin(d);
        double d6 = Math.cosh(d4);
        double d7 = MathFunctions.atanh((double)(d5 / d6));
        double d8 = Math.cosh(d7);
        double d9 = Math.asin(Math.tanh(d4) * d8);
        double d10 = Math.sin(2.0 * d9);
        double d11 = Math.cos(2.0 * d9);
        double d12 = Math.sin(4.0 * d9);
        double d13 = Math.cos(4.0 * d9);
        double d14 = Math.sin(6.0 * d9);
        double d15 = Math.cos(6.0 * d9);
        double d16 = Math.sin(8.0 * d9);
        double d17 = Math.cos(8.0 * d9);
        double d18 = Math.sinh(2.0 * d7);
        double d19 = Math.cosh(2.0 * d7);
        double d20 = Math.sinh(4.0 * d7);
        double d21 = Math.cosh(4.0 * d7);
        double d22 = Math.sinh(6.0 * d7);
        double d23 = Math.cosh(6.0 * d7);
        double d24 = Math.sinh(8.0 * d7);
        double d25 = Math.cosh(8.0 * d7);
        double d26 = this.h4 * d16 * d25 + this.h3 * d14 * d23 + this.h2 * d12 * d21 + this.h1 * d10 * d19 + d9;
        double d27 = this.h4 * d17 * d24 + this.h3 * d15 * d22 + this.h2 * d13 * d20 + this.h1 * d11 * d18 + d7;
        if (dArray2 != null) {
            dArray2[n2] = d27;
            dArray2[n2 + 1] = d26;
        }
        if (!bl) {
            return null;
        }
        double d28 = Math.cos(d);
        double d29 = Math.cos(d2);
        double d30 = d6 * d6;
        double d31 = Math.sinh(d4);
        double d32 = Math.tanh(d4);
        double d33 = d30 - d5 * d5;
        double d34 = Math.sinh(d7);
        double d35 = Math.sqrt(1.0 - d32 * d32 * d8 * d8);
        double d36 = 1.0 / d29 - this.excentricitySquared * d29 / (1.0 - d3 * d3);
        double d37 = d28 * d6 / d33;
        double d38 = -d36 * d5 * d31 / d33;
        double d39 = d31 * d34 * d28 / (d33 * d35);
        double d40 = (d36 * d8 / d30 + d38 * d34 * d32) / d35;
        double d41 = d39 + 2.0 * (this.h1 * (d39 * d11 * d19 + d37 * d18 * d10) + 3.0 * this.h3 * (d39 * d15 * d23 + d37 * d22 * d14) + 2.0 * (this.h2 * (d39 * d13 * d21 + d37 * d20 * d12) + 2.0 * this.h4 * (d39 * d17 * d25 + d37 * d24 * d16)));
        double d42 = d40 + 2.0 * (this.h1 * (d40 * d11 * d19 + d38 * d18 * d10) + 3.0 * this.h3 * (d40 * d15 * d23 + d38 * d22 * d14) + 2.0 * (this.h2 * (d40 * d13 * d21 + d38 * d20 * d12) + 2.0 * this.h4 * (d40 * d17 * d25 + d38 * d24 * d16)));
        double d43 = d37 + 2.0 * (this.h1 * (d37 * d19 * d11 - d39 * d10 * d18) + 3.0 * this.h3 * (d37 * d23 * d15 - d39 * d14 * d22) + 2.0 * (this.h2 * (d37 * d21 * d13 - d39 * d12 * d20) + 2.0 * this.h4 * (d37 * d25 * d17 - d39 * d16 * d24)));
        double d44 = d38 + 2.0 * (this.h1 * (d38 * d19 * d11 - d40 * d10 * d18) + 3.0 * this.h3 * (d38 * d23 * d15 - d40 * d14 * d22) + 2.0 * (this.h2 * (d38 * d21 * d13 - d40 * d12 * d20) + 2.0 * this.h4 * (d38 * d25 * d17 - d40 * d16 * d24)));
        return new Matrix2(d43, d44, d41, d42);
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d;
        double d2 = dArray[n];
        double d3 = dArray[n + 1];
        double d4 = Math.sin(2.0 * d3);
        double d5 = Math.cos(2.0 * d3);
        double d6 = Math.sin(4.0 * d3);
        double d7 = Math.cos(4.0 * d3);
        double d8 = Math.sin(6.0 * d3);
        double d9 = Math.cos(6.0 * d3);
        double d10 = Math.sin(8.0 * d3);
        double d11 = Math.cos(8.0 * d3);
        double d12 = Math.sinh(2.0 * d2);
        double d13 = Math.cosh(2.0 * d2);
        double d14 = Math.sinh(4.0 * d2);
        double d15 = Math.cosh(4.0 * d2);
        double d16 = Math.sinh(6.0 * d2);
        double d17 = Math.cosh(6.0 * d2);
        double d18 = Math.sinh(8.0 * d2);
        double d19 = Math.cosh(8.0 * d2);
        double d20 = d3 - (this.ih4 * d10 * d19 + this.ih3 * d8 * d17 + this.ih2 * d6 * d15 + this.ih1 * d4 * d13);
        double d21 = d2 - (this.ih4 * d11 * d18 + this.ih3 * d9 * d16 + this.ih2 * d7 * d14 + this.ih1 * d5 * d12);
        double d22 = Math.asin(Math.sin(d20) / Math.cosh(d21));
        double d23 = d = MathFunctions.asinh((double)Math.tan(d22));
        double d24 = 0.0;
        for (int i = 0; i < 15; ++i) {
            double d25 = this.excentricity * MathFunctions.atanh((double)(this.excentricity * Math.tanh(d23)));
            d23 = d + d25;
            if (Math.abs(d25 - d24) <= 3.926676682852614E-10) {
                dArray2[n2] = Math.asin(Math.tanh(d21) / Math.cos(d22));
                dArray2[n2 + 1] = Math.atan(Math.sinh(d23));
                return;
            }
            d24 = d25;
        }
        throw new ProjectionException(181);
    }

    private static final class Spherical
    extends TransverseMercator {
        private static final long serialVersionUID = 8903592710452235162L;

        protected Spherical(TransverseMercator transverseMercator) {
            super(transverseMercator);
        }

        @Override
        public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
            double d = dArray[n];
            double d2 = dArray[n + 1];
            double d3 = Math.sin(d);
            double d4 = Math.cos(d);
            double d5 = Math.sin(d2);
            double d6 = Math.cos(d2);
            double d7 = d5 / d6;
            double d8 = d6 * d3;
            if (dArray2 != null) {
                dArray2[n2] = MathFunctions.atanh((double)d8);
                dArray2[n2 + 1] = Math.atan2(d7, d4);
            }
            if (!bl) {
                return null;
            }
            double d9 = d8 * d8 - 1.0;
            double d10 = d4 * d4 + d7 * d7;
            return new Matrix2(-(d6 * d4) / d9, d5 * d3 / d9, d7 * d3 / d10, d4 / (d6 * d6 * d10));
        }

        @Override
        protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
            double d = dArray[n];
            double d2 = dArray[n + 1];
            double d3 = Math.sinh(d);
            double d4 = Math.cos(d2);
            dArray2[n2] = Math.atan2(d3, d4);
            dArray2[n2 + 1] = Math.copySign(Math.asin(Math.sqrt((1.0 - d4 * d4) / (1.0 + d3 * d3))), d2);
        }
    }
}

