/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.jdk8.Function;
import org.apache.sis.internal.util.EmptyQueue;
import org.apache.sis.internal.util.EmptySortedSet;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.Static;
import org.apache.sis.util.collection.CodeListSet;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.InvalidParameterCardinalityException;
import org.opengis.util.CodeList;

public final class CollectionsExt
extends Static {
    private CollectionsExt() {
    }

    public static <T> T first(Iterable<T> iterable) {
        Iterator<T> iterator;
        if (iterable != null && (iterator = iterable.iterator()) != null && iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static <E> Queue<E> emptyQueue() {
        return EmptyQueue.INSTANCE;
    }

    public static <E> SortedSet<E> emptySortedSet() {
        return EmptySortedSet.INSTANCE;
    }

    public static <E> Set<E> singletonOrEmpty(E e) {
        return e != null ? Collections.singleton(e) : Collections.emptySet();
    }

    public static <T> Set<T> nonEmptySet(T ... TArray) {
        Set<T> set = CollectionsExt.immutableSet(true, TArray);
        return set != null && set.isEmpty() ? null : set;
    }

    public static <E> E[] nonEmpty(E[] EArray) {
        return EArray != null && EArray.length == 0 ? null : EArray;
    }

    public static <T extends Collection<E>, E> T nonEmpty(T t) {
        return (T)(t != null && t.isEmpty() ? null : t);
    }

    public static <E> Collection<E> nonNull(Collection<E> collection) {
        return collection != null ? collection : Collections.emptySet();
    }

    public static <E> Set<E> nonNull(Set<E> set) {
        return set != null ? set : Collections.emptySet();
    }

    public static <E> E[] nonNullArraySet(String string, Object object, E[] EArray) throws IllegalArgumentException {
        assert (EArray.length == 0);
        if (object == null) {
            return EArray;
        }
        Class<?> clazz = EArray.getClass();
        Class<?> clazz2 = object.getClass();
        if (clazz2.isArray()) {
            if (clazz.isAssignableFrom(clazz2)) {
                LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>(Arrays.asList((Object[])object));
                linkedHashSet.remove(null);
                return linkedHashSet.toArray(EArray);
            }
        } else if ((clazz = clazz.getComponentType()).isAssignableFrom(clazz2)) {
            Object[] objectArray = (Object[])Array.newInstance(clazz, 1);
            objectArray[0] = object;
            return objectArray;
        }
        throw new IllegalArgumentException(Errors.format((short)40, string, clazz2));
    }

    public static <E> Set<E> createSetForType(Class<E> clazz, int n) {
        if (CodeList.class.isAssignableFrom(clazz)) {
            return new CodeListSet<E>(clazz);
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return EnumSet.noneOf(clazz);
        }
        return new LinkedHashSet(Containers.hashMapCapacity(n));
    }

    public static <E> Set<E> immutableSet(boolean bl, E ... EArray) {
        if (EArray == null) {
            return null;
        }
        switch (EArray.length) {
            case 1: {
                E e = EArray[0];
                if (e != null || !bl) {
                    return Collections.singleton(e);
                }
            }
            case 0: {
                return Collections.emptySet();
            }
        }
        LinkedHashSet<E> linkedHashSet = new LinkedHashSet<E>(Arrays.asList(EArray));
        if (bl) {
            linkedHashSet.remove(null);
        }
        return CollectionsExt.unmodifiableOrCopy(linkedHashSet);
    }

    public static <E> Set<E> unmodifiableOrCopy(Set<E> set) {
        if (set != null) {
            switch (set.size()) {
                case 0: {
                    set = Collections.emptySet();
                    break;
                }
                case 1: {
                    set = Collections.singleton(set.iterator().next());
                    break;
                }
                default: {
                    set = Collections.unmodifiableSet(set);
                }
            }
        }
        return set;
    }

    public static <K, V> Map<K, V> unmodifiableOrCopy(Map<K, V> map) {
        if (map != null) {
            switch (map.size()) {
                case 0: {
                    map = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<K, V> entry = map.entrySet().iterator().next();
                    map = Collections.singletonMap(entry.getKey(), entry.getValue());
                    break;
                }
                default: {
                    map = Collections.unmodifiableMap(map);
                }
            }
        }
        return map;
    }

    public static <E> Collection<E> modifiableCopy(Collection<E> collection) {
        if (collection == null) {
            return null;
        }
        Class<?> clazz = collection.getClass();
        if (collection instanceof Set) {
            if (collection instanceof SortedSet) {
                if (clazz == TreeSet.class) {
                    return (Collection)((TreeSet)collection).clone();
                }
                return new TreeSet<E>(collection);
            }
            if (clazz == HashSet.class || clazz == LinkedHashSet.class) {
                return (Collection)((HashSet)collection).clone();
            }
            if (collection instanceof EnumSet) {
                return ((EnumSet)collection).clone();
            }
            if (collection instanceof CodeListSet) {
                return ((CodeListSet)collection).clone();
            }
            return new LinkedHashSet<E>(collection);
        }
        if (collection instanceof Queue) {
            if (clazz == LinkedList.class) {
                return (Collection)((LinkedList)collection).clone();
            }
            return new LinkedList<E>(collection);
        }
        if (clazz == ArrayList.class) {
            return (Collection)((ArrayList)collection).clone();
        }
        return new ArrayList<E>(collection);
    }

    public static <K, V> Map<K, V> modifiableCopy(Map<K, V> map) {
        if (map == null) {
            return null;
        }
        Class<?> clazz = map.getClass();
        if (map instanceof SortedMap) {
            if (clazz == TreeMap.class) {
                return (Map)((TreeMap)map).clone();
            }
            return new TreeMap<K, V>(map);
        }
        if (clazz == HashMap.class || clazz == LinkedHashMap.class) {
            return (Map)((HashMap)map).clone();
        }
        return new LinkedHashMap<K, V>(map);
    }

    public static <K, V> Map<K, V> compact(Map<K, V> map) {
        if (map != null) {
            switch (map.size()) {
                case 0: {
                    return Collections.emptyMap();
                }
                case 1: {
                    Map.Entry<K, V> entry = map.entrySet().iterator().next();
                    return Collections.singletonMap(entry.getKey(), entry.getValue());
                }
            }
        }
        return map;
    }

    public static <E> List<E> snapshot(List<E> list) {
        if (list != null && !(list instanceof UnmodifiableArrayList)) {
            switch (list.size()) {
                case 0: {
                    return Collections.emptyList();
                }
                case 1: {
                    return Collections.singletonList(list.get(0));
                }
            }
            return Arrays.asList(list.toArray());
        }
        return list;
    }

    public static Collection<?> toCollection(Object object) {
        if (object == null) {
            return Collections.emptyList();
        }
        if (object instanceof Collection) {
            return (Collection)object;
        }
        if (object instanceof Object[]) {
            return Arrays.asList((Object[])object);
        }
        if (object instanceof Iterable) {
            ArrayList arrayList = new ArrayList();
            for (Object t : (Iterable)object) {
                arrayList.add(t);
            }
            return arrayList;
        }
        if (object instanceof Iterator) {
            Iterator iterator = (Iterator)object;
            ArrayList arrayList = new ArrayList();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            return arrayList;
        }
        if (object instanceof Enumeration) {
            return Collections.list((Enumeration)object);
        }
        return Collections.singletonList(object);
    }

    public static <T> List<T> toList(Collection<T> collection) {
        if (collection instanceof List) {
            return (List)collection;
        }
        return new ArrayList<T>(collection);
    }

    public static <T> T[] toArray(Collection<T> collection, Class<T> clazz) {
        assert (Numbers.primitiveToWrapper(clazz) == clazz) : clazz;
        if (collection != null) {
            return collection.toArray((Object[])Array.newInstance(clazz, collection.size()));
        }
        return null;
    }

    public static <K, V> List<V> addToMultiValuesMap(Map<K, List<V>> map, K k, V v) {
        List<V> list = Collections.singletonList(v);
        List<V> list2 = map.put(k, list);
        if (list2 == null) {
            return list;
        }
        if (list2.size() <= 1 && map.put(k, list2 = new ArrayList<V>(list2)) != list) {
            throw new ConcurrentModificationException();
        }
        list2.add(v);
        return list2;
    }

    public static <E> Map<String, E> toCaseInsensitiveNameMap(Collection<? extends E> collection, Function<E, String> function, Locale locale) {
        if (collection == null) {
            return Collections.emptyMap();
        }
        HashMap<String, E> hashMap = new HashMap<String, E>(Containers.hashMapCapacity(collection.size()));
        HashSet<String> hashSet = null;
        for (E e : collection) {
            String string;
            String string2 = function.apply(e);
            E e2 = hashMap.put(string2, e);
            if (e2 != null && Objects.equals(string2, string = function.apply(e2))) {
                throw new InvalidParameterCardinalityException(Errors.format((short)131, string2), string2);
            }
            string = string2.toLowerCase(locale);
            if (string2.equals(string) || hashSet != null && hashSet.contains(string) || (e2 = hashMap.put(string, e)) == null) continue;
            String string3 = function.apply(e2);
            if (string.equals(string3)) {
                hashMap.put(string3, e2);
                continue;
            }
            hashMap.remove(string);
            if (hashSet == null) {
                hashSet = new HashSet<String>();
            }
            hashSet.add(string);
        }
        return hashMap;
    }

    public static boolean identityEquals(Iterator<?> iterator, Iterator<?> iterator2) {
        while (iterator.hasNext()) {
            if (iterator2.hasNext() && iterator.next() == iterator2.next()) continue;
            return false;
        }
        return !iterator2.hasNext();
    }
}

