/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class LazySet<E>
extends AbstractSet<E> {
    public final Iterable<? extends E> source;
    private Iterator<? extends E> iterator;
    private E[] elements;
    private int position;

    public LazySet(Iterable<? extends E> iterable) {
        this.source = iterable;
    }

    public LazySet(Iterator<? extends E> iterator) {
        this.source = null;
        this.iterator = iterator;
        this.elements = new Object[4];
    }

    public void reload() {
        if (this.source != null) {
            this.iterator = null;
            this.elements = null;
            this.position = 0;
        }
    }

    private Iterator<? extends E> sourceElements() {
        if (this.iterator == null && this.elements == null && this.source != null) {
            this.iterator = this.source.iterator();
            this.elements = new Object[4];
        }
        return this.iterator;
    }

    private boolean hasNext() {
        Iterator<E> iterator = this.sourceElements();
        if (iterator != null) {
            if (iterator.hasNext()) {
                return true;
            }
            this.iterator = null;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.position == 0 && !this.hasNext();
    }

    @Override
    public int size() {
        Iterator<E> iterator = this.sourceElements();
        if (iterator != null) {
            while (iterator.hasNext()) {
                this.cache(iterator.next());
            }
            this.iterator = null;
        }
        return this.position;
    }

    private void cache(E e) {
        if (this.position >= this.elements.length) {
            this.elements = Arrays.copyOf(this.elements, this.position * 2);
        }
        this.elements[this.position++] = e;
    }

    final boolean exists(int n) {
        return n < this.position || this.hasNext();
    }

    final E get(int n) {
        if (n >= this.position) {
            if (this.hasNext()) {
                this.cache(this.iterator.next());
            } else {
                throw new NoSuchElementException();
            }
        }
        return this.elements[n];
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private int cursor;

            @Override
            public boolean hasNext() {
                return LazySet.this.exists(this.cursor);
            }

            @Override
            public E next() {
                return LazySet.this.get(this.cursor++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

