/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io;

import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.sis.io.AppendableWriter;
import org.apache.sis.io.Appender;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Vocabulary;

public final class IO
extends Static {
    private IO() {
    }

    public static void flush(Appendable appendable) throws IOException {
        while (!(appendable instanceof Flushable)) {
            if (!(appendable instanceof Appender)) {
                return;
            }
            appendable = ((Appender)appendable).out;
        }
        ((Flushable)((Object)appendable)).flush();
    }

    public static void close(Appendable appendable) throws IOException {
        boolean bl = false;
        while (!(appendable instanceof Closeable)) {
            if (!bl && appendable instanceof Flushable) {
                ((Flushable)((Object)appendable)).flush();
                bl = true;
            }
            if (!(appendable instanceof Appender)) {
                return;
            }
            appendable = ((Appender)appendable).out;
        }
        ((Closeable)((Object)appendable)).close();
    }

    public static CharSequence content(Appendable appendable) {
        while (!(appendable instanceof CharSequence)) {
            if (!(appendable instanceof Appender)) {
                if (appendable instanceof StringWriter) {
                    return ((StringWriter)appendable).getBuffer();
                }
                if (appendable instanceof CharArrayWriter) {
                    return ((CharArrayWriter)appendable).toString();
                }
                return null;
            }
            appendable = ((Appender)appendable).out;
        }
        return (CharSequence)((Object)appendable);
    }

    static String toString(Appendable appendable) {
        CharSequence charSequence = IO.content(appendable);
        if (charSequence != null) {
            return charSequence.toString();
        }
        return Vocabulary.format((short)57);
    }

    public static Writer asWriter(Appendable appendable) {
        if (appendable == null || appendable instanceof Writer) {
            return (Writer)appendable;
        }
        return new AppendableWriter(appendable);
    }
}

