/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.io.Serializable;
import java.text.Format;
import java.text.ParseException;
import java.util.Formattable;
import java.util.Formatter;
import java.util.Locale;
import org.apache.sis.internal.util.Utilities;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.AngleFormat;

public class Angle
implements Comparable<Angle>,
Formattable,
Serializable {
    private static final long serialVersionUID = 3701568577051191744L;
    private static Format format;
    private final double \u03b8;

    public Angle(double d) {
        this.\u03b8 = d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Angle(String string) throws NumberFormatException {
        Object object;
        Class clazz;
        try {
            clazz = Angle.class;
            synchronized (Angle.class) {
                object = Angle.getAngleFormat().parseObject(string);
                // ** MonitorExit[var3_2 /* !! */ ] (shouldn't be in output)
            }
        }
        catch (ParseException parseException) {
            NumberFormatException numberFormatException = new NumberFormatException(parseException.getMessage());
            numberFormatException.initCause(parseException);
            throw numberFormatException;
        }
        {
            clazz = object.getClass();
            if (clazz != Angle.class && !this.getClass().isAssignableFrom(clazz)) {
                throw new NumberFormatException(string);
            }
            this.\u03b8 = ((Angle)object).\u03b8;
            return;
        }
    }

    public double degrees() {
        return this.\u03b8;
    }

    public double radians() {
        return Math.toRadians(this.\u03b8);
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.\u03b8);
        return (int)l ^ (int)(l >>> 32) ^ 0x52E269C0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            return Double.doubleToLongBits(this.\u03b8) == Double.doubleToLongBits(((Angle)object).\u03b8);
        }
        return false;
    }

    @Override
    public int compareTo(Angle angle) {
        return Double.compare(this.\u03b8, angle.\u03b8);
    }

    double maximum() {
        return 360.0;
    }

    char hemisphere(boolean bl) {
        return '\u0000';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        double d = Math.abs(this.\u03b8);
        boolean bl2 = bl = d <= 2.7777777777777776E-7;
        if (bl || d > this.maximum()) {
            char c = this.hemisphere(MathFunctions.isNegative(this.\u03b8));
            if (c == '\u0000') {
                d = this.\u03b8;
            }
            char c2 = '\u00b0';
            if (bl) {
                c2 = '\u2033';
                d *= 3600.0;
            }
            stringBuffer.append(d).append(c2);
            if (c == '\u0000') return stringBuffer.toString();
            stringBuffer.append(c);
            return stringBuffer.toString();
        }
        Class<Angle> clazz = Angle.class;
        synchronized (Angle.class) {
            stringBuffer = Angle.getAngleFormat().format(this, stringBuffer, null);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return stringBuffer.toString();
        }
    }

    private static Format getAngleFormat() {
        assert (Thread.holdsLock(Angle.class));
        if (format == null) {
            format = new AngleFormat(Locale.ROOT);
        }
        return format;
    }

    @Override
    public void formatTo(Formatter formatter, int n, int n2, int n3) {
        String string;
        if (n3 == 0) {
            string = "";
        } else {
            char c;
            int n4 = n3;
            if (n4 > 0 && (c = this.hemisphere(MathFunctions.isNegative(this.\u03b8))) != '\u0000' && --n4 == 0) {
                string = Character.toString(c);
            } else {
                AngleFormat angleFormat = new AngleFormat(formatter.locale());
                if (n4 > 0) {
                    angleFormat.setMaximumWidth(n4);
                }
                string = angleFormat.format(this, new StringBuffer(), null).toString();
            }
        }
        Utilities.formatTo(formatter, n, n2, n3, string);
    }
}

