/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Duration;
import javax.measure.quantity.Length;
import javax.measure.quantity.Quantity;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.apache.sis.internal.util.DefinitionURI;
import org.apache.sis.internal.util.XPaths;
import org.apache.sis.measure.SexagesimalConverter;
import org.apache.sis.measure.UnitsMap;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;

public final class Units
extends Static {
    private static final String[] CARDINAL_DIRECTIONS = new String[]{"east", "west", "north", "south"};
    public static final Unit<Duration> MILLISECOND = SI.MetricPrefix.MILLI((Unit)SI.SECOND);
    public static final Unit<Dimensionless> PPM = Unit.ONE.times(1.0E-6);
    static final Unit<Dimensionless> PSU = Unit.ONE.alternate("psu");
    static final Unit<Dimensionless> SIGMA = Unit.ONE.alternate("sigma");

    private Units() {
    }

    public static boolean isAngular(Unit<?> unit) {
        return unit != null && unit.toSI().equals((Object)SI.RADIAN);
    }

    public static boolean isLinear(Unit<?> unit) {
        return unit != null && unit.toSI().equals((Object)SI.METRE);
    }

    public static boolean isPressure(Unit<?> unit) {
        return unit != null && unit.toSI().equals((Object)SI.PASCAL);
    }

    public static boolean isTemporal(Unit<?> unit) {
        return unit != null && unit.toSI().equals((Object)SI.SECOND);
    }

    public static boolean isScale(Unit<?> unit) {
        return unit != null && unit.toSI().equals((Object)Unit.ONE);
    }

    public static Unit<Angle> ensureAngular(Unit<?> unit) throws IllegalArgumentException {
        if (unit != null && !Units.isAngular(unit)) {
            throw new IllegalArgumentException(Errors.format((short)78, unit));
        }
        return unit;
    }

    public static Unit<Length> ensureLinear(Unit<?> unit) throws IllegalArgumentException {
        if (unit != null && !Units.isLinear(unit)) {
            throw new IllegalArgumentException(Errors.format((short)84, unit));
        }
        return unit;
    }

    public static Unit<Duration> ensureTemporal(Unit<?> unit) throws IllegalArgumentException {
        if (unit != null && !Units.isTemporal(unit)) {
            throw new IllegalArgumentException(Errors.format((short)87, unit));
        }
        return unit;
    }

    public static Unit<Dimensionless> ensureScale(Unit<?> unit) throws IllegalArgumentException {
        if (unit != null && !Units.isScale(unit)) {
            throw new IllegalArgumentException(Errors.format((short)86, unit));
        }
        return unit;
    }

    public static <A extends Quantity> Unit<A> multiply(Unit<A> unit, double d) {
        if (SI.RADIAN.equals(unit)) {
            if (Math.abs(d - Math.PI / 180) <= 1.7453292519943296E-12) {
                return NonSI.DEGREE_ANGLE;
            }
            if (Math.abs(d - 0.015707963267948967) <= 1.5707963267948967E-12) {
                return NonSI.GRADE;
            }
        } else if (SI.METRE.equals(unit)) {
            if (Math.abs(d - 0.3048) <= 3.048E-11) {
                return NonSI.FOOT;
            }
            if (Math.abs(d - 0.3048006096012192) <= 3.048006096012192E-11) {
                return NonSI.FOOT_SURVEY_US;
            }
        }
        if (Math.abs(d - 1.0) > 1.0E-10) {
            long l = (long)d;
            unit = (double)l == d ? unit.times(l) : unit.times(d);
        }
        return UnitsMap.canonicalize(unit);
    }

    public static <A extends Quantity> double toStandardUnit(Unit<A> unit) {
        return Units.derivative(unit.getConverterTo(unit.toSI()), 0.0);
    }

    public static double derivative(UnitConverter unitConverter, double d) {
        return unitConverter.convert(d + 1.0) - unitConverter.convert(d);
    }

    public static Unit<?> valueOf(String string) throws IllegalArgumentException {
        String string2;
        if (string == null) {
            return null;
        }
        string = CharSequences.trimWhitespaces(CharSequences.toASCII(string)).toString();
        int n = string.length();
        if (Units.isURI(string)) {
            string2 = DefinitionURI.codeOf("uom", "EPSG", string);
            if (string2 != null && string2 != string) {
                try {
                    return Units.valueOfEPSG(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(Errors.format((short)31, "uom", string), numberFormatException);
                }
            }
            string2 = XPaths.xpointer("uom", string);
            if (string2 != null) {
                string = string2;
            }
        }
        if (string.regionMatches(true, 0, "deg", 0, 3)) {
            String string3;
            switch (n) {
                case 3: {
                    return NonSI.DEGREE_ANGLE;
                }
                case 4: {
                    if (string.charAt(3) != 'K') break;
                    return SI.KELVIN;
                }
            }
            string2 = string;
            boolean bl = false;
            int n2 = Math.max(string.lastIndexOf(32), string.lastIndexOf(95));
            if (n2 >= 1 && (ArraysExt.containsIgnoreCase(CARDINAL_DIRECTIONS, string3 = (String)CharSequences.trimWhitespaces(string, n2 + 1, n)) || (bl = Units.isCelsius(string3)))) {
                string2 = (String)CharSequences.trimWhitespaces(string, 0, n2);
            }
            if (Units.equalsIgnorePlural(string2, "degree")) {
                return bl ? SI.CELSIUS : NonSI.DEGREE_ANGLE;
            }
        } else {
            if (string.equals("\u00b0") || Units.equalsIgnorePlural(string, "decimal_degree")) {
                return NonSI.DEGREE_ANGLE;
            }
            if (string.equalsIgnoreCase("arcsec")) {
                return NonSI.SECOND_ANGLE;
            }
            if (string.equalsIgnoreCase("rad") || Units.equalsIgnorePlural(string, "radian")) {
                return SI.RADIAN;
            }
            if (Units.equalsIgnorePlural(string, "kilometer") || Units.equalsIgnorePlural(string, "kilometre")) {
                return SI.KILOMETRE;
            }
            if (Units.equalsIgnorePlural(string, "meter") || Units.equalsIgnorePlural(string, "metre")) {
                return SI.METRE;
            }
            if (Units.equalsIgnorePlural(string, "week")) {
                return NonSI.WEEK;
            }
            if (Units.equalsIgnorePlural(string, "day")) {
                return NonSI.DAY;
            }
            if (Units.equalsIgnorePlural(string, "hour")) {
                return NonSI.HOUR;
            }
            if (Units.equalsIgnorePlural(string, "minute")) {
                return NonSI.MINUTE;
            }
            if (Units.equalsIgnorePlural(string, "second")) {
                return SI.SECOND;
            }
            if (Units.equalsIgnorePlural(string, "pixel")) {
                return NonSI.PIXEL;
            }
            if (Units.isCelsius(string)) {
                return SI.CELSIUS;
            }
            if (string.isEmpty()) {
                return Unit.ONE;
            }
            if (string.equalsIgnoreCase("ppm")) {
                return PPM;
            }
            if (string.equalsIgnoreCase("psu")) {
                return PSU;
            }
            if (string.equalsIgnoreCase("sigma")) {
                return SIGMA;
            }
        }
        try {
            string2 = Unit.valueOf((CharSequence)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Exceptions.setMessage(illegalArgumentException, Errors.format((short)31, "uom", string), true);
        }
        if (string2.isCompatible((Unit)SI.HERTZ) && !string.equals("Bd")) {
            return SI.HERTZ;
        }
        return UnitsMap.canonicalize(string2);
    }

    private static boolean equalsIgnorePlural(String string, String string2) {
        int n = string2.length();
        switch (string.length() - n) {
            case 0: {
                break;
            }
            case 1: {
                if (Character.toLowerCase(string.charAt(n)) == 's') break;
            }
            default: {
                return false;
            }
        }
        return string.regionMatches(true, 0, string2, 0, n);
    }

    private static boolean isCelsius(String string) {
        return string.equalsIgnoreCase("Celsius") || string.equalsIgnoreCase("Celcius");
    }

    private static boolean isURI(String string) {
        int n = string.length();
        while (--n >= 0) {
            char c = string.charAt(n);
            if (c != ':' && c != '#') continue;
            return true;
        }
        return false;
    }

    public static Unit<?> valueOfEPSG(int n) {
        switch (n) {
            case 9001: {
                return SI.METRE;
            }
            case 9002: {
                return NonSI.FOOT;
            }
            case 9030: {
                return NonSI.NAUTICAL_MILE;
            }
            case 9036: {
                return SI.KILOMETRE;
            }
            case 9101: {
                return SI.RADIAN;
            }
            case 9102: 
            case 9122: {
                return NonSI.DEGREE_ANGLE;
            }
            case 9103: {
                return NonSI.MINUTE_ANGLE;
            }
            case 9104: {
                return NonSI.SECOND_ANGLE;
            }
            case 9105: {
                return NonSI.GRADE;
            }
            case 9109: {
                return SI.MetricPrefix.MICRO((Unit)SI.RADIAN);
            }
            case 9107: 
            case 9108: {
                return SexagesimalConverter.DMS_SCALED;
            }
            case 9110: {
                return SexagesimalConverter.DMS;
            }
            case 9111: {
                return SexagesimalConverter.DM;
            }
            case 9201: 
            case 9203: {
                return Unit.ONE;
            }
            case 9202: {
                return PPM;
            }
        }
        return null;
    }

    public static Integer getEpsgCode(Unit<?> unit, boolean bl) {
        Integer n = UnitsMap.EPSG_CODES.get(unit);
        if (bl && n != null && n == 9102) {
            n = UnitsMap.I9122;
        }
        return n;
    }
}

