/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Static;

public final class Namespaces
extends Static {
    public static final String GCO = "http://www.isotc211.org/2005/gco";
    public static final String GFC = "http://www.isotc211.org/2005/gfc";
    public static final String GMD = "http://www.isotc211.org/2005/gmd";
    public static final String GMI = "http://www.isotc211.org/2005/gmi";
    public static final String SRV = "http://www.isotc211.org/2005/srv";
    public static final String GTS = "http://www.isotc211.org/2005/gts";
    public static final String GMX = "http://www.isotc211.org/2005/gmx";
    public static final String GML = "http://www.opengis.net/gml/3.2";
    public static final String CSW = "http://www.opengis.net/cat/csw/2.0.2";
    public static final String XSI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XLINK = "http://www.w3.org/1999/xlink";
    private static final String[] GENERIC_URLS = new String[]{"http://www.isotc211.org/2005/", "http://www.opengis.net/", "http://www.w3.org/1999/", "http://www.cnig.gouv.fr/2005/", "http://purl.org/"};
    private static final Map<String, String> SPECIFIC_URLS;

    private Namespaces() {
    }

    public static String getPreferredPrefix(String string, String string2) {
        ArgumentChecks.ensureNonNull("namespace", string);
        String string3 = SPECIFIC_URLS.get(string);
        if (string3 != null) {
            return string3;
        }
        string = string.toLowerCase(Locale.ROOT);
        for (String string4 : GENERIC_URLS) {
            if (!string.startsWith(string4)) continue;
            int n = string4.length();
            int n2 = string.indexOf(47, n);
            string3 = n2 >= 0 ? string.substring(n, n2) : string.substring(n);
            return string3;
        }
        return string2;
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>(40);
        hashMap.put("http://www.w3.org/2001/XMLSchema", "xsd");
        hashMap.put(XSI, "xsi");
        hashMap.put("http://www.w3.org/2004/02/skos/core#", "skos");
        hashMap.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf");
        hashMap.put("http://www.w3.org/1998/Math/MathML", "mml");
        hashMap.put("http://www.opengis.net/sensorML/1.0", "sml1");
        hashMap.put("http://www.opengis.net/sensorML/1.0.1", "sml");
        hashMap.put("http://www.opengis.net/swe/1.0", "swe1");
        hashMap.put(CSW, "csw");
        hashMap.put("http://www.opengis.net/cat/wrs/1.0", "wrs");
        hashMap.put("http://www.opengis.net/cat/wrs", "wrs09");
        hashMap.put("http://www.opengis.net/ows-6/utds/0.3", "utds");
        hashMap.put("http://www.opengis.net/citygml/1.0", "core");
        hashMap.put("http://www.opengis.net/citygml/building/1.0", "build");
        hashMap.put("http://www.opengis.net/citygml/cityfurniture/1.0", "furniture");
        hashMap.put("http://www.opengis.net/citygml/transportation/1.0", "tr");
        hashMap.put("http://www.purl.org/dc/elements/1.1/", "dc2");
        hashMap.put("http://www.purl.org/dc/terms/", "dct2");
        hashMap.put("http://purl.org/dc/terms/", "dct");
        hashMap.put("http://www.inspire.org", "ins");
        hashMap.put("http://inspira.europa.eu/networkservice/view/1.0", "inspire_vs");
        hashMap.put("urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", "xal");
        hashMap.put("urn:oasis:names:tc:ebxml-regrep:xsd:rim:3.0", "rim");
        hashMap.put("urn:oasis:names:tc:ebxml-regrep:rim:xsd:2.5", "rim25");
        hashMap.put("urn:oasis:names:tc:xacml:2.0:context:schema:os", "xacml-context");
        hashMap.put("urn:oasis:names:tc:xacml:2.0:policy:schema:os", "xacml-policy");
        hashMap.put("urn:us:gov:ic:ism:v2", "icism");
        SPECIFIC_URLS = hashMap;
    }
}

