/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.util.Formatter;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Static;

public final class Utilities
extends Static {
    private Utilities() {
    }

    public static boolean appendUnicodeIdentifier(StringBuilder stringBuilder, char c, String string, String string2, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        if (string != null) {
            int n;
            for (int i = 0; i < string.length(); i += Character.charCount(n)) {
                boolean bl4;
                n = string.codePointAt(i);
                boolean bl5 = bl4 = stringBuilder.length() == 0;
                if ((!bl4 ? Character.isUnicodeIdentifierPart(n) : Character.isUnicodeIdentifierStart(n)) || string2.indexOf(n) >= 0) {
                    if (!bl4 && !bl2 && c != '\u0000') {
                        stringBuilder.append(c);
                    }
                    stringBuilder.appendCodePoint(bl ? Character.toLowerCase(n) : (bl3 ? Character.toUpperCase(n) : n));
                    bl2 = true;
                    bl3 = false;
                    continue;
                }
                bl3 = true;
            }
        }
        return bl2;
    }

    public static String toUpperCase(String string, Characters.Filter filter) {
        int n;
        int n2 = string.length();
        int n3 = 0;
        while (true) {
            if (n3 >= n2) {
                return string;
            }
            n = string.codePointAt(n3);
            if (!filter.contains(n) || Character.toUpperCase(n) != n) break;
            n3 += Character.charCount(n);
        }
        StringBuilder stringBuilder = new StringBuilder(n2).append(string, 0, n3);
        while (n3 < n2) {
            n = string.codePointAt(n3);
            if (filter.contains(n)) {
                stringBuilder.appendCodePoint(Character.toUpperCase(n));
            }
            n3 += Character.charCount(n);
        }
        return stringBuilder.toString();
    }

    public static String toString(Class<?> clazz, Object ... objectArray) {
        StringBuffer stringBuffer = new StringBuffer(32).append(Classes.getShortName(clazz)).append('[');
        boolean bl = false;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object;
            if ((object = objectArray[++i]) == null) continue;
            if (bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(objectArray[i - 1]).append('=');
            boolean bl2 = object instanceof CharSequence;
            if (bl2) {
                stringBuffer.append('\u201c');
            }
            stringBuffer.append(object);
            if (bl2) {
                stringBuffer.append('\u201d');
            }
            bl = true;
        }
        return stringBuffer.append(']').toString();
    }

    public static void formatTo(Formatter formatter, int n, int n2, int n3, String string) {
        Object[] objectArray;
        String string2;
        boolean bl;
        boolean bl2 = bl = (n & 2) != 0;
        if (bl && n2 > 0) {
            string = string.toUpperCase(formatter.locale());
            bl = false;
        }
        int n4 = string.length();
        if (n3 >= 0) {
            int n5 = 0;
            for (int i = 0; i < n4; i += n5) {
                if (--n3 < 0) {
                    if (n5 == 0) {
                        string = "";
                        break;
                    }
                    n4 = (i -= n5) + 1;
                    StringBuilder stringBuilder = new StringBuilder(n4);
                    string = stringBuilder.append(string, 0, i).append('\u2026').toString();
                    break;
                }
                n5 = Character.charCount(string.codePointAt(i));
            }
        }
        if (n2 > n4 && (n2 -= string.codePointCount(0, n4)) > 0) {
            string2 = "%s%s";
            objectArray = new Object[]{string, string};
            objectArray[(n & 1) != 0 ? 1 : 0] = CharSequences.spaces(n2);
        } else {
            string2 = bl ? "%S" : "%s";
            objectArray = new Object[]{string};
        }
        formatter.format(string2, objectArray);
    }
}

