/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.ArrayVector;
import org.apache.sis.math.CompoundDirectPositions;
import org.apache.sis.math.Vector;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;

public class Plane
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 2956201711131316723L;
    private static final int DIMENSION = 3;
    private static final double ZERO_THRESHOLD = 1.0E-14;
    private double sx;
    private double sy;
    private double z0;

    public Plane() {
        this.z0 = Double.NaN;
        this.sy = Double.NaN;
        this.sx = Double.NaN;
    }

    public Plane(double d, double d2, double d3) {
        this.sx = d;
        this.sy = d2;
        this.z0 = d3;
    }

    public final double slopeX() {
        return this.sx;
    }

    public final double slopeY() {
        return this.sy;
    }

    public final double z0() {
        return this.z0;
    }

    public final double x(double d, double d2) {
        return (d2 - (this.z0 + this.sy * d)) / this.sx;
    }

    public final double y(double d, double d2) {
        return (d2 - (this.z0 + this.sx * d)) / this.sy;
    }

    public final double z(double d, double d2) {
        return this.z0 + this.sx * d + this.sy * d2;
    }

    public void setEquation(double d, double d2, double d3) {
        this.sx = d;
        this.sy = d2;
        this.z0 = d3;
    }

    public void setEquation(Number number, Number number2, Number number3) {
        this.setEquation(number.doubleValue(), number2.doubleValue(), number3.doubleValue());
    }

    public double fit(double[] dArray, double[] dArray2, double[] dArray3) {
        ArgumentChecks.ensureNonNull("x", dArray);
        ArgumentChecks.ensureNonNull("y", dArray2);
        ArgumentChecks.ensureNonNull("z", dArray3);
        return this.fit(new ArrayVector.Doubles(dArray), new ArrayVector.Doubles(dArray2), (Vector)new ArrayVector.Doubles(dArray3));
    }

    public double fit(Vector vector, Vector vector2, Vector vector3) {
        ArgumentChecks.ensureNonNull("x", vector);
        ArgumentChecks.ensureNonNull("y", vector2);
        ArgumentChecks.ensureNonNull("z", vector3);
        return this.fit(new CompoundDirectPositions(vector, vector2, vector3));
    }

    public double fit(int n, int n2, Vector vector) {
        ArgumentChecks.ensureStrictlyPositive("nx", n);
        ArgumentChecks.ensureStrictlyPositive("ny", n2);
        ArgumentChecks.ensureNonNull("z", vector);
        int n3 = JDK8.multiplyExact(n, n2);
        if (vector.size() != n3) {
            throw new IllegalArgumentException(Errors.format((short)133, n3, vector.size()));
        }
        Fit fit = new Fit(n, n2, vector);
        fit.resolve();
        double d = fit.correlation(n, n3, vector, null);
        this.setEquation(fit.sx, fit.sy, fit.z0);
        return d;
    }

    public double fit(Iterable<? extends DirectPosition> iterable) {
        ArgumentChecks.ensureNonNull("points", iterable);
        Fit fit = new Fit(iterable);
        fit.resolve();
        double d = fit.correlation(0, 0, null, iterable.iterator());
        this.setEquation(fit.sx, fit.sy, fit.z0);
        return d;
    }

    public Plane clone() {
        try {
            return (Plane)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass() == object.getClass()) {
            Plane plane = (Plane)object;
            return Numerics.equals(this.z0, plane.z0) && Numerics.equals(this.sx, plane.sx) && Numerics.equals(this.sy, plane.sy);
        }
        return false;
    }

    public int hashCode() {
        return Numerics.hashCode(0x290689CB2C6251F3L ^ Double.doubleToLongBits(this.z0) + 31L * (Double.doubleToLongBits(this.sx) + 31L * Double.doubleToLongBits(this.sy)));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(60).append("z(x,y) = ");
        String string = "";
        if (this.sx != 0.0) {
            stringBuilder.append(this.sx).append("\u22c5x");
            string = " + ";
        }
        if (this.sy != 0.0) {
            stringBuilder.append(string).append(this.sy).append("\u22c5y");
            string = " + ";
        }
        return stringBuilder.append(string).append(this.z0).toString();
    }

    private static final class Fit {
        private final DoubleDouble sum_x = new DoubleDouble();
        private final DoubleDouble sum_y = new DoubleDouble();
        private final DoubleDouble sum_z = new DoubleDouble();
        private final DoubleDouble sum_xx = new DoubleDouble();
        private final DoubleDouble sum_yy = new DoubleDouble();
        private final DoubleDouble sum_xy = new DoubleDouble();
        private final DoubleDouble sum_zx = new DoubleDouble();
        private final DoubleDouble sum_zy = new DoubleDouble();
        private final DoubleDouble xx = new DoubleDouble();
        private final DoubleDouble yy = new DoubleDouble();
        private final DoubleDouble xy = new DoubleDouble();
        private final DoubleDouble zx = new DoubleDouble();
        private final DoubleDouble zy = new DoubleDouble();
        private final int n;
        DoubleDouble sx;
        DoubleDouble sy;
        DoubleDouble z0;

        Fit(Iterable<? extends DirectPosition> iterable) {
            int n = 0;
            int n2 = 0;
            for (DirectPosition directPosition : iterable) {
                double d;
                double d2;
                int n3 = directPosition.getDimension();
                if (n3 != 3) {
                    throw new MismatchedDimensionException(Errors.format((short)81, "points[" + n + ']', 3, n3));
                }
                ++n;
                double d3 = directPosition.getOrdinate(0);
                if (Double.isNaN(d3) || Double.isNaN(d2 = directPosition.getOrdinate(1)) || Double.isNaN(d = directPosition.getOrdinate(2))) continue;
                this.xx.setToProduct(d3, d3);
                this.yy.setToProduct(d2, d2);
                this.xy.setToProduct(d3, d2);
                this.zx.setToProduct(d, d3);
                this.zy.setToProduct(d, d2);
                this.sum_x.add(d3);
                this.sum_y.add(d2);
                this.sum_z.add(d);
                this.sum_xx.add(this.xx);
                this.sum_yy.add(this.yy);
                this.sum_xy.add(this.xy);
                this.sum_zx.add(this.zx);
                this.sum_zy.add(this.zy);
                ++n2;
            }
            this.n = n2;
        }

        Fit(int n, int n2, Vector vector) {
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    double d = vector.doubleValue(n3);
                    if (Double.isNaN(d)) {
                        throw new IllegalArgumentException(Errors.format((short)110, "z[" + n3 + ']'));
                    }
                    this.zx.setToProduct(d, j);
                    this.zy.setToProduct(d, i);
                    this.sum_z.add(d);
                    this.sum_zx.add(this.zx);
                    this.sum_zy.add(this.zy);
                    ++n3;
                }
            }
            this.sum_x.value = (double)n3 / 2.0;
            this.sum_x.multiply(n - 1, 0.0);
            this.sum_y.value = (double)n3 / 2.0;
            this.sum_y.multiply(n2 - 1, 0.0);
            this.sum_xx.value = n3;
            this.sum_xx.multiply((double)n - 0.5, 0.0);
            this.sum_xx.multiply(n - 1, 0.0);
            this.sum_xx.divide(3.0, 0.0);
            this.sum_yy.value = n3;
            this.sum_yy.multiply((double)n2 - 0.5, 0.0);
            this.sum_yy.multiply(n2 - 1, 0.0);
            this.sum_yy.divide(3.0, 0.0);
            this.sum_xy.value = (double)n3 / 4.0;
            this.sum_xy.multiply(n2 - 1, 0.0);
            this.sum_xy.multiply(n - 1, 0.0);
            this.n = n3;
        }

        private void resolve() {
            this.zx.setFrom(this.sum_x);
            this.zx.divide(-this.n, 0.0);
            this.zx.multiply(this.sum_z);
            this.zx.add(this.sum_zx);
            this.zy.setFrom(this.sum_y);
            this.zy.divide(-this.n, 0.0);
            this.zy.multiply(this.sum_z);
            this.zy.add(this.sum_zy);
            this.xx.setFrom(this.sum_x);
            this.xx.divide(-this.n, 0.0);
            this.xx.multiply(this.sum_x);
            this.xx.add(this.sum_xx);
            this.xy.setFrom(this.sum_y);
            this.xy.divide(-this.n, 0.0);
            this.xy.multiply(this.sum_x);
            this.xy.add(this.sum_xy);
            this.yy.setFrom(this.sum_y);
            this.yy.divide(-this.n, 0.0);
            this.yy.multiply(this.sum_y);
            this.yy.add(this.sum_yy);
            DoubleDouble doubleDouble = new DoubleDouble(this.xx);
            doubleDouble.multiply(this.yy);
            DoubleDouble doubleDouble2 = new DoubleDouble(this.xy);
            doubleDouble2.multiply(this.xy);
            doubleDouble2.subtract(doubleDouble);
            this.sx = new DoubleDouble(this.zy);
            this.sx.multiply(this.xy);
            doubleDouble.setFrom(this.zx);
            doubleDouble.multiply(this.yy);
            this.sx.subtract(doubleDouble);
            this.sx.divide(doubleDouble2);
            this.sy = new DoubleDouble(this.zx);
            this.sy.multiply(this.xy);
            doubleDouble.setFrom(this.zy);
            doubleDouble.multiply(this.xx);
            this.sy.subtract(doubleDouble);
            this.sy.divide(doubleDouble2);
            this.z0 = new DoubleDouble(this.sy);
            this.z0.multiply(this.sum_y);
            doubleDouble.setFrom(this.sx);
            doubleDouble.multiply(this.sum_x);
            doubleDouble.add(this.z0);
            this.z0.setFrom(this.sum_z);
            this.z0.subtract(doubleDouble);
            this.z0.divide(this.n, 0.0);
        }

        double correlation(int n, int n2, Vector vector, Iterator<? extends DirectPosition> iterator) {
            boolean bl = true;
            boolean bl2 = true;
            boolean bl3 = true;
            double d = this.sx.value;
            double d2 = this.sy.value;
            double d3 = this.z0.value;
            double d4 = this.sum_x.value / (double)this.n;
            double d5 = this.sum_y.value / (double)this.n;
            double d6 = this.sum_z.value / (double)this.n;
            double d7 = Math.abs(d * d4 + d2 * d5 + d3);
            int n3 = 0;
            double d8 = 0.0;
            double d9 = 0.0;
            double d10 = 0.0;
            while (true) {
                double d11;
                double d12;
                double d13;
                if (vector != null) {
                    if (n3 >= n2) break;
                    d13 = n3 % n;
                    d12 = n3 / n;
                    d11 = vector.doubleValue(n3++);
                } else {
                    if (!iterator.hasNext()) break;
                    DirectPosition directPosition = iterator.next();
                    d13 = directPosition.getOrdinate(0);
                    d12 = directPosition.getOrdinate(1);
                    d11 = directPosition.getOrdinate(2);
                }
                d13 = (d13 - d4) * d;
                d12 = (d12 - d5) * d2;
                double d14 = d13 + d12;
                if (!Double.isNaN(d14) && !Double.isNaN(d11 -= d6)) {
                    d8 += d14 * d14;
                    d9 += d11 * d11;
                    d10 += d14 * d11;
                }
                if (bl && Math.abs(d13) >= Math.ulp(d12 * 1.0E-14)) {
                    bl = false;
                }
                if (bl2 && Math.abs(d12) >= Math.ulp(d13 * 1.0E-14)) {
                    bl2 = false;
                }
                if (!bl3 || !(d7 >= Math.ulp(d14 * 1.0E-14))) continue;
                bl3 = false;
            }
            if (bl) {
                this.sx.clear();
            }
            if (bl2) {
                this.sy.clear();
            }
            if (bl3) {
                this.z0.clear();
            }
            return Math.min(d10 / Math.sqrt(d8 * d9), 1.0);
        }
    }
}

