/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.NullArgumentException;
import org.apache.sis.util.Static;

public final class ArraysExt
extends Static {
    public static final double[] EMPTY_DOUBLE = new double[0];
    public static final float[] EMPTY_FLOAT = new float[0];
    public static final long[] EMPTY_LONG = new long[0];
    public static final int[] EMPTY_INT = new int[0];
    public static final short[] EMPTY_SHORT = new short[0];
    public static final byte[] EMPTY_BYTE = new byte[0];
    public static final char[] EMPTY_CHAR = new char[0];
    public static final boolean[] EMPTY_BOOLEAN = new boolean[0];

    private ArraysExt() {
    }

    public static <E> E[] resize(E[] EArray, int n) throws NegativeArraySizeException {
        return EArray == null || EArray.length == n ? EArray : Arrays.copyOf(EArray, n);
    }

    public static double[] resize(double[] dArray, int n) throws NegativeArraySizeException {
        if (dArray != null) {
            if (n == 0) {
                return EMPTY_DOUBLE;
            }
            if (dArray.length != n) {
                return Arrays.copyOf(dArray, n);
            }
        }
        return dArray;
    }

    public static float[] resize(float[] fArray, int n) throws NegativeArraySizeException {
        if (fArray != null) {
            if (n == 0) {
                return EMPTY_FLOAT;
            }
            if (fArray.length != n) {
                return Arrays.copyOf(fArray, n);
            }
        }
        return fArray;
    }

    public static long[] resize(long[] lArray, int n) throws NegativeArraySizeException {
        if (lArray != null) {
            if (n == 0) {
                return EMPTY_LONG;
            }
            if (lArray.length != n) {
                return Arrays.copyOf(lArray, n);
            }
        }
        return lArray;
    }

    public static int[] resize(int[] nArray, int n) throws NegativeArraySizeException {
        if (nArray != null) {
            if (n == 0) {
                return EMPTY_INT;
            }
            if (nArray.length != n) {
                return Arrays.copyOf(nArray, n);
            }
        }
        return nArray;
    }

    public static short[] resize(short[] sArray, int n) throws NegativeArraySizeException {
        if (sArray != null) {
            if (n == 0) {
                return EMPTY_SHORT;
            }
            if (sArray.length != n) {
                return Arrays.copyOf(sArray, n);
            }
        }
        return sArray;
    }

    public static byte[] resize(byte[] byArray, int n) throws NegativeArraySizeException {
        if (byArray != null) {
            if (n == 0) {
                return EMPTY_BYTE;
            }
            if (byArray.length != n) {
                return Arrays.copyOf(byArray, n);
            }
        }
        return byArray;
    }

    public static char[] resize(char[] cArray, int n) throws NegativeArraySizeException {
        if (cArray != null) {
            if (n == 0) {
                return EMPTY_CHAR;
            }
            if (cArray.length != n) {
                return Arrays.copyOf(cArray, n);
            }
        }
        return cArray;
    }

    public static boolean[] resize(boolean[] blArray, int n) throws NegativeArraySizeException {
        if (blArray != null) {
            if (n == 0) {
                return EMPTY_BOOLEAN;
            }
            if (blArray.length != n) {
                return Arrays.copyOf(blArray, n);
            }
        }
        return blArray;
    }

    private static <T> T doRemove(T t, int n, int n2) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        if (n2 == 0) {
            return t;
        }
        ArgumentChecks.ensureNonNull("array", t);
        ArgumentChecks.ensurePositive("length", n2);
        int n3 = Array.getLength(t);
        Object object = Array.newInstance(t.getClass().getComponentType(), n3 -= n2);
        System.arraycopy(t, 0, object, 0, n);
        System.arraycopy(t, n + n2, object, n, n3 - n);
        return (T)object;
    }

    public static <E> E[] remove(E[] EArray, int n, int n2) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doRemove(EArray, n, n2);
    }

    public static double[] remove(double[] dArray, int n, int n2) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return n == 0 && dArray != null && n2 == dArray.length ? EMPTY_DOUBLE : ArraysExt.doRemove(dArray, n, n2);
    }

    public static float[] remove(float[] fArray, int n, int n2) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return n == 0 && fArray != null && n2 == fArray.length ? EMPTY_FLOAT : ArraysExt.doRemove(fArray, n, n2);
    }

    public static long[] remove(long[] lArray, int n, int n2) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return n == 0 && lArray != null && n2 == lArray.length ? EMPTY_LONG : ArraysExt.doRemove(lArray, n, n2);
    }

    public static int[] remove(int[] nArray, int n, int n2) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return n == 0 && nArray != null && n2 == nArray.length ? EMPTY_INT : ArraysExt.doRemove(nArray, n, n2);
    }

    public static short[] remove(short[] sArray, int n, int n2) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return n == 0 && sArray != null && n2 == sArray.length ? EMPTY_SHORT : ArraysExt.doRemove(sArray, n, n2);
    }

    public static byte[] remove(byte[] byArray, int n, int n2) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return n == 0 && byArray != null && n2 == byArray.length ? EMPTY_BYTE : ArraysExt.doRemove(byArray, n, n2);
    }

    public static char[] remove(char[] cArray, int n, int n2) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return n == 0 && cArray != null && n2 == cArray.length ? EMPTY_CHAR : ArraysExt.doRemove(cArray, n, n2);
    }

    public static boolean[] remove(boolean[] blArray, int n, int n2) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return n == 0 && blArray != null && n2 == blArray.length ? EMPTY_BOOLEAN : ArraysExt.doRemove(blArray, n, n2);
    }

    private static <T> T doInsert(T t, int n, int n2) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        if (n2 == 0) {
            return t;
        }
        ArgumentChecks.ensureNonNull("array", t);
        ArgumentChecks.ensurePositive("length", n2);
        int n3 = Array.getLength(t);
        Object object = Array.newInstance(t.getClass().getComponentType(), n3 + n2);
        System.arraycopy(t, 0, object, 0, n);
        System.arraycopy(t, n, object, n + n2, n3 - n);
        return (T)object;
    }

    public static <E> E[] insert(E[] EArray, int n, int n2) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doInsert(EArray, n, n2);
    }

    public static double[] insert(double[] dArray, int n, int n2) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doInsert(dArray, n, n2);
    }

    public static float[] insert(float[] fArray, int n, int n2) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doInsert(fArray, n, n2);
    }

    public static long[] insert(long[] lArray, int n, int n2) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doInsert(lArray, n, n2);
    }

    public static int[] insert(int[] nArray, int n, int n2) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doInsert(nArray, n, n2);
    }

    public static short[] insert(short[] sArray, int n, int n2) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doInsert(sArray, n, n2);
    }

    public static byte[] insert(byte[] byArray, int n, int n2) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doInsert(byArray, n, n2);
    }

    public static char[] insert(char[] cArray, int n, int n2) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doInsert(cArray, n, n2);
    }

    public static boolean[] insert(boolean[] blArray, int n, int n2) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doInsert(blArray, n, n2);
    }

    private static <T> T doInsert(T t, int n, T t2, int n2, int n3) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        if (n3 == 0) {
            return t2;
        }
        ArgumentChecks.ensureNonNull("src", t);
        ArgumentChecks.ensureNonNull("dst", t2);
        ArgumentChecks.ensurePositive("length", n3);
        int n4 = Array.getLength(t2);
        Object object = Array.newInstance(t2.getClass().getComponentType(), n4 + n3);
        System.arraycopy(t2, 0, object, 0, n2);
        System.arraycopy(t, n, object, n2, n3);
        System.arraycopy(t2, n2, object, n2 + n3, n4 - n2);
        return (T)object;
    }

    public static <E> E[] insert(E[] EArray, int n, E[] EArray2, int n2, int n3) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doInsert(EArray, n, EArray2, n2, n3);
    }

    public static double[] insert(double[] dArray, int n, double[] dArray2, int n2, int n3) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doInsert(dArray, n, dArray2, n2, n3);
    }

    public static float[] insert(float[] fArray, int n, float[] fArray2, int n2, int n3) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doInsert(fArray, n, fArray2, n2, n3);
    }

    public static long[] insert(long[] lArray, int n, long[] lArray2, int n2, int n3) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doInsert(lArray, n, lArray2, n2, n3);
    }

    public static int[] insert(int[] nArray, int n, int[] nArray2, int n2, int n3) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doInsert(nArray, n, nArray2, n2, n3);
    }

    public static short[] insert(short[] sArray, int n, short[] sArray2, int n2, int n3) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doInsert(sArray, n, sArray2, n2, n3);
    }

    public static byte[] insert(byte[] byArray, int n, byte[] byArray2, int n2, int n3) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doInsert(byArray, n, byArray2, n2, n3);
    }

    public static char[] insert(char[] cArray, int n, char[] cArray2, int n2, int n3) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doInsert(cArray, n, cArray2, n2, n3);
    }

    public static boolean[] insert(boolean[] blArray, int n, boolean[] blArray2, int n2, int n3) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doInsert(blArray, n, blArray2, n2, n3);
    }

    public static <T> T[] append(T[] TArray, T t) throws NullArgumentException {
        ArgumentChecks.ensureNonNull("array", TArray);
        T[] TArray2 = Arrays.copyOf(TArray, TArray.length + 1);
        TArray2[TArray.length] = t;
        return TArray2;
    }

    public static int removeDuplicated(Object[] objectArray) {
        int n;
        if (objectArray == null) {
            return 0;
        }
        int n2 = n = objectArray.length;
        block0: while (--n2 >= 0) {
            Object object = objectArray[n2];
            int n3 = n2;
            while (--n3 >= 0) {
                if (!Objects.equals(objectArray[n3], object)) continue;
                System.arraycopy(objectArray, n2 + 1, objectArray, n2, --n - n2);
                objectArray[n] = null;
                continue block0;
            }
        }
        return n;
    }

    public static void reverse(Object[] objectArray) {
        if (objectArray != null) {
            int n = objectArray.length >>> 1;
            int n2 = n + (objectArray.length & 1);
            while (--n >= 0) {
                Object object = objectArray[n];
                objectArray[n] = objectArray[n2];
                objectArray[n2++] = object;
            }
        }
    }

    public static void reverse(int[] nArray) {
        if (nArray != null) {
            int n = nArray.length >>> 1;
            int n2 = n + (nArray.length & 1);
            while (--n >= 0) {
                int n3 = nArray[n];
                nArray[n] = nArray[n2];
                nArray[n2++] = n3;
            }
        }
    }

    public static <E> boolean isSorted(E[] EArray, Comparator<? super E> comparator, boolean bl) {
        for (int i = 0; i < EArray.length; ++i) {
            E e = EArray[i];
            if (e == null) continue;
            while (++i < EArray.length) {
                E e2 = EArray[i];
                if (e2 == null) continue;
                int n = comparator.compare(e2, e);
                if (bl ? n <= 0 : n < 0) {
                    return false;
                }
                e = e2;
            }
            break;
        }
        return true;
    }

    public static <E extends Comparable<? super E>> boolean isSorted(E[] EArray, boolean bl) {
        for (int i = 0; i < EArray.length; ++i) {
            E e = EArray[i];
            if (e == null) continue;
            while (++i < EArray.length) {
                E e2 = EArray[i];
                if (e2 == null) continue;
                int n = e2.compareTo(e);
                if (bl ? n <= 0 : n < 0) {
                    return false;
                }
                e = e2;
            }
            break;
        }
        return true;
    }

    public static boolean isSorted(double[] dArray, boolean bl) {
        for (int i = 0; i < dArray.length; ++i) {
            double d = dArray[i];
            if (Double.isNaN(d)) continue;
            while (++i < dArray.length) {
                double d2 = dArray[i];
                if (bl ? d2 <= d : d2 < d) {
                    return false;
                }
                if (Double.isNaN(d2)) continue;
                d = d2;
            }
            break;
        }
        return true;
    }

    public static boolean isSorted(float[] fArray, boolean bl) {
        for (int i = 0; i < fArray.length; ++i) {
            float f = fArray[i];
            if (Float.isNaN(f)) continue;
            while (++i < fArray.length) {
                float f2 = fArray[i];
                if (bl ? f2 <= f : f2 < f) {
                    return false;
                }
                if (Float.isNaN(f2)) continue;
                f = f2;
            }
            break;
        }
        return true;
    }

    public static boolean isSorted(long[] lArray, boolean bl) {
        if (lArray.length != 0) {
            long l = lArray[0];
            for (int i = 1; i < lArray.length; ++i) {
                long l2 = lArray[i];
                if (bl ? l2 <= l : l2 < l) {
                    return false;
                }
                l = l2;
            }
        }
        return true;
    }

    public static boolean isSorted(int[] nArray, boolean bl) {
        if (nArray.length != 0) {
            int n = nArray[0];
            for (int i = 1; i < nArray.length; ++i) {
                int n2 = nArray[i];
                if (bl ? n2 <= n : n2 < n) {
                    return false;
                }
                n = n2;
            }
        }
        return true;
    }

    public static boolean isSorted(short[] sArray, boolean bl) {
        if (sArray.length != 0) {
            short s = sArray[0];
            for (int i = 1; i < sArray.length; ++i) {
                short s2 = sArray[i];
                if (bl ? s2 <= s : s2 < s) {
                    return false;
                }
                s = s2;
            }
        }
        return true;
    }

    public static boolean isSorted(byte[] byArray, boolean bl) {
        if (byArray.length != 0) {
            byte by = byArray[0];
            for (int i = 1; i < byArray.length; ++i) {
                byte by2 = byArray[i];
                if (bl ? by2 <= by : by2 < by) {
                    return false;
                }
                by = by2;
            }
        }
        return true;
    }

    public static boolean isSorted(char[] cArray, boolean bl) {
        if (cArray.length != 0) {
            char c = cArray[0];
            for (int i = 1; i < cArray.length; ++i) {
                char c2 = cArray[i];
                if (bl ? c2 <= c : c2 < c) {
                    return false;
                }
                c = c2;
            }
        }
        return true;
    }

    public static void swap(Object[] objectArray, int n, int n2) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
    }

    public static void swap(double[] dArray, int n, int n2) {
        double d = dArray[n];
        dArray[n] = dArray[n2];
        dArray[n2] = d;
    }

    public static void swap(float[] fArray, int n, int n2) {
        float f = fArray[n];
        fArray[n] = fArray[n2];
        fArray[n2] = f;
    }

    public static void swap(long[] lArray, int n, int n2) {
        long l = lArray[n];
        lArray[n] = lArray[n2];
        lArray[n2] = l;
    }

    public static void swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    public static void swap(short[] sArray, int n, int n2) {
        short s = sArray[n];
        sArray[n] = sArray[n2];
        sArray[n2] = s;
    }

    public static void swap(byte[] byArray, int n, int n2) {
        byte by = byArray[n];
        byArray[n] = byArray[n2];
        byArray[n2] = by;
    }

    public static void swap(char[] cArray, int n, int n2) {
        char c = cArray[n];
        cArray[n] = cArray[n2];
        cArray[n2] = c;
    }

    public static boolean allEquals(Object[] objectArray, Object object) {
        if (object == null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) continue;
                return false;
            }
        } else {
            for (int i = 0; i < objectArray.length; ++i) {
                if (object.equals(objectArray[i])) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean allEquals(double[] dArray, double d) {
        if (Double.isNaN(d)) {
            for (int i = 0; i < dArray.length; ++i) {
                if (Double.isNaN(dArray[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < dArray.length; ++i) {
                if (dArray[i] == d) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean allEquals(float[] fArray, float f) {
        if (Float.isNaN(f)) {
            for (int i = 0; i < fArray.length; ++i) {
                if (Float.isNaN(fArray[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < fArray.length; ++i) {
                if (fArray[i] == f) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean hasNaN(double[] dArray) {
        if (dArray != null) {
            for (int i = 0; i < dArray.length; ++i) {
                if (!Double.isNaN(dArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasNaN(float[] fArray) {
        if (fArray != null) {
            for (int i = 0; i < fArray.length; ++i) {
                if (!Float.isNaN(fArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsIgnoreCase(String[] stringArray, String string) {
        if (stringArray != null) {
            for (String string2 : stringArray) {
                if (!string.equalsIgnoreCase(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsIdentity(Object[] objectArray, Object object) {
        if (objectArray != null) {
            for (Object object2 : objectArray) {
                if (object2 != object) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(Object[] objectArray, Object object) {
        if (objectArray != null) {
            for (Object object2 : objectArray) {
                if (!Objects.equals(object2, object)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean intersects(Object[] objectArray, Object[] objectArray2) {
        if (objectArray != null) {
            for (Object object : objectArray) {
                if (!ArraysExt.contains(objectArray2, object)) continue;
                return true;
            }
        }
        return false;
    }

    @SafeVarargs
    public static <T> T[] concatenate(T[] ... TArray) {
        T[] TArray2 = null;
        if (TArray != null) {
            int n = 0;
            for (T[] TArray3 : TArray) {
                if (TArray3 == null) continue;
                n += TArray3.length;
            }
            int n2 = 0;
            for (T[] TArray4 : TArray) {
                if (TArray4 == null) continue;
                if (TArray2 == null) {
                    if (TArray4.length == n) {
                        return TArray4;
                    }
                    TArray2 = Arrays.copyOf(TArray4, n);
                } else {
                    System.arraycopy(TArray4, 0, TArray2, n2, TArray4.length);
                }
                n2 += TArray4.length;
            }
        }
        return TArray2;
    }

    public static int[] unionOfSorted(int[] nArray, int[] nArray2) {
        if (nArray == null) {
            return nArray2;
        }
        if (nArray2 == null) {
            return nArray;
        }
        int[] nArray3 = new int[nArray.length + nArray2.length];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            int n4;
            int n5;
            if (n2 == nArray.length) {
                n5 = nArray2.length - n3;
                System.arraycopy(nArray2, n3, nArray3, n, n5);
                n += n5;
                break;
            }
            if (n3 == nArray2.length) {
                n5 = nArray.length - n2;
                System.arraycopy(nArray, n2, nArray3, n, n5);
                n += n5;
                break;
            }
            n5 = nArray[n2];
            int n6 = nArray2[n3];
            if (n5 <= n6) {
                n4 = n5;
                ++n2;
                if (n5 == n6) {
                    ++n3;
                }
            } else {
                n4 = n6;
                ++n3;
            }
            nArray3[n++] = n4;
        }
        nArray3 = ArraysExt.resize(nArray3, n);
        return nArray3;
    }
}

