/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.index;

import java.io.Serializable;
import java.text.ParseException;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Deprecated
public class GeoHashCoder
implements Serializable {
    private static final long serialVersionUID = 9162259764027168776L;
    private Format format = Format.BASE32;
    private byte precision = (byte)12;
    private transient char[] buffer;
    private final CoordinateReferenceSystem crs = CommonCRS.defaultGeographic();

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        ArgumentChecks.ensureNonNull((String)"format", (Object)((Object)format));
        this.format = format;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int n) {
        ArgumentChecks.ensureBetween((String)"precision", (int)1, (int)255, (int)n);
        this.precision = (byte)n;
        this.buffer = null;
    }

    public String encode(double d, double d2) {
        byte[] byArray = this.format.encoding;
        int n = this.format.highestOneBit;
        char[] cArray = this.buffer;
        if (cArray == null) {
            this.buffer = cArray = new char[this.precision & 0xFF];
        }
        boolean bl = true;
        double d3 = -180.0;
        double d4 = -90.0;
        double d5 = 180.0;
        double d6 = 90.0;
        int n2 = 0;
        int n3 = n;
        int n4 = 0;
        while (n4 < cArray.length) {
            double d7;
            if (bl) {
                d7 = (d3 + d5) / 2.0;
                if (d > d7) {
                    n2 |= n3;
                    d3 = d7;
                } else {
                    d5 = d7;
                }
            } else {
                d7 = (d4 + d6) / 2.0;
                if (d2 > d7) {
                    n2 |= n3;
                    d4 = d7;
                } else {
                    d6 = d7;
                }
            }
            boolean bl2 = bl = !bl;
            if ((n3 >>>= 1) != 0) continue;
            cArray[n4++] = (char)byArray[n2];
            n3 = n;
            n2 = 0;
        }
        return new String(cArray);
    }

    public String encode(DirectPosition directPosition) {
        ArgumentChecks.ensureDimensionMatches((String)"position", (int)2, (DirectPosition)directPosition);
        return this.encode(directPosition.getOrdinate(0), directPosition.getOrdinate(1));
    }

    public DirectPosition decode(String string) throws ParseException {
        int n;
        int n2 = string.length();
        int n3 = this.format.highestOneBit;
        byte[] byArray = this.format.decodingLowerCase;
        byte[] byArray2 = this.format.decodingUpperCase;
        boolean bl = true;
        double d = -180.0;
        double d2 = -90.0;
        double d3 = 180.0;
        double d4 = 90.0;
        for (int i = 0; i < n2; i += n) {
            int n4 = string.codePointAt(i);
            n = Character.charCount(n4);
            if (n4 >= 48 && n4 <= 57) {
                n4 -= 48;
            } else if ((n4 = n4 >= 97 && n4 <= 122 ? byArray[n4 - 97] : (n4 >= 65 && n4 <= 90 ? byArray2[n4 - 65] : 0)) == 0) {
                throw new ParseException(Errors.format((short)155, (Object)"GeoHash", (Object)string, (Object)string.substring(i, i + n)), i);
            }
            int n5 = n3;
            do {
                double d5;
                if (bl) {
                    d5 = (d + d3) / 2.0;
                    if ((n4 & n5) != 0) {
                        d = d5;
                    } else {
                        d3 = d5;
                    }
                } else {
                    d5 = (d2 + d4) / 2.0;
                    if ((n4 & n5) != 0) {
                        d2 = d5;
                    } else {
                        d4 = d5;
                    }
                }
                boolean bl2 = bl = !bl;
            } while ((n5 >>>= 1) != 0);
        }
        return new DirectPosition2D(this.crs, (d + d3) / 2.0, (d2 + d4) / 2.0);
    }

    @Deprecated
    public static enum Format {
        BASE32(16, new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 98, 99, 100, 101, 102, 103, 104, 106, 107, 109, 110, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122});

        final int highestOneBit;
        final byte[] encoding;
        final byte[] decodingLowerCase;
        final byte[] decodingUpperCase;

        private Format(int n2, byte[] byArray) {
            this.highestOneBit = n2;
            this.encoding = byArray;
            byte[] byArray2 = new byte[26];
            for (int n3 = 10; n3 < byArray.length; n3 = (int)((byte)(n3 + 1))) {
                byArray2[byArray[n3] - 97] = n3;
            }
            this.decodingLowerCase = byArray2;
            this.decodingUpperCase = byArray2;
        }
    }
}

