/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.util.Locale;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.Resource;
import org.apache.sis.util.Localized;
import org.apache.sis.util.logging.WarningListeners;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.metadata.identification.Identification;

public abstract class AbstractResource
implements Resource,
Localized {
    protected final WarningListeners<DataStore> listeners;

    protected AbstractResource(WarningListeners<DataStore> warningListeners) {
        this.listeners = warningListeners;
    }

    public final Locale getLocale() {
        return this.listeners != null ? this.listeners.getLocale() : null;
    }

    protected final String getStoreName() {
        return this.listeners != null ? ((DataStore)this.listeners.getSource()).getDisplayName() : null;
    }

    public Envelope getEnvelope() throws DataStoreException {
        return AbstractResource.envelope(this.getMetadata());
    }

    public static Envelope envelope(Metadata metadata) {
        GeneralEnvelope generalEnvelope = null;
        if (metadata != null) {
            for (Identification identification : metadata.getIdentificationInfo()) {
                if (!(identification instanceof DataIdentification)) continue;
                for (Extent extent : ((DataIdentification)identification).getExtents()) {
                    if (extent == null) continue;
                    for (GeographicExtent geographicExtent : extent.getGeographicElements()) {
                        if (!(geographicExtent instanceof GeographicBoundingBox)) continue;
                        GeneralEnvelope generalEnvelope2 = new GeneralEnvelope((GeographicBoundingBox)geographicExtent);
                        if (generalEnvelope == null) {
                            generalEnvelope = generalEnvelope2;
                            continue;
                        }
                        generalEnvelope.add((Envelope)generalEnvelope2);
                    }
                }
            }
        }
        return generalEnvelope;
    }
}

