/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.metadata.sql.MetadataSource;
import org.apache.sis.metadata.sql.MetadataStoreException;
import org.apache.sis.storage.DataStore;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.logging.WarningListeners;
import org.opengis.metadata.distribution.Format;

public abstract class DocumentedStoreProvider
extends URIDataStore.Provider {
    private final String name;
    private volatile boolean logged;

    protected DocumentedStoreProvider(String string) {
        this.name = string;
    }

    @Override
    public String getShortName() {
        return this.name;
    }

    @Override
    public final Format getFormat() {
        return this.getFormat(null);
    }

    public final Format getFormat(WarningListeners<DataStore> warningListeners) {
        if (this.name != null) {
            try {
                return (Format)MetadataSource.getProvided().lookup(Format.class, this.name);
            }
            catch (MetadataStoreException metadataStoreException) {
                Level level;
                if (warningListeners != null) {
                    warningListeners.warning(null, (Exception)((Object)metadataStoreException));
                }
                if (!this.logged) {
                    this.logged = true;
                    level = Level.WARNING;
                } else {
                    level = Level.FINE;
                }
                LogRecord logRecord = Resources.forLocale(null).getLogRecord(level, (short)39, this.getShortName(), metadataStoreException.getLocalizedMessage());
                logRecord.setLoggerName("org.apache.sis.storage");
                Logging.log(this.getClass(), (String)"getFormat", (LogRecord)logRecord);
            }
        }
        return super.getFormat();
    }
}

