/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.folder;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Logger;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.internal.storage.folder.Store;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.IllegalOpenParameterException;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.logging.Logging;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.InternationalString;

public final class FolderStoreProvider
extends DataStoreProvider {
    private static final String NAME = "folder";
    private static final ParameterDescriptor<Locale> LOCALE;
    private static final ParameterDescriptor<TimeZone> TIMEZONE;
    private static final ParameterDescriptor<Charset> ENCODING;
    static final ParameterDescriptorGroup PARAMETERS;
    public static final FolderStoreProvider INSTANCE;

    private FolderStoreProvider() {
    }

    @Override
    public String getShortName() {
        return NAME;
    }

    @Override
    public ParameterDescriptorGroup getOpenParameters() {
        return PARAMETERS;
    }

    @Override
    public ProbeResult probeContent(StorageConnector storageConnector) throws DataStoreException {
        try {
            Path path = storageConnector.getStorageAs(Path.class);
            if (path != null && Files.isDirectory(path, new LinkOption[0])) {
                return ProbeResult.SUPPORTED;
            }
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
            Logging.recoverableException((Logger)Logging.getLogger((String)"org.apache.sis.storage"), FolderStoreProvider.class, (String)"probeContent", (Throwable)fileSystemNotFoundException);
        }
        return ProbeResult.UNSUPPORTED_STORAGE;
    }

    @Override
    public DataStore open(StorageConnector storageConnector) throws DataStoreException {
        try {
            return new Store(this, storageConnector);
        }
        catch (IOException iOException) {
            throw new DataStoreException(Resources.format((short)34, storageConnector.getStorageName()), iOException);
        }
    }

    @Override
    public DataStore open(ParameterValueGroup parameterValueGroup) throws DataStoreException {
        ArgumentChecks.ensureNonNull((String)"parameter", (Object)parameterValueGroup);
        ParameterNotFoundException parameterNotFoundException = null;
        try {
            Object object = parameterValueGroup.parameter("location").getValue();
            if (object != null) {
                Parameters parameters = Parameters.castOrWrap((ParameterValueGroup)parameterValueGroup);
                StorageConnector storageConnector = new StorageConnector(object);
                storageConnector.setOption(OptionKey.LOCALE, parameters.getValue(LOCALE));
                storageConnector.setOption(OptionKey.TIMEZONE, parameters.getValue(TIMEZONE));
                storageConnector.setOption(OptionKey.ENCODING, parameters.getValue(ENCODING));
                return this.open(storageConnector);
            }
        }
        catch (ParameterNotFoundException parameterNotFoundException2) {
            parameterNotFoundException = parameterNotFoundException2;
        }
        throw new IllegalOpenParameterException(Resources.format((short)27, this.getShortName(), "location"), parameterNotFoundException);
    }

    public static DataStore open(Path path) throws DataStoreException {
        return INSTANCE.open(new StorageConnector(path));
    }

    static {
        ParameterBuilder parameterBuilder = new ParameterBuilder();
        InternationalString internationalString = Resources.formatInternational((short)33);
        LOCALE = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addName((CharSequence)"locale")).setDescription((CharSequence)Resources.formatInternational((short)30))).setRemarks((CharSequence)internationalString)).create(Locale.class, null);
        TIMEZONE = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addName((CharSequence)"timezone")).setDescription((CharSequence)Resources.formatInternational((short)32))).setRemarks((CharSequence)internationalString)).create(TimeZone.class, null);
        ENCODING = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addName((CharSequence)"encoding")).setDescription((CharSequence)Resources.formatInternational((short)29))).setRemarks((CharSequence)internationalString)).create(Charset.class, null);
        ParameterDescriptor parameterDescriptor = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addName((CharSequence)"location")).setDescription((CharSequence)((AbstractIdentifiedObject)URIDataStore.Provider.LOCATION_PARAM).getDescription())).setRequired(true).create(Path.class, null);
        PARAMETERS = ((ParameterBuilder)parameterBuilder.addName((CharSequence)NAME)).createGroup(new GeneralParameterDescriptor[]{parameterDescriptor, LOCALE, TIMEZONE, ENCODING});
        INSTANCE = new FolderStoreProvider();
    }
}

