/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.folder;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.jdk8.UncheckedIOException;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.folder.FolderStoreProvider;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.DataStores;
import org.apache.sis.storage.ReadOnlyStorageException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.util.collection.BackingStoreException;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.parameter.ParameterValueGroup;

final class Store
extends DataStore
implements Aggregate,
DirectoryStream.Filter<Path> {
    private final Path location;
    private final Locale locale;
    private final TimeZone timezone;
    private final Charset encoding;
    private final Map<Path, DataStore> children;
    private transient Metadata metadata;
    private transient Collection<Resource> components;
    private transient boolean sharedRepositoryReported;

    Store(DataStoreProvider dataStoreProvider, StorageConnector storageConnector) throws DataStoreException, IOException {
        super(dataStoreProvider, storageConnector);
        this.location = storageConnector.getStorageAs(Path.class);
        this.locale = (Locale)storageConnector.getOption(OptionKey.LOCALE);
        this.timezone = (TimeZone)storageConnector.getOption(OptionKey.TIMEZONE);
        this.encoding = (Charset)storageConnector.getOption(OptionKey.ENCODING);
        this.children = new ConcurrentHashMap<Path, DataStore>();
        this.children.put(this.location.toRealPath(new LinkOption[0]), this);
    }

    private Store(Store store, StorageConnector storageConnector) throws DataStoreException {
        super(store, storageConnector);
        this.location = storageConnector.getStorageAs(Path.class);
        this.locale = (Locale)storageConnector.getOption(OptionKey.LOCALE);
        this.timezone = (TimeZone)storageConnector.getOption(OptionKey.TIMEZONE);
        this.encoding = (Charset)storageConnector.getOption(OptionKey.ENCODING);
        this.children = store.children;
    }

    @Override
    public ParameterValueGroup getOpenParameters() {
        ParameterValueGroup parameterValueGroup = (this.provider != null ? this.provider.getOpenParameters() : FolderStoreProvider.PARAMETERS).createValue();
        parameterValueGroup.parameter("location").setValue((Object)this.location);
        if (this.locale != null) {
            parameterValueGroup.parameter("locale").setValue((Object)this.locale);
        }
        if (this.timezone != null) {
            parameterValueGroup.parameter("timezone").setValue((Object)this.timezone);
        }
        if (this.encoding != null) {
            parameterValueGroup.parameter("encoding").setValue((Object)this.encoding);
        }
        return parameterValueGroup;
    }

    @Override
    public boolean accept(Path path) throws IOException {
        return !Files.isHidden(path);
    }

    @Override
    public synchronized Metadata getMetadata() {
        if (this.metadata == null) {
            MetadataBuilder metadataBuilder = new MetadataBuilder();
            String string = this.getDisplayName();
            metadataBuilder.addResourceScope(ScopeCode.valueOf((String)"COLLECTION"), (CharSequence)Resources.formatInternational((short)35, string));
            metadataBuilder.addLanguage(this.locale, MetadataBuilder.Scope.RESOURCE);
            metadataBuilder.addEncoding(this.encoding, MetadataBuilder.Scope.RESOURCE);
            metadataBuilder.addTitleOrIdentifier(string, MetadataBuilder.Scope.ALL);
            this.metadata = metadataBuilder.build(true);
        }
        return this.metadata;
    }

    @Override
    public synchronized Collection<Resource> components() throws DataStoreException {
        if (this.components == null) {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.location, this);){
                ArrayList<DataStore> arrayList = new ArrayList<DataStore>();
                for (Path path : directoryStream) {
                    Path path2 = path.toRealPath(new LinkOption[0]);
                    DataStore dataStore = this.children.get(path2);
                    if (dataStore instanceof Store) {
                        ((Store)dataStore).sharedRepository(path2);
                    }
                    if (dataStore == null) {
                        StorageConnector storageConnector = new StorageConnector(path);
                        storageConnector.setOption(OptionKey.LOCALE, this.locale);
                        storageConnector.setOption(OptionKey.TIMEZONE, this.timezone);
                        storageConnector.setOption(OptionKey.ENCODING, this.encoding);
                        try {
                            dataStore = DataStores.open(storageConnector);
                        }
                        catch (UnsupportedStorageException unsupportedStorageException) {
                            if (!Files.isDirectory(path, new LinkOption[0])) {
                                storageConnector.closeAllExcept(null);
                                this.listeners.warning(Level.FINE, null, (Exception)unsupportedStorageException);
                                continue;
                            }
                            dataStore = new Store(this, storageConnector);
                        }
                        catch (DataStoreException dataStoreException) {
                            try {
                                storageConnector.closeAllExcept(null);
                            }
                            catch (DataStoreException dataStoreException2) {
                                dataStoreException.addSuppressed(dataStoreException2);
                            }
                            throw dataStoreException;
                        }
                        DataStore dataStore2 = (DataStore)JDK8.putIfAbsent(this.children, (Object)path2, (Object)dataStore);
                        if (dataStore2 != null) {
                            dataStore.close();
                            dataStore = dataStore2;
                            if (dataStore instanceof Store) {
                                ((Store)dataStore).sharedRepository(path2);
                            }
                        }
                    }
                    arrayList.add(dataStore);
                }
                this.components = UnmodifiableArrayList.wrap((Object[])arrayList.toArray(new Resource[arrayList.size()]));
            }
            catch (DirectoryIteratorException | UncheckedIOException throwable) {
                throw new DataStoreException(this.canNotRead(), throwable.getCause());
            }
            catch (IOException iOException) {
                throw new DataStoreException(this.canNotRead(), iOException);
            }
            catch (BackingStoreException backingStoreException) {
                throw (DataStoreException)backingStoreException.unwrapOrRethrow(DataStoreException.class);
            }
        }
        return this.components;
    }

    private String canNotRead() {
        return this.message((short)34, this.getDisplayName());
    }

    private void sharedRepository(Path path) {
        if (!this.sharedRepositoryReported) {
            this.sharedRepositoryReported = true;
            this.listeners.warning(this.message((short)36, path), null);
        }
    }

    private String message(short s, Object object) {
        return Resources.forLocale(this.getLocale()).getString(s, object);
    }

    private String readOnly() {
        return Resources.forLocale(this.getLocale()).getString((short)28);
    }

    @Override
    public Resource add(Resource resource) throws ReadOnlyStorageException {
        throw new ReadOnlyStorageException(this.readOnly());
    }

    @Override
    public void remove(Resource resource) throws ReadOnlyStorageException {
        throw new ReadOnlyStorageException(this.readOnly());
    }

    @Override
    public synchronized void close() throws DataStoreException {
        Collection<Resource> collection = this.components;
        if (collection != null) {
            this.components = null;
            DataStoreException dataStoreException = null;
            for (Resource resource : collection) {
                if (!(resource instanceof DataStore)) continue;
                try {
                    ((DataStore)resource).close();
                }
                catch (DataStoreException dataStoreException2) {
                    if (dataStoreException == null) {
                        dataStoreException = dataStoreException2;
                        continue;
                    }
                    dataStoreException.addSuppressed(dataStoreException2);
                }
            }
            if (dataStoreException != null) {
                throw dataStoreException;
            }
        }
    }
}

