/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.io;

import java.io.Flushable;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.io.ChannelData;
import org.apache.sis.util.ArgumentChecks;

public class ChannelDataOutput
extends ChannelData
implements Flushable {
    public final WritableByteChannel channel;

    public ChannelDataOutput(String string, WritableByteChannel writableByteChannel, ByteBuffer byteBuffer) throws IOException {
        super(string, writableByteChannel, byteBuffer);
        this.channel = writableByteChannel;
        byteBuffer.limit(0);
    }

    private void ensureBufferAccepts(int n) throws IOException {
        int n2 = this.buffer.capacity();
        assert (n >= 0 && n <= n2) : n;
        int n3 = this.buffer.position() + n;
        if (n3 > this.buffer.limit()) {
            if (n3 > n2) {
                int n4;
                this.buffer.flip();
                do {
                    if ((n4 = this.channel.write(this.buffer)) != 0) continue;
                    this.onEmptyTransfer();
                } while ((n3 -= n4) > n2);
                this.bufferOffset += (long)this.buffer.position();
                this.buffer.compact();
                assert (n3 >= this.buffer.position());
            }
            this.buffer.limit(n3);
        }
    }

    @Override
    public long getStreamPosition() {
        long l = super.getStreamPosition();
        if (this.getBitOffset() != 0) {
            --l;
        }
        return l;
    }

    public final void writeBit(int n) throws IOException {
        this.writeBits(n, 1);
    }

    public final void writeBits(long l, int n) throws IOException {
        ArgumentChecks.ensureBetween((String)"numBits", (int)0, (int)64, (int)n);
        if (n != 0) {
            int n2 = this.getBitOffset();
            if (n2 != 0) {
                long l2;
                l &= (1L << n) - 1L;
                int n3 = n - (8 - n2);
                if (n3 >= 0) {
                    l2 = l >>> n3;
                    n2 = 0;
                } else {
                    l2 = l << -n3;
                    n2 += n;
                }
                n = n3;
                assert ((l2 & 0xFFFFFFFFFFFFFF00L) == 0L) : l2;
                int n4 = this.buffer.position() - 1;
                this.buffer.put(n4, (byte)((long)this.buffer.get(n4) | l2));
            }
            while (n > 0) {
                long l3;
                if ((n -= 8) >= 0) {
                    l3 = l >>> n;
                } else {
                    l3 = l << -n;
                    n2 = 8 + n;
                }
                this.writeByte((int)l3);
            }
            this.setBitOffset(n2);
        }
    }

    public final void writeByte(int n) throws IOException {
        this.ensureBufferAccepts(1);
        this.buffer.put((byte)n);
    }

    public final void writeShort(int n) throws IOException {
        this.ensureBufferAccepts(2);
        this.buffer.putShort((short)n);
    }

    public final void writeChar(int n) throws IOException {
        this.ensureBufferAccepts(2);
        this.buffer.putChar((char)n);
    }

    public final void writeInt(int n) throws IOException {
        this.ensureBufferAccepts(4);
        this.buffer.putInt(n);
    }

    public final void writeLong(long l) throws IOException {
        this.ensureBufferAccepts(8);
        this.buffer.putLong(l);
    }

    public final void writeFloat(float f) throws IOException {
        this.ensureBufferAccepts(4);
        this.buffer.putFloat(f);
    }

    public final void writeDouble(double d) throws IOException {
        this.ensureBufferAccepts(8);
        this.buffer.putDouble(d);
    }

    public final void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public final void writeShorts(short[] sArray) throws IOException {
        this.writeShorts(sArray, 0, sArray.length);
    }

    public final void writeChars(char[] cArray) throws IOException {
        this.writeChars(cArray, 0, cArray.length);
    }

    public final void writeInts(int[] nArray) throws IOException {
        this.writeInts(nArray, 0, nArray.length);
    }

    public final void writeLongs(long[] lArray) throws IOException {
        this.writeLongs(lArray, 0, lArray.length);
    }

    public final void writeFloats(float[] fArray) throws IOException {
        this.writeFloats(fArray, 0, fArray.length);
    }

    public final void writeDoubles(double[] dArray) throws IOException {
        this.writeDoubles(dArray, 0, dArray.length);
    }

    public final void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 != 0) {
            int n3;
            do {
                n3 = Math.min(this.buffer.capacity(), n2);
                this.ensureBufferAccepts(n3);
                this.buffer.put(byArray, n, n3);
                n += n3;
            } while ((n2 -= n3) != 0);
        } else {
            this.clearBitOffset();
        }
    }

    public final void writeChars(final char[] cArray, int n, int n2) throws IOException {
        new ArrayWriter(){
            private CharBuffer view;

            @Override
            Buffer createView() {
                this.view = ChannelDataOutput.this.buffer.asCharBuffer();
                return this.view;
            }

            @Override
            void transfer(int n, int n2) {
                this.view.put(cArray, n, n2);
            }
        }.writeFully(2, n, n2);
    }

    public final void writeShorts(final short[] sArray, int n, int n2) throws IOException {
        new ArrayWriter(){
            private ShortBuffer view;

            @Override
            Buffer createView() {
                this.view = ChannelDataOutput.this.buffer.asShortBuffer();
                return this.view;
            }

            @Override
            void transfer(int n, int n2) {
                this.view.put(sArray, n, n2);
            }
        }.writeFully(2, n, n2);
    }

    public final void writeInts(final int[] nArray, int n, int n2) throws IOException {
        new ArrayWriter(){
            private IntBuffer view;

            @Override
            Buffer createView() {
                this.view = ChannelDataOutput.this.buffer.asIntBuffer();
                return this.view;
            }

            @Override
            void transfer(int n, int n2) {
                this.view.put(nArray, n, n2);
            }
        }.writeFully(4, n, n2);
    }

    public final void writeLongs(final long[] lArray, int n, int n2) throws IOException {
        new ArrayWriter(){
            private LongBuffer view;

            @Override
            Buffer createView() {
                this.view = ChannelDataOutput.this.buffer.asLongBuffer();
                return this.view;
            }

            @Override
            void transfer(int n, int n2) {
                this.view.put(lArray, n, n2);
            }
        }.writeFully(8, n, n2);
    }

    public final void writeFloats(final float[] fArray, int n, int n2) throws IOException {
        new ArrayWriter(){
            private FloatBuffer view;

            @Override
            Buffer createView() {
                this.view = ChannelDataOutput.this.buffer.asFloatBuffer();
                return this.view;
            }

            @Override
            void transfer(int n, int n2) {
                this.view.put(fArray, n, n2);
            }
        }.writeFully(4, n, n2);
    }

    public final void writeDoubles(final double[] dArray, int n, int n2) throws IOException {
        new ArrayWriter(){
            private DoubleBuffer view;

            @Override
            Buffer createView() {
                this.view = ChannelDataOutput.this.buffer.asDoubleBuffer();
                return this.view;
            }

            @Override
            void transfer(int n, int n2) {
                this.view.put(dArray, n, n2);
            }
        }.writeFully(8, n, n2);
    }

    private void clear() {
        if (this.buffer.hasArray()) {
            int n = this.buffer.arrayOffset();
            Arrays.fill(this.buffer.array(), n + this.buffer.position(), n + this.buffer.limit(), (byte)0);
        } else {
            while (this.buffer.hasRemaining()) {
                this.buffer.put((byte)0);
            }
        }
    }

    @Override
    public final void seek(long l) throws IOException {
        long l2 = JDK8.subtractExact((long)l, (long)this.bufferOffset);
        if (l2 >= 0L && l2 <= (long)this.buffer.limit()) {
            this.buffer.position((int)l2);
            this.clearBitOffset();
        } else if (this.channel instanceof SeekableByteChannel) {
            this.flush();
            ((SeekableByteChannel)this.channel).position(JDK8.addExact((long)this.channelOffset, (long)l));
            this.bufferOffset = l;
        } else if (l2 >= 0L) {
            this.flush();
            if ((l2 -= (long)this.buffer.limit()) <= (long)this.buffer.capacity()) {
                this.buffer.limit((int)l2);
                this.clear();
                this.buffer.position((int)l2);
            } else {
                this.buffer.clear();
                this.clear();
                do {
                    if (this.channel.write(this.buffer) == 0) {
                        this.onEmptyTransfer();
                    }
                    this.bufferOffset += (long)this.buffer.position();
                    this.buffer.rewind();
                } while ((l2 -= (long)this.buffer.position()) > (long)this.buffer.capacity());
                this.buffer.limit((int)l2).position((int)l2);
            }
        } else {
            throw new IOException(Resources.format((short)13, this.filename));
        }
    }

    @Override
    public final void flush() throws IOException {
        this.buffer.rewind();
        this.writeFully();
        this.buffer.limit(0);
        this.clearBitOffset();
    }

    @Override
    final void flushAndSetPosition(int n) throws IOException {
        int n2 = this.buffer.limit();
        this.buffer.rewind().limit(n);
        this.writeFully();
        this.buffer.limit(n2);
    }

    private void writeFully() throws IOException {
        int n;
        int n2;
        this.bufferOffset += (long)n2;
        for (n2 = this.buffer.remaining(); n2 != 0; n2 -= n) {
            n = this.channel.write(this.buffer);
            if (n != 0) continue;
            this.onEmptyTransfer();
        }
        assert (!this.buffer.hasRemaining()) : this.buffer;
    }

    private abstract class ArrayWriter {
        private ArrayWriter() {
        }

        abstract Buffer createView();

        abstract void transfer(int var1, int var2);

        private void skipInBuffer(int n) {
            ChannelDataOutput.this.buffer.position(ChannelDataOutput.this.buffer.position() + n);
        }

        final void writeFully(int n, int n2, int n3) throws IOException {
            ChannelDataOutput.this.clearBitOffset();
            ChannelDataOutput.this.ensureBufferAccepts(Math.min(n3 * n, ChannelDataOutput.this.buffer.capacity()));
            Buffer buffer = this.createView();
            int n4 = Math.min(buffer.remaining(), n3);
            this.transfer(n2, n4);
            this.skipInBuffer(n4 * n);
            while ((n3 -= n4) != 0) {
                ChannelDataOutput.this.ensureBufferAccepts(Math.min(n3, buffer.capacity()) * n);
                buffer.rewind().limit(ChannelDataOutput.this.buffer.remaining() / n);
                n4 = buffer.remaining();
                this.transfer(n2 += n4, n4);
                this.skipInBuffer(n4 * n);
            }
        }
    }
}

