/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.ForwardOnlyStorageException;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.logging.WarningListeners;
import org.apache.sis.util.resources.Errors;

public abstract class ChannelFactory {
    private static final Set<StandardOpenOption> ILLEGAL_OPTIONS = EnumSet.of(StandardOpenOption.APPEND, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.DELETE_ON_CLOSE);

    ChannelFactory() {
    }

    public static ChannelFactory prepare(Object object, String string, boolean bl, OpenOption ... openOptionArray) throws IOException {
        Object object2;
        Set<StandardOpenOption> set;
        block23: {
            if (openOptionArray == null || openOptionArray.length == 0) {
                set = Collections.singleton(StandardOpenOption.READ);
            } else {
                set = new HashSet<OpenOption>(Arrays.asList(openOptionArray));
                set.add(StandardOpenOption.READ);
                if (!bl && set.removeAll(ILLEGAL_OPTIONS)) {
                    throw new IllegalArgumentException(Errors.format((short)45, (Object)"options", (Object)Arrays.toString(openOptionArray)));
                }
            }
            if (object instanceof ReadableByteChannel || bl && object instanceof WritableByteChannel) {
                return new Stream((Channel)object);
            }
            if (object instanceof InputStream) {
                return new Stream(Channels.newChannel((InputStream)object));
            }
            if (bl && object instanceof OutputStream) {
                return new Stream(Channels.newChannel((OutputStream)object));
            }
            if (object instanceof URL) {
                try {
                    object = IOUtilities.toPath((URL)object, string);
                }
                catch (IOException iOException) {
                    ChannelFactory.recoverableException(iOException);
                }
            } else if (object instanceof URI) {
                object2 = (URI)object;
                if (!((URI)object2).isAbsolute()) {
                    throw new IOException(Resources.format((short)11, object2));
                }
                try {
                    object = Paths.get((URI)object2);
                }
                catch (IllegalArgumentException | FileSystemNotFoundException runtimeException) {
                    try {
                        object = ((URI)object2).toURL();
                    }
                    catch (MalformedURLException malformedURLException) {
                        malformedURLException.addSuppressed(runtimeException);
                        throw malformedURLException;
                    }
                    ChannelFactory.recoverableException(runtimeException);
                }
            } else {
                if (object instanceof CharSequence) {
                    object = IOUtilities.toFileOrURL(object.toString(), string);
                }
                if (object instanceof File) {
                    object2 = (File)object;
                    try {
                        object = ((File)object2).toPath();
                    }
                    catch (InvalidPathException invalidPathException) {
                        if (!((File)object2).isFile()) break block23;
                        return new Fallback((File)object2, invalidPathException);
                    }
                }
            }
        }
        if (object instanceof URL) {
            object2 = (URL)object;
            return new ChannelFactory((URL)object2){
                final /* synthetic */ URL val$file;
                {
                    this.val$file = uRL;
                }

                @Override
                public ReadableByteChannel readable(String string, WarningListeners<DataStore> warningListeners) throws IOException {
                    return Channels.newChannel(this.val$file.openStream());
                }

                @Override
                public WritableByteChannel writable(String string, WarningListeners<DataStore> warningListeners) throws IOException {
                    return Channels.newChannel(this.val$file.openConnection().getOutputStream());
                }
            };
        }
        if (object instanceof Path && Files.isRegularFile((Path)(object2 = (Path)object), new LinkOption[0])) {
            return new ChannelFactory((Path)object2, set){
                final /* synthetic */ Path val$path;
                final /* synthetic */ Set val$optionSet;
                {
                    this.val$path = path;
                    this.val$optionSet = set;
                }

                @Override
                public ReadableByteChannel readable(String string, WarningListeners<DataStore> warningListeners) throws IOException {
                    return Files.newByteChannel(this.val$path, this.val$optionSet, new FileAttribute[0]);
                }

                @Override
                public WritableByteChannel writable(String string, WarningListeners<DataStore> warningListeners) throws IOException {
                    return Files.newByteChannel(this.val$path, this.val$optionSet, new FileAttribute[0]);
                }
            };
        }
        return null;
    }

    public boolean isCoupled() {
        return false;
    }

    public boolean canOpen() {
        return true;
    }

    public InputStream inputStream(String string, WarningListeners<DataStore> warningListeners) throws DataStoreException, IOException {
        return Channels.newInputStream(this.readable(string, warningListeners));
    }

    public OutputStream outputStream(String string, WarningListeners<DataStore> warningListeners) throws DataStoreException, IOException {
        return Channels.newOutputStream(this.writable(string, warningListeners));
    }

    public abstract ReadableByteChannel readable(String var1, WarningListeners<DataStore> var2) throws DataStoreException, IOException;

    public abstract WritableByteChannel writable(String var1, WarningListeners<DataStore> var2) throws DataStoreException, IOException;

    private static void recoverableException(Exception exception) {
        Logging.recoverableException((Logger)Logging.getLogger((String)"org.apache.sis.storage"), ChannelFactory.class, (String)"prepare", (Throwable)exception);
    }

    private static final class Fallback
    extends ChannelFactory {
        private final File file;
        private InvalidPathException cause;

        Fallback(File file, InvalidPathException invalidPathException) {
            this.file = file;
            this.cause = invalidPathException;
        }

        @Override
        public FileInputStream inputStream(String string, WarningListeners<DataStore> warningListeners) throws IOException {
            FileInputStream fileInputStream;
            try {
                fileInputStream = new FileInputStream(this.file);
            }
            catch (IOException iOException) {
                if (this.cause != null) {
                    iOException.addSuppressed(this.cause);
                    this.cause = null;
                }
                throw iOException;
            }
            this.warning("inputStream", warningListeners);
            return fileInputStream;
        }

        @Override
        public FileOutputStream outputStream(String string, WarningListeners<DataStore> warningListeners) throws IOException {
            FileOutputStream fileOutputStream;
            try {
                fileOutputStream = new FileOutputStream(this.file);
            }
            catch (IOException iOException) {
                if (this.cause != null) {
                    iOException.addSuppressed(this.cause);
                    this.cause = null;
                }
                throw iOException;
            }
            this.warning("outputStream", warningListeners);
            return fileOutputStream;
        }

        private void warning(String string, WarningListeners<DataStore> warningListeners) {
            if (this.cause != null) {
                LogRecord logRecord = new LogRecord(Level.WARNING, this.cause.toString());
                logRecord.setLoggerName("org.apache.sis.storage");
                logRecord.setSourceMethodName(string);
                logRecord.setSourceClassName(ChannelFactory.class.getName());
                logRecord.setThrown(this.cause);
                this.cause = null;
                if (warningListeners != null) {
                    warningListeners.warning(logRecord);
                } else {
                    Logging.getLogger((String)"org.apache.sis.storage").log(logRecord);
                }
            }
        }

        @Override
        public ReadableByteChannel readable(String string, WarningListeners<DataStore> warningListeners) throws IOException {
            return ((FileInputStream)this.inputStream(string, (WarningListeners)warningListeners)).getChannel();
        }

        @Override
        public WritableByteChannel writable(String string, WarningListeners<DataStore> warningListeners) throws IOException {
            return ((FileOutputStream)this.outputStream(string, (WarningListeners)warningListeners)).getChannel();
        }
    }

    private static final class Stream
    extends ChannelFactory {
        private Channel channel;

        Stream(Channel channel) {
            this.channel = channel;
        }

        @Override
        public boolean isCoupled() {
            return true;
        }

        @Override
        public boolean canOpen() {
            return this.channel != null;
        }

        @Override
        public ReadableByteChannel readable(String string, WarningListeners<DataStore> warningListeners) throws DataStoreException, IOException {
            Channel channel = this.channel;
            if (channel instanceof ReadableByteChannel) {
                this.channel = null;
                return (ReadableByteChannel)channel;
            }
            String string2 = Resources.format(channel != null ? (short)25 : 18, string);
            if (channel != null) {
                throw new IOException(string2);
            }
            throw new ForwardOnlyStorageException(string2);
        }

        @Override
        public WritableByteChannel writable(String string, WarningListeners<DataStore> warningListeners) throws DataStoreException, IOException {
            Channel channel = this.channel;
            if (channel instanceof WritableByteChannel) {
                this.channel = null;
                return (WritableByteChannel)channel;
            }
            String string2 = Resources.format(channel != null ? (short)26 : 21, string);
            if (channel != null) {
                throw new IOException(string2);
            }
            throw new ForwardOnlyStorageException(string2);
        }
    }
}

