/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.util.Citations;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.IllegalNameException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Localized;
import org.apache.sis.util.logging.WarningListener;
import org.apache.sis.util.logging.WarningListeners;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.identification.Identification;
import org.opengis.parameter.ParameterValueGroup;

public abstract class DataStore
implements Resource,
Localized,
AutoCloseable {
    protected final DataStoreProvider provider;
    private final String name;
    private Locale locale;
    protected final WarningListeners<DataStore> listeners;

    protected DataStore() {
        this.provider = null;
        this.name = null;
        this.locale = Locale.getDefault(Locale.Category.DISPLAY);
        this.listeners = new WarningListeners((Object)this);
    }

    protected DataStore(DataStoreProvider dataStoreProvider, StorageConnector storageConnector) throws DataStoreException {
        ArgumentChecks.ensureNonNull((String)"connector", (Object)storageConnector);
        this.provider = dataStoreProvider;
        this.name = storageConnector.getStorageName();
        this.locale = Locale.getDefault(Locale.Category.DISPLAY);
        this.listeners = new WarningListeners((Object)this);
    }

    protected DataStore(DataStore dataStore, StorageConnector storageConnector) throws DataStoreException {
        ArgumentChecks.ensureNonNull((String)"connector", (Object)storageConnector);
        if (dataStore != null) {
            this.provider = dataStore.provider;
            this.locale = dataStore.locale;
            this.listeners = dataStore.listeners;
        } else {
            this.provider = null;
            this.locale = Locale.getDefault(Locale.Category.DISPLAY);
            this.listeners = new WarningListeners((Object)this);
        }
        this.name = storageConnector.getStorageName();
    }

    public DataStoreProvider getProvider() {
        return this.provider;
    }

    public String getDisplayName() {
        return this.name;
    }

    public synchronized Locale getLocale() {
        return this.locale;
    }

    public synchronized void setLocale(Locale locale) {
        ArgumentChecks.ensureNonNull((String)"locale", (Object)locale);
        this.locale = locale;
    }

    public abstract ParameterValueGroup getOpenParameters();

    @Override
    public abstract Metadata getMetadata() throws DataStoreException;

    public Resource findResource(String string) throws DataStoreException {
        ArgumentChecks.ensureNonEmpty((String)"identifier", (CharSequence)string);
        Resource resource = this.findResource(string, this, new IdentityHashMap<Resource, Boolean>());
        if (resource != null) {
            return resource;
        }
        throw new IllegalNameException(Resources.forLocale(this.getLocale()).getString((short)24, this.getDisplayName(), string));
    }

    private Resource findResource(String string, Resource resource, Map<Resource, Boolean> map) throws DataStoreException {
        if (resource != null && map.put(resource, Boolean.TRUE) == null) {
            Metadata metadata = resource.getMetadata();
            if (metadata != null) {
                for (Identification identification : metadata.getIdentificationInfo()) {
                    if (identification == null || !Citations.identifierMatches((Citation)identification.getCitation(), null, (CharSequence)string)) continue;
                    return resource;
                }
            }
            if (resource instanceof Aggregate) {
                Object object = null;
                for (Resource resource2 : ((Aggregate)resource).components()) {
                    Resource resource3 = this.findResource(string, resource2, map);
                    if (resource3 == null) continue;
                    if (object == null) {
                        object = resource3;
                        continue;
                    }
                    throw new IllegalNameException(Resources.forLocale(this.getLocale()).getString((short)23, this.getDisplayName(), string));
                }
                return object;
            }
        }
        return null;
    }

    public void addWarningListener(WarningListener<? super DataStore> warningListener) throws IllegalArgumentException {
        this.listeners.addWarningListener(warningListener);
    }

    public void removeWarningListener(WarningListener<? super DataStore> warningListener) throws NoSuchElementException {
        this.listeners.removeWarningListener(warningListener);
    }

    @Override
    public abstract void close() throws DataStoreException;
}

