/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ServiceLoader;
import org.apache.sis.internal.referencing.LazySet;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.ProbeProviderPair;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.util.ArgumentChecks;

final class DataStoreRegistry {
    private final ServiceLoader<DataStoreProvider> loader;

    public DataStoreRegistry() {
        this.loader = DefaultFactories.createServiceLoader(DataStoreProvider.class);
    }

    public DataStoreRegistry(ClassLoader classLoader) {
        ArgumentChecks.ensureNonNull((String)"loader", (Object)classLoader);
        this.loader = ServiceLoader.load(DataStoreProvider.class, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DataStoreProvider> providers() {
        ServiceLoader<DataStoreProvider> serviceLoader = this.loader;
        synchronized (serviceLoader) {
            final Iterator<DataStoreProvider> iterator = this.loader.iterator();
            return new LazySet((Iterator)new Iterator<DataStoreProvider>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean hasNext() {
                    ServiceLoader serviceLoader = DataStoreRegistry.this.loader;
                    synchronized (serviceLoader) {
                        return iterator.hasNext();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public DataStoreProvider next() {
                    ServiceLoader serviceLoader = DataStoreRegistry.this.loader;
                    synchronized (serviceLoader) {
                        return (DataStoreProvider)iterator.next();
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            });
        }
    }

    public String probeContentType(Object object) throws DataStoreException {
        ArgumentChecks.ensureNonNull((String)"storage", (Object)object);
        ProbeProviderPair probeProviderPair = this.lookup(object, false);
        return probeProviderPair != null ? probeProviderPair.probe.getMimeType() : null;
    }

    public DataStore open(Object object) throws UnsupportedStorageException, DataStoreException {
        ArgumentChecks.ensureNonNull((String)"storage", (Object)object);
        return this.lookup((Object)object, (boolean)true).store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProbeProviderPair lookup(Object object, boolean bl) throws DataStoreException {
        Object object2;
        StorageConnector storageConnector = object instanceof StorageConnector ? (StorageConnector)object : new StorageConnector(object);
        Object object3 = null;
        LinkedList<ProbeProviderPair> linkedList = null;
        try {
            Object object4;
            DataStoreProvider dataStoreProvider;
            Object object5 = this.loader;
            synchronized (object5) {
                object2 = this.loader.iterator();
                dataStoreProvider = object2.hasNext() ? object2.next() : null;
            }
            while (dataStoreProvider != null) {
                object5 = dataStoreProvider.probeContent(storageConnector);
                if (((ProbeResult)object5).isSupported()) {
                    object3 = new ProbeProviderPair(dataStoreProvider, (ProbeResult)object5);
                    linkedList = null;
                    break;
                }
                if (ProbeResult.INSUFFICIENT_BYTES.equals(object5)) {
                    if (linkedList == null) {
                        linkedList = new LinkedList<ProbeProviderPair>();
                    }
                    linkedList.add(new ProbeProviderPair(dataStoreProvider, (ProbeResult)object5));
                } else if (ProbeResult.UNDETERMINED.equals(object5)) {
                    object3 = new ProbeProviderPair(dataStoreProvider, (ProbeResult)object5);
                }
                object4 = this.loader;
                synchronized (object4) {
                    dataStoreProvider = object2.hasNext() ? (DataStoreProvider)object2.next() : null;
                }
            }
            if (linkedList != null) {
                block10: while (!linkedList.isEmpty() && storageConnector.prefetch()) {
                    object5 = linkedList.iterator();
                    while (object5.hasNext()) {
                        object4 = (ProbeProviderPair)object5.next();
                        ((ProbeProviderPair)object4).probe = ((ProbeProviderPair)object4).provider.probeContent(storageConnector);
                        if (((ProbeProviderPair)object4).probe.isSupported()) {
                            object3 = object4;
                            break block10;
                        }
                        if (ProbeResult.INSUFFICIENT_BYTES.equals(((ProbeProviderPair)object4).probe)) continue;
                        if (ProbeResult.UNDETERMINED.equals(((ProbeProviderPair)object4).probe)) {
                            object3 = object4;
                        }
                        object5.remove();
                    }
                }
            }
            if (bl && object3 != null) {
                ((ProbeProviderPair)object3).store = ((ProbeProviderPair)object3).provider.open(storageConnector);
                storageConnector = null;
            }
        }
        finally {
            if (storageConnector != null && storageConnector != object) {
                storageConnector.closeAllExcept(null);
            }
        }
        if (bl && object3 == null) {
            object2 = storageConnector.getStorageName();
            throw new UnsupportedStorageException(null, 14, object2);
        }
        return object3;
    }
}

