/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.otel;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OtelMetricReceiverConfig
extends ModuleConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OtelMetricReceiverConfig.class);
    private String enabledHandlers;
    private String enabledOcRules;

    public List<String> getEnabledHandlers() {
        return this.split(this.enabledHandlers);
    }

    List<String> getEnabledRulesFrom(String handler) {
        Field f;
        try {
            f = ((Object)((Object)this)).getClass().getDeclaredField(String.format("enabled%sRules", StringUtils.capitalize((String)handler)));
        }
        catch (NoSuchFieldException e) {
            if (log.isDebugEnabled()) {
                log.debug("failed to get disabled rule field of {}", (Object)handler, (Object)e);
            }
            return Collections.emptyList();
        }
        f.setAccessible(true);
        try {
            return this.split(f.get((Object)this));
        }
        catch (IllegalAccessException e) {
            log.warn("failed to access disabled rule list of {}", (Object)handler, (Object)e);
            return Collections.emptyList();
        }
    }

    private List<String> split(Object str) {
        return Arrays.stream(Optional.ofNullable(str).orElse("").toString().split(",")).map(String::trim).filter(StringUtil::isNotEmpty).collect(Collectors.toList());
    }
}

