/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.resource.path;

import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class Path
implements Comparable<Path> {
    private final String path;
    private final String prefix;
    private final boolean isPattern;
    private final Pattern regexPattern;

    public Path(@Nonnull String path) {
        this.path = path;
        String string = this.prefix = path.equals("/") ? "/" : path.concat("/");
        if (path.startsWith("glob:")) {
            this.isPattern = true;
            this.regexPattern = Pattern.compile(Path.toRegexPattern(path.substring(5)));
        } else {
            this.isPattern = false;
            this.regexPattern = null;
        }
    }

    public boolean matches(String otherPath) {
        if (this.isPattern) {
            return this.regexPattern.matcher(otherPath).matches();
        }
        return this.path.equals(otherPath) || otherPath.startsWith(this.prefix);
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public int compareTo(@Nonnull Path o) {
        return this.getPath().compareTo(o.getPath());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Path)) {
            return false;
        }
        return this.getPath().equals(((Path)obj).getPath());
    }

    private static String toRegexPattern(String pattern) {
        StringBuilder stringBuilder = new StringBuilder("^");
        int index = 0;
        block4: while (index < pattern.length()) {
            char currentChar = pattern.charAt(index++);
            switch (currentChar) {
                case '*': {
                    if (Path.getCharAtIndex(pattern, index) == '*') {
                        stringBuilder.append(".*");
                        ++index;
                        continue block4;
                    }
                    stringBuilder.append("[^/]*");
                    continue block4;
                }
                case '/': {
                    stringBuilder.append(currentChar);
                    continue block4;
                }
            }
            if (Path.isRegexMeta(currentChar)) {
                stringBuilder.append('\\');
            }
            stringBuilder.append(currentChar);
        }
        return stringBuilder.append('$').toString();
    }

    private static char getCharAtIndex(String string, int index) {
        return index < string.length() ? string.charAt(index) : (char)'\u0000';
    }

    private static boolean isRegexMeta(char character) {
        return ".^$+{[]|()".indexOf(character) != -1;
    }
}

