/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.request;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;

public class RequestUtil {
    @Nonnull
    public static Map<String, Map<String, String>> parserHeader(@Nonnull String value) {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        String[] tokens = value.split(",");
        for (int i = 0; i < tokens.length; ++i) {
            Map<String, String> parMap;
            String[] parameters = tokens[i].split(";");
            String name = parameters[0].trim();
            if (parameters.length > 0) {
                parMap = new HashMap();
                for (int j = 1; j < parameters.length; ++j) {
                    String[] content = parameters[j].split("=", 2);
                    if (content.length > 1) {
                        parMap.put(content[0].trim(), content[1].trim());
                        continue;
                    }
                    parMap.put(content[0].trim(), content[0].trim());
                }
            } else {
                parMap = Collections.emptyMap();
            }
            result.put(name, parMap);
        }
        return result;
    }

    @Nonnull
    public static Map<String, Double> parserAcceptHeader(@Nonnull String value) {
        HashMap<String, Double> result = new HashMap<String, Double>();
        String[] tokens = value.split(",");
        for (int i = 0; i < tokens.length; ++i) {
            String[] parameters = tokens[i].split(";");
            String name = parameters[0];
            Double qVal = new Double(1.0);
            if (parameters.length > 1) {
                for (int j = 1; j < parameters.length; ++j) {
                    String[] content = parameters[j].split("=", 2);
                    if (content.length <= 1 || !"q".equals(content[0])) continue;
                    try {
                        qVal = Double.valueOf(content[1]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (qVal == null) continue;
            result.put(name, qVal);
        }
        return result;
    }

    @Nonnull
    public static String getServletName(@Nonnull Servlet servlet) {
        String name = null;
        if (servlet.getServletConfig() != null) {
            name = servlet.getServletConfig().getServletName();
        }
        if (name == null || name.length() == 0) {
            name = servlet.getServletInfo();
        }
        if (name == null || name.length() == 0) {
            name = servlet.getClass().getName();
        }
        return name;
    }

    @CheckForNull
    public static Object setRequestAttribute(@Nonnull HttpServletRequest request, @Nonnull String name, Object value) {
        Object oldValue = request.getAttribute(name);
        if (value == null) {
            request.removeAttribute(name);
        } else {
            request.setAttribute(name, value);
        }
        return oldValue;
    }

    public static boolean handleIfModifiedSince(@Nonnull SlingHttpServletRequest req, @Nonnull HttpServletResponse resp) {
        boolean responseSet = false;
        long lastModified = req.getResource().getResourceMetadata().getModificationTime();
        if (lastModified != -1L) {
            long modifiedTime = lastModified / 1000L;
            long ims = req.getDateHeader("If-Modified-Since") / 1000L;
            if (modifiedTime <= ims) {
                resp.setStatus(304);
                responseSet = true;
            }
            resp.setDateHeader("Last-Modified", lastModified);
        }
        return responseSet;
    }
}

