/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.wrappers;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.impl.ObjectConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeValueMap
implements ValueMap {
    private final ValueMap properties;
    private final ValueMap defaults;
    private final boolean merge;

    public CompositeValueMap(ValueMap properties, ValueMap defaults) {
        this(properties, defaults, true);
    }

    public CompositeValueMap(ValueMap properties, ValueMap defaults, boolean merge) {
        if (properties == null) {
            throw new IllegalArgumentException("Properties need to be provided");
        }
        this.properties = properties;
        this.defaults = defaults != null ? defaults : ValueMap.EMPTY;
        this.merge = merge;
    }

    @Override
    @Nullable
    public <T> T get(@NotNull String name, @NotNull Class<T> type) {
        Object value = this.get(name);
        if (value == null) {
            return null;
        }
        if (type.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        return ObjectConverter.convert(value, type);
    }

    @Override
    @NotNull
    public <T> T get(@NotNull String name, T defaultValue) {
        Class<?> value = this.get(name, (T)defaultValue.getClass());
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public boolean isEmpty() {
        if (this.defaults.size() > 0 || this.merge && this.properties.size() > 0) {
            return false;
        }
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keySet().contains(key.toString());
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public Object get(Object key) {
        if (this.merge || this.defaults.containsKey(key)) {
            if (this.properties.containsKey(key)) {
                return this.properties.get(key);
            }
            return this.defaults.get(key);
        }
        return null;
    }

    @Override
    public Object put(String aKey, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ?> properties) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> keySet() {
        return this.buildAggregatedMap().keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.buildAggregatedMap().values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.buildAggregatedMap().entrySet();
    }

    private Map<String, Object> buildAggregatedMap() {
        HashMap<String, Object> entries = new HashMap<String, Object>();
        for (Map.Entry entry : this.properties.entrySet()) {
            if (!this.merge && !this.defaults.containsKey(entry.getKey())) continue;
            entries.put((String)entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : this.defaults.entrySet()) {
            if (entries.containsKey(entry.getKey())) continue;
            entries.put((String)entry.getKey(), entry.getValue());
        }
        return entries;
    }
}

